;;; 
;;; Wanderlust -- Yet Another Message Interface on Emacsen.
;;; 
;;; Copyright (C) 1998 Yuuichi Teranishi <teranisi@gohome.org>
;;;
;;; Time-stamp: <99/06/28 16:22:47 teranisi>

;;; This program is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 2, or (at your option)
;;; any later version.
;;;
;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with GNU Emacs; see the file COPYING.  If not, write to the
;;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;;; Boston, MA 02111-1307, USA.
;;;


(if (module-installed-p 'custom)
    (require 'custom))

(defconst wl-appname "Wanderlust")
(defconst wl-version "1.0.3")
(defconst wl-codename "Notorious")

;;;
;;; Customizable Variables
;;;
(defgroup wl nil
  "Wanderlust, a news and mail reading software."
  :group 'news
  :group 'mail)

;;; Emacsen
(defconst wl-on-emacs20 (> emacs-major-version 19))

(defconst wl-on-xemacs (featurep 'xemacs))

(defconst wl-on-nemacs (fboundp 'nemacs-version))

(defconst wl-on-mule (featurep 'mule))

(defconst wl-on-mule3
  (and wl-on-mule (or wl-on-xemacs wl-on-emacs20)))


(eval-when-compile
  (or (fboundp 'locate-data-directory)
      (defun locate-data-directory (a))))

(defvar wl-cs-noconv
  (cond (wl-on-mule3 'binary)
        (wl-on-mule  '*noconv*)
	(wl-on-nemacs '*noconv*)
        (t           nil)))

(defvar wl-cs-autoconv
  (cond (wl-on-mule3 'undecided)
        (wl-on-mule  '*autoconv*)
	(wl-on-nemacs '*autoconv*)
        (t           nil)))

(defvar wl-cs-local
  (cond (wl-on-mule3  'junet)
        (wl-on-mule   '*junet*)
        (wl-on-nemacs '*junet*)
        (t           nil)))

(defvar wl-cs-cache wl-cs-local)

(defvar wl-use-semi (module-installed-p 'mime-view) ; If nil, use tm.
  "*Use SEMI or not")
(defcustom wl-tmp-dir (or (getenv "TMP") (getenv "TEMP") "~/tmp/")
  "*Temp directory to save message, part."
  :type 'directory
  :group 'wl)
(defvar wl-from (if (boundp 'user-mail-address)
		    user-mail-address)
  "*From string used in draft.")
(defcustom wl-organization nil
  "Organization name."
  :type '(choice (const :tag "none" nil)
                 string)
  :group 'wl)
(defcustom wl-icon-dir (if (fboundp 'locate-data-directory)
			(locate-data-directory "wl"))
  "*Icon directory (XEmacs)."
  :type 'directory
  :group 'wl)
(defvar wl-summary-from-func 'wl-summary-default-from
  "*A function for displaying sender (From: field) information.")
(defvar wl-summary-subject-func 'wl-summary-default-subject
  "*A function for displaying subject.")
(defvar wl-summary-subject-filter-func 'wl-summary-default-subject-filter
  "*A filter function for comparing subjects.")

;; Important folders
(defcustom wl-default-folder "%inbox"
  "*Default folder used in wl-summary-goto-folder."
  :type 'string
  :group 'wl)
(defcustom wl-draft-folder "+draft"
  "*Draft folder"
  :type 'string
  :group 'wl)
(defcustom wl-trash-folder "+trash"
  "*Trash folder"
  :type 'string
  :group 'wl)
(defcustom wl-queue-folder "+queue"
  "*Queue folder"
  :type 'string
  :group 'wl)

(defcustom wl-insert-mail-followup-to nil
  "*Insert Mail-Followup-To: field if non-nil."
  :type 'boolean
  :group 'wl)
(defcustom wl-insert-mail-reply-to nil
  "*Insert Mail-Reply-To: field if non-nil."
  :type 'boolean
  :group 'wl)
(defcustom wl-insert-message-id t
  "*Insert Message-ID: field if non-nil."
  :type 'boolean
  :group 'wl)
(defcustom wl-auto-insert-x-face t
  "*Insert X-Face: field automatically"
  :type 'boolean
  :group 'wl)
(defcustom wl-x-face-file "~/.xface"
  "*If file exists and `wl-auto-insert-x-face' is non-nil, 
X-Face field is inserted using its contents."
  :type 'file
  :group 'wl)
(defcustom wl-subscribed-mailing-list nil
  "*Subscribed mailing list. You had better set this variable 
if you set wl-insert-mail-followup-to as t."
  :type '(repeat string)
  :group 'wl)

(defcustom wl-demo t
  "*Display demo at start time."
  :type 'boolean
  :group 'wl)
(defcustom wl-smtp-posting-server "localhost"
  "*SMTP server name to send mail (wl-draft-send-mail-with-smtp)."
  :type 'string
  :group 'wl)
(defcustom wl-smtp-posting-user nil
  "*POP user name to send mail using POP-before-SMTP.
To use POP-before-SMTP,
(setq wl-draft-send-func 'wl-draft-send-mail-with-pop-before-smtp)"
  :type '(choice (const :tag "none" nil)
                 string)
  :group 'wl)
(defcustom wl-nntp-posting-server "localhost"
  "*NNTP server name to post news."
  :type 'string
  :group 'wl)
(defcustom wl-nntp-posting-user nil
  "*NNTP user name to post news for authinfo.
if nil, don't authenticate."
  :type '(choice (const :tag "none" nil)
                 string)
  :group 'wl)
(defcustom wl-fetch-confirm-threshold 30000
  "*Confirm fetching if message size is larger than this value."
  :type 'integer
  :group 'wl)

(defcustom wl-thread-insert-opened nil
  "*Non-nil forces to insert thread as opened in updating."
  :type 'boolean
  :group 'wl)
(defcustom wl-thread-open-reading-thread t
  "*Non-nil forces to open reading thread."
  :type 'boolean
  :group 'wl)

;;;; Hooks
(defvar wl-folder-mode-hook nil
  "A hook called when wanderlust folder mode is started.")
(defvar wl-summary-toggle-disp-on-hook nil
  "A hook called when message is toggled.")
(defvar wl-summary-toggle-disp-off-hook nil
  "A hook called when message is disappeared.")
(defvar wl-summary-toggle-disp-folder-on-hook nil
  "A hook called when folder is toggled.")
(defvar wl-summary-toggle-disp-folder-off-hook nil
  "A hook called when folder is disappeared.")
(defvar wl-summary-mode-hook nil
  "A hook called when summary mode is started.")
(defvar wl-summary-prepared-pre-hook nil
  "A hook called before the summary buffer has been generated.")
(defvar wl-summary-prepared-hook nil
  "A hook called after the summary buffer has been generated.")
(defvar wl-summary-sync-updated-hook nil
  "A hook called when update summary buffer.")
(defvar wl-summary-unread-message-hook nil
  "A hook called when unread message is displayed.")
(defvar wl-summary-edit-petname-hook nil
  "A hook called when petname is is edited.")
(defvar wl-summary-divide-thread-when-subject-changed nil
  "Divide thread when subject is changed.")
(defvar wl-init-hook nil
  "A hook called when initialization is finished.")
(defvar wl-hook nil
  "A hook called when Wanderlust is invoked.")
(defvar wl-reply-hook nil
  "A hook called when replied.")
(defvar wl-mail-setup-hook nil
  "A hook called when Draft is prepared.")
(defvar wl-mail-send-pre-hook nil
  "A hook called just before the mail sending process starts.")
(defvar wl-news-send-pre-hook nil
  "A hook called just before the news sending process starts.")
(defvar wl-message-buffer-created-hook nil
  "A hook called when Message buffer is prepared.")
(defvar wl-message-redisplay-hook nil
  "A hook called when Message is displayed.")
(defvar wl-message-exit-hook nil
  "A hook called when quit message.")
(defvar wl-summary-exit-hook nil
  "A hook called when exit summary mode.")
(defvar wl-highlight-headers-hook nil
  "A hook called when header is highlighted.")
(defvar wl-highlight-message-hook nil
  "A hook called when message is highlighted.")
(defvar wl-exit-hook nil
  "A hook called when exit wanderlust.")
(defvar wl-folder-suspend-hook nil
  "A hook called when suspend wanderlust.")
(defvar wl-auto-check-folder-pre-hook nil
  "A hook called before auto check folders.")
(defvar wl-auto-check-folder-hook nil
  "A hook called when auto check folders.")
(defvar wl-folder-check-entity-pre-hook nil
  "A hook called before check entity.")
(defvar wl-folder-check-entity-hook nil
  "A hook called when check entity.")
(defvar wl-draft-config-exec-hook nil
  "A hook called when execute header-config on draft.")
(defvar wl-summary-expire-pre-hook nil
  "A hook called before expire.")
(defvar wl-summary-expire-hook nil
  "A hook called when expired.")
(defvar wl-summary-archive-pre-hook nil
  "A hook called before archive.")
(defvar wl-summary-archive-hook nil
  "A hook called when archived.")
(defvar wl-folder-update-access-group-hook nil
  "A hook called when update access group folder.")
(defvar wl-draft-cited-hook nil
  "A hook called after a message is cited.")
(defvar wl-draft-insert-x-face-field-hook nil
  "A hook called after a x-face field is inserted.")
(defvar wl-template-mode-hook nil
  "A hook called when template mode is started.")

;;;; functions for draft
(defvar wl-draft-send-func 'wl-draft-normal-send-func
  "A function to send message.")
(defvar wl-draft-send-news-func 'wl-draft-elmo-nntp-send
  "A function to send news.")
(defvar wl-draft-send-mail-func 'wl-draft-send-mail-with-smtp
  "A function to send mail.
Prepared candidates are 'wl-draft-send-mail-with-smtp,
'wl-draft-send-mail-with-qmail and 'wl-draft-send-mail-with-pop-before-smtp.")
(defvar wl-print-buffer-func 'lpr-buffer
  "A function to print current buffer.")
(defvar wl-ps-print-buffer-func 'ps-print-buffer-with-faces
  "A function to print current buffer with ps-print.")

(defvar wl-draft-reply-with-argument-list
  '(("Reply-To" . (("Reply-To") nil nil))
    ("Mail-Reply-To" . (("Mail-Reply-To") nil nil))
    ("From" . (("From") nil nil)))
  "Alist of cons cell of 
('field-name' .  ('fields for To' 'fields for Cc' 'fields for Newsgroups'))
If car of each cons cell exists in original message,
cdr of each cons cell is used for draft message.
Default is for 'reply-to-author'.")
  
(defvar wl-draft-reply-without-argument-list
  '(("Followup-To" . (nil nil ("Followup-To")))
    ("Mail-Followup-To" . (("Mail-Followup-To") nil ("Newsgroups")))
    ("From" . (("From") ("To" "Cc") ("Newsgroups"))))
  "Alist of cons cell of 
('field-name' .  ('fields for To' 'fields for Cc' 'fields for Newsgroups'))
'field-name' is a string.
'fields for ***' is a list of strings.
If car of each cons cell exists in original message,
cdr of each cons cell is used for draft message.
Default is for 'reply-to-all'.")

(defvar wl-draft-always-delete-myself nil
  "*Always delete myself from reciepient if non-nil.")

;;;; 
(defcustom wl-init-file "~/.wl"
  "*User customization setting file."
  :type 'file
  :group 'wl)

(defcustom wl-folders-file "~/.folders"
  "*Folders file"
  :type 'file
  :group 'wl)
(defcustom wl-address-filename "~/.addresses"
  "*Addresses file"
  :type 'file
  :group 'wl)
(defcustom wl-alias-file "~/.im/Aliases"
  "*Alias file for completion"
  :type 'file
  :group 'wl)

(defvar wl-folder-info-save t
  "If non-nil, save elmo-folder-info-alist.")

(defvar wl-default-spec "%"
  "*Default spec")
(defvar wl-summary-unread-mark "!")
(defvar wl-summary-important-mark "$"
  "Mark for important message.")
(defvar wl-summary-new-mark "N"
  "Mark for new message.")
(defvar wl-summary-unread-uncached-mark "U"
  "Mark for unread and uncached message.")
(defvar wl-summary-unread-cached-mark "!"
  "Mark for unread but already cached message.")
(defvar wl-summary-read-uncached-mark "u"
  "Mark for read but uncached message.")

(defcustom wl-summary-fix-timezone "JST"
  "Non-nil forces to fix timezone of summary date."
  :type 'string
  :group 'wl)

(defvar wl-draft-fields
  '("To:" "Cc:" "Bcc:" "FCC:" "Distribution:" "Organization:"
    "Newsgroups:" "Followup-To:" "Mail-Followup-To:" "From:" "Reply-To:") 
  "Fields used in draft mode.")

(defvar wl-draft-prepared-config-alist nil
  "Alist of configuration field on draft prepared.
ex.
'((\"^To: .*wl@lists.airs.net\"
   (\"From\" . wl-from2)
   (template . \"maillist\"))
  (\"^To: .*hogehoge@\"
   (\"From\" . \"Anonymous <hogehoge@aaa.ne.jp>\")
   (body . \"  hello.\\n\"))"
  )

(defvar wl-draft-config-alist nil
  "Alist of configuration field on draft.
ex.
'((\"^To: .*wl@lists.airs.net\"
   (\"From\" . wl-from2)
   (\"Organization\" . wl-organization2))
  (\"^To: .*hogehoge@\"
   (\"From\" . \"Anonymous <hogehoge@aaa.ne.jp>\")
   wl-my-draft-config-func-hoge))"
  )

(defvar wl-draft-prepared-config-matchone nil)
(defvar wl-draft-config-matchone nil)

(defvar wl-template-alist nil
  "Alist of template.")

(defvar wl-template-visible-select t)
(defvar wl-template-confirm nil)
(defvar wl-template-buffer-lines 7)

;; queued sending.
(defcustom wl-draft-enable-queuing t
  "*Non-nil enables queued sending."
  :type 'boolean
  :group 'wl)
(defcustom wl-auto-flush-queue t
  "*If non-nil, sending queue is flushed when network status is toggled."
  :type 'boolean
  :group 'wl)

(defcustom wl-draft-reply-buffer-style 'split
  "'split or 'full"
  :type '(choice (const :tag "split" split)
		 (const :tag "full"  full))
  :group 'wl)

(defgroup wl-summary nil
  "Wanderlust, summary buffer."
  :group 'wl)
(defgroup wl-highlit nil
  "Wanderlust, Highlights."
  :group 'wl)

(defcustom wl-summary-default-number-column 5
  "number of columns in summary buffer."
  :type 'integer
  :group 'wl-summary)
(defvar wl-summary-number-column-alist '(("\\*.*" . 6))
  "Alist of folder and its number column.
If no matches, 'wl-summary-default-number-column' is used.
ex.
'((\"^%inbox@qmail-maildir\" . 9)
  (\"^-.*@news-server\" . 6))")

(defcustom wl-summary-highlight t
  "Non-nil forces Summary buffer to be highlighted."
  :type 'boolean
  :group 'wl-summary
  :group 'wl-highlit)
(defcustom wl-summary-highlight-partial-threshold 1000
  "Summary is not highlighted entirely 
if there are lines more than this value."
  :type 'integer
  :group 'wl-summary
  :group 'wl-highlit)
(defcustom wl-summary-partial-highlight-above-lines 30
  "If Summary has lines more than wl-summary-highlight-partial-threshold,
Summary lines are highlighted partialy above current position."
  :type 'integer
  :group 'wl-summary
  :group 'wl-highlit)
(defcustom wl-summary-cache-use t
  "Non-nil forces wl-summary to use cache file."
  :type 'boolean
  :group 'wl-summary)
(defvar wl-summary-cache-file ".wl-summary-cache"
  "*Cache file for summary mode contents.")
(defvar wl-summary-view-file ".wl-summary-view"
  "*current summary view.")
(defvar wl-thread-top-file ".wl-thread-top"
  "*current thread top entity... obsolete.")
(defvar wl-thread-entity-file ".wl-thread-entity"
  "*thread entities.")
(defvar wl-thread-entity-list-file ".wl-thread-entity-list"
  "*thread top entity list.")

;;;; Preferences
(defgroup wl-pref nil
  "Wanderlust, Preferences."
  :group 'wl)

(defcustom wl-use-petname t
  "*Display petname in summary and default citation title."
  :type 'boolean
  :group 'wl-pref)
(defcustom wl-summary-weekday-name-lang "ja"
  "*Language to display week day."
  :type '(choice (const :tag "ja" "ja")
		 (const :tag "en" "en"))
  :group 'wl-pref)
(defcustom wl-message-id-domain nil
  "*Domain part of Message-ID. Use machine name if nil."
  :type '(choice (const :tag "Use Machine Name" nil)
                 string)
  :group 'wl-pref)
(defcustom wl-break-pages t
  "*Break Pages at ^L."
  :type 'boolean
  :group 'wl-pref)
(defcustom wl-message-scroll-amount 5
  "*Scroll amount by SPC key."
  :type 'integer
  :group 'wl-pref)
(defvar wl-message-window-size '(1 . 4)
  "*Size of summary and message window. cons cell of (Summary : Message).")

(defvar wl-message-sort-field-list '("Return-Path" "Received" "^To" "^Cc" 
				     "Newsgroups" "Subject" "^From")
  "*Sort order of header fields. Each elements are regexp of field name.
(Not valid on tm.)")

(defcustom wl-folder-window-width 20
  "*Width of folder window."
  :type 'integer
  :group 'wl-pref)
(defcustom wl-summary-recenter t
  "*Recenter on redisplay"
  :type 'boolean
  :group 'wl-pref)

(defcustom wl-stay-folder-window nil
  "*Stay folder window when folder is selected if non-nil."
  :type 'boolean
  :group 'wl-pref)
(defcustom wl-reply-subject-prefix "Re: "
  "*Prefix of the subject of the replied message."
  :type 'string
  :group 'wl-pref)
(defcustom wl-folder-many-unsync-threshold 70
  "*Folders which contains messages more than this number are highlighted
with wl-highlight-folder-many-face."
  :type 'integer
  :group 'wl-pref)
(defcustom wl-fcc nil
  "*Folder Carbon Copy."
  :type '(choice (const :tag "disable" nil)
                 string)
  :group 'wl-pref)
(defcustom wl-bcc nil
  "*Blind Carbon Copy."
  :type '(choice (const :tag "disable" nil)
                 string)
  :group 'wl-pref)
(defcustom wl-folder-desktop-name "Desktop"
  "*An implicit name of the folder top entity."
  :type 'string
  :group 'wl-pref)
;(defvar wl-summary-indent-char ?\ 
;  "*Indent character for thread.")
(defcustom wl-summary-indent-length-limit 46
  "*Limit of indent length for thread."
  :type 'integer
  :group 'wl-pref)
(defvar wl-summary-no-from-message "nobody@nowhere?"
  "*A string displayed in summary when no from field exists.")
(defvar wl-summary-no-subject-message "(WL:No Subject in original.)"
  "*A string displayed in summary when no subject field exists.")

(defvar wl-summary-cancel-message "I'd like to cancel my message."
  "*The body content of a cancel message.")
(defcustom wl-summary-width 80
  "*Set summary line width if non nil."
  :type 'integer
  :group 'wl-pref)
(defvar wl-summary-pick-field-default "Body"
  "*Default field for pick.")
(defcustom wl-from-width 17
  "*From width in summary."
  :type 'integer
  :group 'wl-pref)
(defvar wl-mime-charset 'iso-2022-jp
  "*MIME Charset for summary and message.")
(defvar wl-generate-mailer-string-func 'wl-generate-user-agent-string
  "A function to create X-Mailer field string .")
(defcustom wl-highlight-background-mode  (if (boundp 'hilit-background-mode)
					     (or hilit-background-mode 'dark)
					   'dark)
  "*Background mode of highlight (for mule). 'dark or 'light"
  :type '(choice (const :tag "dark"  dark)
		 (const :tag "light" light))
  :group 'wl-pref)
(defvar wl-highlight-x-face-func nil
  "A function to display X-Face.")

(defvar wl-folder-petname-alist nil
  "A list of (realname . petname)")

(defvar wl-use-folder-petname-on-modeline t
  "Use Folder petname on modeline.")

(defcustom wl-qmail-inject-program "/var/qmail/bin/qmail-inject"
  "Location of the qmail-inject program."
  :type 'file
  :group 'wl-pref)

(defvar wl-qmail-inject-args nil
  "Arguments passed to qmail-inject programs.
This should be a list of strings, one string for each argument.

For e.g., if you wish to set the envelope sender address so that bounces
go to the right place or to deal with listserv's usage of that address, you
might set this variable to '(\"-f\" \"you@some.where\").")

(defvar wl-refile-default-from-folder "+from")

(defvar wl-summary-auto-refile-skip-marks 
  (list wl-summary-new-mark
	wl-summary-unread-uncached-mark
	wl-summary-unread-cached-mark)
  "Persistent marks to skip auto-refiling.")

(defvar wl-refile-rule-alist nil
  "Refile rule alist.
e.x.
'(
  (\"From\"
   (\"teranisi@isl.ntt.co.jp\" . \"+teranisi\"))
  (\"x-ml-name\"
   (\"^Wanderlust\"    . \"+wl\")
   (\"^Elips\" . \"+elips\")))
")

(defvar wl-strict-diff-folders '("%inbox")
  "Folders in this list are checked its unsync message number strictly.
For IMAP4 folders only.")

(defvar wl-force-fetch-folders nil
  "Non-nil forces to fetch subfolders when user opened an 'access' folder.")

(defvar wl-auto-check-folder-name nil
  "*The folder specified by this variable will be automatically checked 
at start time.")

(defvar wl-auto-uncheck-folder-list '("\\$.*")
  "All folders that match this list won't be checked when group is 
automatically checked (or desktop is checked).
This value is preceded by wl-auto-check-folder-list.
Each elements are regexp of folder name.")

(defvar wl-auto-check-folder-list nil
  "All folders that match this list are checked when group is 
automatically checked (or desktop is checked).
This value precedes wl-auto-uncheck-folder-list.
Each elements are regexp of folder name.")

(defcustom wl-interactive-send nil
  "*If non-nil, require your confirmation when sending draft message."
  :type 'boolean
  :group 'wl-pref)

(defcustom wl-interactive-exit t
  "*If non-nil, require your confirmation when exiting WL."
  :type 'boolean
  :group 'wl-pref)

(defcustom wl-summary-move-order 'new
  "*The order of priority when move in summary mode.
If this variable is `unread', precede \"U\", \"!\", \"N\" mark.
If this variable is `new', precede \"N\" mark."
  :type '(choice (const :tag "new" new)
		 (const :tag "unread" unread))
  :group 'wl-pref)

(defvar wl-summary-move-direction-downward t)
(defvar wl-summary-move-direction-toggle t
  "*If non-nil, search direction for the next message will be determined
depends on previous search direction. 
It uses wl-summary-move-direction-downward as a direction flag.")

(defvar wl-auto-select-first nil
  "*If non-nil, display selected first message when enter summary.")

(defvar wl-auto-select-next nil
  "*If non-nil, offer to go to the next folder from the end of the previous.")

;; obsolete
;(defvar wl-no-cache-folder-list '("^\\$.*")
;  "All folders that match this list won't be cached when reading messages.
;Each elements are regexp of folder name.")

(defvar wl-no-save-folder-list '("^/.*$")
  "All folders that match this list won't save its msgdb.
Each elements are regexp of folder name.")

(defvar wl-save-folder-list nil
  "All folders that match this list save its msgdb.
Each elements are regexp of folder name.")

(defvar wl-folder-mime-charset-alist
  '(("^-alt\\.chinese" . big5)
    ("^-relcom\\." . koi8-r)
    ("^-tw\\." . big5)
    ("^-han\\." . euc-kr)
    )
  "Charset alist. If no match, wl-mime-charset is used.")

(defvar wl-folder-weekday-name-lang-alist
  '(("^-alt\\.chinese" . "en")
    ("^-relcom\\." . "en")
    ("^-tw\\." . "en")
    ("^-han\\." . "en"))
  "Weekday name lang alist. If no match, wl-summary-weekday-name-lang 
is used.
e.x.
'((\"xemacs-beta$\" . \"en\")
  (\"^-fj\" . \"ja\"))
")

(defvar wl-folder-thread-indent-set-alist
  '(("^-alt\\.chinese" . (2 "+" "+" "|" "-" " "))
    ("^-relcom\\." . (2 "+" "+" "|" "-" " "))
    ("^-tw\\." . (2 "+" "+" "|" "-" " "))
    ("^-han\\." . (2 "+" "+" "|" "-" " ")))
  "Thread indent set alist. 
If no match, following indent set is used.
(wl-thread-indent-level
 wl-thread-have-younger-brother-str
 wl-thread-youngest-child-str
 wl-thread-vertical-str
 wl-thread-horizontal-str
 wl-thread-space-str)
e.x.
'((\"xemacs-beta$\" . (2 \"+\" \"+\" \"|\" \"-\" \" \")))
")

(defvar wl-folder-sync-range-alist '(("^&.*$" . "all"))
  "*Default sync range alist. If no matches, `wl-default-sync-range' is used.")
(defvar wl-default-sync-range  "update"
  "*Default sync range.")
(defvar wl-ask-range t
  "*If non-nil, ask for a range for summary synchronization. 
If nil, always use default.")

(defvar wl-folder-move-cur-folder nil
  "*Non-nil, move to current folder on folder-mode when goto folder.")

(defcustom wl-folder-check-async (not wl-on-nemacs)
  "*Check the folder asynchronous."
  :type 'boolean
  :group 'wl)

(defvar wl-folder-notify-deleted nil
  "*Non-nil, display negative number on folder-mode when message is deleted
in folder. If the value is 'sync, msgdb would be synchronized.")

(defvar wl-summary-exit-next-move t
  "*Non-nil, move to next-unsync or next-entity when exit summary.")

(defvar wl-summary-next-no-unread t
  "*Non-nil, goto next unread folder when goto no unread folder.
 This variable is available to `wl-summary-read'.")

(defvar wl-summary-next-no-unread-command '(wl-summary-read wl-summary-down)
  "*Command list available for `wl-summary-next-no-unread'")

(defvar wl-summary-keep-cursor-command 
  '(wl-summary-goto-folder wl-summary-goto-last-visited-folder)
  "*Command list to keep cursor position when folder is changed to
already existing summary.")

(defvar wl-folder-removed-mark "#<removed>")
(defvar wl-folder-unsubscribe-mark "#")
(defvar wl-delete-folder-alist '(("^-" . remove))
  "*Alist of folder and delete policy. 
Each element is (folder-regexp . policy).

The policy is one of the followings:
'remove or
'null     : remove message.
string    : refile to the specified folder.
'trash or 
otherwise : refile to the `wl-trash-folder'.
ex.
'((\"^%\" . \"%#mh/trash\")
  (\"^-\" . remove)
  (\"^\\\\+\" . trash))
")

(defvar wl-folder-hierarchy-access-folders '("-" "-alt")
  "*Access group folders to make hierarchy structure.")

(defvar wl-folder-init-load-access-folders nil
  "*Access group folders to load folder list on `wl-folder-init'.
If this variable is non-nil,
`wl-folder-init-no-load-access-folders' will be ignored.")

(defvar wl-folder-init-no-load-access-folders nil
  "*Access group folders to not load folder list on `wl-folder-init'.
If `wl-folder-init-load-access-folders' is non-nil,
this variable will be ignored.")

(defvar wl-folder-access-subscribe-alist nil
  "*Subscribe folders to fetching folder entries.
Each element is (group-regexp . (subscribe folder-regexp ...)).
If subscribe is non-nil, subscribe when match folder-regexp.
If subscribe is nil, unsubscribe when match folder-regexp.

ex.
'((\"^-fj$\"   . (t   \"^-fj\\\\.\\\\(editor\\\\|mail\\\\|net\\\\|news\\\\)\"))
  (\"^-comp$\" . (t   \"^-comp\\\\.unix\" \"^-comp\\\\.sys\"))
  (\"^-$\"     . (nil \"^-alt\" \"^-rec\")))
")

;;; For Folder Manager 

(defvar wl-interactive-save-folders t
  "*Non-nil require your confirmation when save folders.")

(defvar wl-fldmgr-make-backup t
  "*Non-nil make backup file when save folders.")

(defvar wl-fldmgr-folders-indent "\t"
  "*Indent string for folders file.")

(defvar wl-fldmgr-sort-func 'wl-fldmgr-sort-standard
  "*A function to sort folder.")

(defvar wl-fldmgr-sort-group-first t)

;;; For Expire and Archive

(defvar wl-expire-alist nil
  "Alist to decide a policy for expire.
Each element is (folder-regexp (number or date) policy).

The policy is one of the followings:
'remove  : remove messsage.
'trash   : refile wl-trash-folder.
string   : refile string folder.
function : call function.

ex.
'((\"^\\\\+ml/wl$\"		(number 500 510) wl-expire-archive-number1 t)
  (\"^\\\\+ml/\"		(number 300 305) wl-expire-archive-number2)
  (\"^\\\\+outbox$\"		(number 300) \"$outbox;lha\")
  (\"^\\\\(\\\\+tmp\\\\|\\\\+trash\\\\)$\"	(date 7) remove)
  (\"^\\\\+misc$\"		(date 14) trash))
")

(defvar wl-archive-alist '((".*" wl-archive-number1))
  "Alist to decide a policy for archive.
Each element is (folder-regexp policy(function)).

ex.
'((\"\\\\+work$\" wl-archive-date)
  (\"\\\\+ml/\"   wl-archive-number1)
  (\".*\"       wl-archive-number2))
")

(defvar wl-summary-expire-reserve-marks
  (list wl-summary-important-mark
	wl-summary-new-mark
	wl-summary-unread-mark
	wl-summary-unread-uncached-mark
	wl-summary-unread-cached-mark)
  "Permanent marks of reserved message when expire.
Don't reserve temporary mark message.

ex.
'all  : reserved all permanent marks.
'none : not reserve permanent marks.
list  : reserved specified permanent marks.
")

(defvar wl-expire-number-with-reserve-marks nil
  "If non-nil, include reserve message when expire by number.")

(defvar wl-expire-add-seen-list t
  "*If non-nil, add seen message list when refile message at expire.")

(defvar wl-expire-use-log nil
  "*If non-nil, write a log when expired.")

(defvar wl-expire-folder-update-msgdb t
  "*Non-nil update summary msgdb when expire on folder mode.")

;; for wl-expire-archive-{number1|number2}
(defvar wl-expire-archive-files 100
  "*The number of one archive folder.")

;; for wl-expire-archive-{number1|number2|date}
(defvar wl-expire-archive-get-folder-func
  'wl-expire-archive-get-folder
  "*A function to get archive folder name.")
(defvar wl-expire-delete-oldmsg-confirm t
  "*If non-nil, require your confirmation when delete old message.")

;; for wl-expire-archive-get-folder
(defvar wl-expire-archive-folder-type 'zip
  "*Archiver type of archive folder.")
(defvar wl-expire-archive-folder-name-fmt "%s-%%05d;%s") ;; $folder-00100;zip
(defvar wl-expire-archive-folder-num-regexp "-\\([0-9]+\\);")
(defvar wl-expire-archive-date-folder-name-fmt "%s-%%04d%%02d;%s")
						;; $folder-199812;zip
(defvar wl-expire-archive-date-folder-num-regexp "-\\([0-9]+\\);")
(defvar wl-expire-archive-folder-prefix nil
  "*Prefix for archive folder.")

;;;; Highlights.

;; highilght about summary
(defcustom wl-highlight-max-summary-lines 10000
  "*If the summary is larger than this lines, don't highlight it."
  :type 'integer
  :group 'wl-highlit)
 
;; highilght about draft and message
(defcustom wl-highlight-body-too t
  "*In addition to header, highlight the body too. if non nil."
  :type 'boolean
  :group 'wl-highlit)

(defcustom wl-highlight-message-header-alist
  '(("Subject[ \t]*:" . wl-highlight-message-important-header-contents)
    ("From[ \t]*:\\|To[ \t]*:" . wl-highlight-message-important-header-contents2)
    ("X-[^ \t]*:\\|User-Agent[ \t]*:" . wl-highlight-message-unimportant-header-contents))
  ""
  :type '(repeat (cons regexp face))
  :group 'wl-highlit)

(defcustom wl-highlight-citation-prefix-regexp 
  "^[>|:} ]*[>|:}]\\([^ \n>]*>\\)?\\|^[^ <\n>]*>"
  "All lines that match this regexp will be highlighted with
 `wl-highlight-message-cited-text-*' face."
  :type 'regexp
  :group 'wl-highlit)

(defcustom wl-highlight-highlight-citation-too nil
  "*Whether the whole citation line should go in the 
  `wl-highlight-citation-face' face.
If nil, the text matched by `wl-highlight-citation-prefix-regexp' is in the
default face, and the remainder of the line is in the 
wl-highlight-message-cited-text face."
  :type 'boolean
  :group 'wl-highlit)

(defcustom wl-highlight-force-citation-header-regexp
  "^>>>.*$\\|^[ \t]*<[^>]*>[ \t]*$"
  "*The pattern to match the prolog of a cited block.
Text in the body of a message which matches this will be displayed in
the `wl-highlight-message-headers' face."
  :type 'regexp
  :group 'wl-highlit)

(defcustom wl-highlight-citation-header-regexp
  (concat "In article.*$\\|In message.*$\\|In the message.*$\\|"
 	  "^At[^\n]+\n[^\n]+wrote:\n\\|" 
 	  "^.*\\(writes\\|wrote\\|said\\):\n")
  "*The pattern to match the prolog of a cited block.
Text in the body of a message which matches this will be displayed in
the `wl-highlight-message-headers' face."
   :type 'regexp
   :group 'wl-highlit)

(defcustom wl-highlight-max-message-size 10000
  "*If the message body is larger than this many chars, don't highlight it.
This is to prevent us from wasting time trying to fontify things like
uuencoded files and large digests.  If this is nil, all messages will
be highlighted."
    :type 'integer
    :group 'wl-highlit)
  
;; highilght about signature (of draft and message)
(defcustom wl-highlight-signature-separator 
  '("\n--+\n" "\n\n--+.*\n*\\'")
  "List of regexps matching signature separator.
It will be verified from head to tail looking for a separator.  
Verification will be done from the end of the buffer.
No need to specify \"^-- $\" in this list, 
because it is verified by default.
This variable can also be a regex. "
  :type '(repeat regexp)
  :group 'wl-highlit)
(defcustom wl-max-signature-size 400
  "*If the signature is larger than this chars, don't treat it as a signature."
  :type 'integer
  :group 'wl-highlit)
  
;; highilght about mouse
(defcustom wl-use-highlight-mouse-line (and wl-on-xemacs window-system)
  "*Highlight mouse line, if non nil."
  :type 'boolean
  :group 'wl-highlit)
 
;; highilght about folder
(defcustom wl-highlight-folder-with-icon 
  (and (featurep 'xemacs)
       (featurep 'xpm))
  "*Highlight folder with icon(XEmacs)."
  :type 'boolean
  :group 'wl-highlit)
(defcustom wl-highlight-group-folder-by-numbers t
  "*Highlight group folder by numbers."
  :type 'boolean
  :group 'wl-highlit)

(defvar wl-highlight-signature-search-func 'wl-highlight-signature-search
  "Function to search signature area in the message body." )

(defvar wl-use-dnd (and wl-on-xemacs
			(featurep 'dragdrop))
  "If Non-nil, support dragdrop feature in XEmacs.")

;;; Internal variables
(defvar wl-init nil)
;;;; automatically set by wl-mime or tm-wl
(defvar wl-mime-decode-with-all-header-func nil)
(defvar wl-mime-decode-func nil)
(defvar wl-editor-mode-func nil)
(defvar wl-edit-again-func nil)
(defvar wl-message-read-func nil)
(defvar wl-message-next-content-func nil)
(defvar wl-message-prev-content-func nil)
(defvar wl-message-play-content-func nil)
(defvar wl-message-extract-content-func nil)
(defvar wl-message-quit-func nil)
(defvar wl-message-button-dispatcher-func nil)
(defvar wl-insert-mail-func nil)
(defvar wl-yank-original-func nil)

;; For disconnected operations.
(defvar wl-plugged-hook nil)
(defvar wl-unplugged-hook nil)
(defvar wl-plugged t)

(defvar wl-plug-state-indicator-on  " [ON] ")
(defvar wl-plug-state-indicator-off " [--] ")
(defvar wl-plug-state-indicator wl-plug-state-indicator-on)

(defvar wl-show-plug-status-on-modeline t)

;; Advanced thread view.  
(defvar wl-thread-indent-level 1
  "*Indent level for thread.")
(defvar wl-thread-have-younger-brother-str "$B(2(B"
  "*A string for thread branch line. It should contain one character.")
(defvar wl-thread-youngest-child-str       "$B(1(B"
  "*A string for thread branch line. It should contain one character.")
(defvar wl-thread-vertical-str             "$B(-(B"
  "*A string for thread branch line. It should contain one character.")
(defvar wl-thread-horizontal-str           "$B(,(B"
  "*A string for thread branch line. It should contain one character.")
(defvar wl-thread-space-str                "$B!!(B"
  "*A string for thread branch line. It should contain one character.")

(defvar wl-highlight-thread-indent-string-regexp "[^\\[]*"
  "* A regexp string for thread indent...for highlight.")

;; folder icons. filename relative to wl-icon-dir
(defvar wl-opened-group-folder-icon "opened.xpm"
  "*Icon file for opened group folder.")
(defvar wl-closed-group-folder-icon "closed.xpm"
  "*Icon file for closed group folder.")
(defvar wl-nntp-folder-icon "news.xpm"
  "*Icon file for nntp folder.")
(defvar wl-imap-folder-icon "imap.xpm"
  "*Icon file for imap folder.")
(defvar wl-pop-folder-icon  "pop.xpm"
  "*Icon file for pop folder.")
(defvar wl-localdir-folder-icon "local.xpm"
  "*Icon file for localdir folder.")
(defvar wl-localnews-folder-icon "localnews.xpm"
  "*Icon file for localnews folder.")
(defvar wl-internal-folder-icon "internal.xpm"
  "*Icon file for internal folder.")
(defvar wl-multi-folder-icon "multi.xpm"
  "*Icon file for multi folder.")
(defvar wl-filter-folder-icon "filter.xpm"
  "*Icon file for filter folder.")
(defvar wl-archive-folder-icon "archive.xpm"
  "*Icon file for archive folder.")
(defvar wl-empty-trash-folder-icon "trash-e.xpm"
  "*Icon file for emptied trash folder.")
(defvar wl-trash-folder-icon "trash.xpm"
  "*Icon file for trash folder.")
(defvar wl-draft-folder-icon "draft.xpm"
  "*Icon file for draft folder.")
(defvar wl-queue-folder-icon "queue.xpm"
  "*Icon file for queue folder.")
(defvar wl-prog-uudecode "uudecode"
  "*uudecode program name")
(defvar wl-prog-uudecode-arg nil
  "*arguments for uudecode program")

(provide 'wl-vars)
