;;;
;;; Wanderlust -- Yet Another Message Interface on Emacsen.
;;;
;;; Copyright (C) 1998 Yuuichi Teranishi <teranisi@gohome.org>
;;;
;;; Time-stamp: <99/05/11 23:18:07 teranisi>

;;; This program is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 2, or (at your option)
;;; any later version.
;;;
;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with GNU Emacs; see the file COPYING.  If not, write to the
;;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;;; Boston, MA 02111-1307, USA.
;;;


;; dummy functions.
(defun set-text-properties (start end properties &optional object))
(defun remove-text-properties (start end properties &optional object))

(defun add-text-properties (start end properties &optional object))
(defun find-file-name-handler (filename operation))
(defun put-text-property (a b c d &optional e) )
(defun get-text-property (a b &optional e) )

(defvar user-mail-address nil)
(defvar mail-send-actions nil)
(defvar mail-default-headers nil)
(defvar mail-citation-hook nil)
(defvar mail-yank-hooks nil)
(defvar mail-mailer-swallows-blank-line nil)

(defvar wl-nemacs-timezone "+0900"
  "Timezone information for date string in nemacs.")

(defun buffer-disable-undo (&optional a) )
(defvar mail-send-actions nil)

;;; emulate required emacs19 functions.
(defun wl-make-date-string ()
  (let ((curtime (current-time-string))
	ret-val)
    (if (string-match
	 "\\([A-Z][a-z][a-z]\\) *\\([A-Z][a-z][a-z]\\) *\\([0-9]+\\) *\\([0-9]+:[0-9]+:[0-9]+\\) *\\([0-9]+\\)" curtime)
	  (setq
	   ret-val
	   (format "%s, %02d %s %s %s %s"
		   (wl-match-string 1 curtime) 
		   (string-to-int (wl-match-string 3 curtime))
		   (wl-match-string 2 curtime) 
		   (wl-match-string 5 curtime)
		   (wl-match-string 4 curtime) wl-nemacs-timezone)))
    (or ret-val (concat "Sun, 0 Jan 0 00:00:00 " wl-nemacs-timezone))))

(defun timezone-last-day-of-month (month year)
  "The last day in MONTH during YEAR."
  (if (and (= month 2) (timezone-leap-year-p year))
      29
    (aref [31 28 31 30 31 30 31 31 30 31 30 31] (1- month))))

;; timezone emulation.
(defvar timezone-months-assoc
  '(("JAN" .  1)("FEB" .  2)("MAR" .  3)
    ("APR" .  4)("MAY" .  5)("JUN" .  6)
    ("JUL" .  7)("AUG" .  8)("SEP" .  9)
    ("OCT" . 10)("NOV" . 11)("DEC" . 12))
  "Alist of first three letters of a month and its numerical representation.")

(defun timezone-make-date-sortable (date) ; ignores timezone.
  (save-match-data
    (when (string-match 
	   "\\([A-Z][a-z][a-z]\\), *\\([0-9]+\\) *\\([A-Z][a-z][a-z]\\) \\([0-9]+\\) *\\([0-9:]+\\) *.*$" date)
      (concat (wl-match-string 4 date)
	      (int-to-string (cdr (assoc (upcase (wl-match-string 3 date)) 
					 timezone-months-assoc)))
	      (wl-match-string 2 date)
	      (wl-match-string 5 date)))))

(defun timezone-leap-year-p (year)
  "Returns t if YEAR is a Gregorian leap year."
  (or (and (zerop  (% year 4))
	   (not (zerop (% year 100))))
      (zerop (% year 400))))

(defun mail-indent-citation ()
  "Modify text just inserted from a message to be cited.
The inserted text should be the region.
When this function returns, the region is again around the modified text.

Normally, indent each nonblank line `mail-indentation-spaces' spaces.
However, if `mail-yank-prefix' is non-nil, insert that prefix on each line."
  (let ((start (point)))
    (mail-yank-clear-headers start (mark t))
    (if (null mail-yank-prefix)
	(indent-rigidly start (mark t) mail-indentation-spaces)
      (save-excursion
	(goto-char start)
	(while (< (point) (mark t))
	  (insert mail-yank-prefix)
	  (forward-line 1))))))

(defun mail-yank-clear-headers (start end)
  (save-excursion
    (goto-char start)
    (if (search-forward "\n\n" end t)
	(save-restriction
	  (narrow-to-region start (point))
	  (goto-char start)
	  (while (let ((case-fold-search t))
		   (re-search-forward mail-yank-ignored-headers nil t))
	    (beginning-of-line)
	    (delete-region (point)
			   (progn (re-search-forward "\n[^ \t]")
				  (forward-char -1)
				  (point))))))))

(defun buffer-disable-undo (&optional a) )

(defmacro save-match-data (&rest body)
  "Execute BODY forms, restoring the global value of the match data."
  (let ((original (make-symbol "match-data")))
    (list 'let (list (list original '(match-data)))
	  (list 'unwind-protect
		(cons 'progn body)
		(list 'store-match-data original)))))

(defun wl-xmas-setup-folder-toolbar ()) ; dummy
(defun wl-xmas-setup-summary ())
(defun wl-xmas-setup-draft-toolbar ())

(defun wl-summary-setup-mouse ())
(defun wl-message-overload-functions ()
  (local-set-key "l" 'wl-message-toggle-disp-summary))

(defun wl-message-wheel-up (event)
  (interactive "e"))
(defun wl-message-wheel-down (event)
  (interactive "e"))


(defun read-event ()
  (setq unread-command-events 
	(read-char-exclusive)))

(defun wl-highlight-folder-current-line (&optional numbers))
(defun wl-highlight-folder-path (folder-path))
(defun wl-highlight-summary (start end))
(defun wl-highlight-folder-group-line (numbers))
(defun wl-highlight-summary-line-string (line mark indent before-indent))
(defun wl-highlight-body-region (beg end))
(defun wl-highlight-message (start end hack-sig &optional body-only))
(defun wl-delete-all-overlays ())
(defun wl-highlight-summary-current-line (&optional smark regexp temp-too))
(defsubst wl-summary-format-date (date-string)
  (let ((month-alist '(("Jan" . "01")
		       ("Feb" . "02")
		       ("Mar" . "03")
		       ("Apr" . "04")
		       ("May" . "05")
		       ("Jun" . "06")
		       ("Jul" . "07")
		       ("Aug" . "08")
		       ("Sep" . "09")
		       ("Oct" . "10")
		       ("Nov" . "11")
		       ("Dec" . "12")))
	year month mday
	wday)
    (if (and date-string
	     (string-match "\\(^[^0-9]*\\)\\([0-9]+\\) +\\([A-Z][a-z]+\\) +\\([0-9]+\\) +\\([0-9]+\\):\\([0-9]+\\).*" date-string))
	(progn
	  (setq month 
		(string-to-int
		 (cdr (assoc (substring date-string 
					(match-beginning 3) 
					(match-end 3))
			     month-alist))))
	  (setq mday
		(string-to-int
		 (substring date-string (match-beginning 2) (match-end 2))))
	  (setq year
		(string-to-int
		 (substring date-string (match-beginning 4) (match-end 4))))
	  (setq wday
		(elmo-date-get-week year month mday))
	  (format 
	   "%02d/%02d(%s)%02d:%02d"
	   month mday wday
	   (string-to-int
	    (substring date-string (match-beginning 5) (match-end 5)))
	   (string-to-int
	    (substring date-string (match-beginning 6) (match-end 6)))))
      "??/??(??)??:??")))

(defun wl-summary-print-destination (msg-num &optional folder))
(defun wl-summary-remove-destination ())

(defun wl-folder-init-icons ()) ; dummy.
(defmacro easy-menu-define (a b c d)
  (` (defvar (, a) nil (, c))))
(defun easy-menu-add (a))
(defun copy-face (a b))
(defun make-face (a))
(defun set-face-foreground (a b))
(defun set-face-background (a b))
(defun set-face-underline-p (a b))
(defun set-face-font (a b))
(defmacro wl-defface (face spec doc &rest args)
  (` (defvar (, face) (, spec) (, doc))))

(defsubst elmo-archive-call-process (prog args &optional output)
  (apply 'call-process prog nil output nil args)
  0)

(defun wl-draft-make-message-id-string ()
  (let ((curtime (current-time-string)))
    (if (string-match "\\([A-Z][a-z][a-z]\\) *\\([A-Z][a-z][a-z]\\) *\\([0-9]+\\) *\\([0-9]+\\):\\([0-9]+\\):\\([0-9]+\\) *\\([0-9]+\\)" curtime)
	(format "<%s%02d.%s%s%s.%d%c@%s>"
		(wl-match-string 7 curtime)
		(or (cdr (assoc 
			  (upcase (wl-match-string 2
						   curtime)) 
			  timezone-months-assoc))
		    0)
		(wl-match-string 4 curtime)
		(wl-match-string 5 curtime)
		(wl-match-string 6 curtime)
		(abs (% (random) 100000))
		(wl-draft-random-alphabet)
		(or wl-message-id-domain 
		    (system-name))))))

(defun delete (elt list)
  "Is this OK???"
  (and list
       (if (equal elt (car list))
	   (cdr list)
	 (let ((rest list)
	       (rrest (cdr list))
	       )
	   (while (and rrest (not (equal elt (car rrest))))
	     (setq rest rrest
		   rrest (cdr rrest))
	     )
	   (rplacd rest (cdr rrest))
	   list))))

(defun wl-draft-mode-setup ()
  (defalias 'wl-draft-mode 'mail-mode))
(defun wl-draft-key-setup ())

;; ??? 
(defvar mime-article/kanji-code-alist
  (list (cons t (mime-charset-to-coding-system default-mime-charset))))
(defalias 'string-to-number 'string-to-int)

(defun wl-draft-overload-functions ()
  (setq mode-line-buffer-identification
	(format "Wanderlust: %s" (buffer-name)))
  (local-set-key "\C-c\C-y" 'wl-draft-yank-original)
  (local-set-key "\C-c\C-s" 'wl-draft-send)
;  (local-set-key "\C-c\C-w" 'wl-draft-insert-signature)
  (local-set-key "\C-c\C-a" 'wl-draft-insert-x-face-field)
  (local-set-key "\C-c\C-c" 'wl-draft-send-and-exit)
  (local-set-key "\C-c\C-k" 'wl-draft-kill)
  (local-set-key "\C-l" 'wl-draft-highlight-and-recenter)
  (local-set-key "\C-i" 'wl-address-complete-address-or-tab)
;  (local-set-key "\C-i" 'wl-complete-address-or-tab)
  (local-set-key "\C-c\C-r" 'wl-caesar-region)
  (local-set-key "\M-t" 'wl-toggle-plugged)
  (local-set-key "\C-c\C-o" 'wl-jump-to-draft-buffer)
  (when wl-show-plug-status-on-modeline
    (setq mode-line-format (wl-make-modeline))))

(defun window-live-p (buffer) t)

(provide 'wl-nemacs)

