;;; mmelmo.el -- mm-backend by ELMO.

;; Copyright 1998,1999,2000 Yuuichi Teranishi <teranisi@gohome.org>

;; Author: Yuuichi Teranishi <teranisi@gohome.org>
;; Keywords: mail, net news
;; Time-stamp: <2000-01-07 00:21:44 teranisi>

;; This file is part of ELMO (Elisp Library for Message Orchestration).

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.
;;
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.
;;

;;; Commentary:
;; 

;;; Code:
;; 

(require 'elmo-vars)
(require 'elmo-util)

(defun mmelmo-get-original-buffer ()
  (save-excursion
    (let (ret-val)
      (if (setq ret-val 
		(get-buffer (concat mmelmo-entity-buffer-name "0")))
	  ret-val
	(set-buffer (setq ret-val
			  (get-buffer-create 
			   (concat mmelmo-entity-buffer-name "0"))))
	(mmelmo-original-mode)
	ret-val))))

(defun mmelmo-cleanup-entity-buffers ()
  "Cleanup entity buffers of mmelmo."
  (mapcar (lambda (x)
	    (if (string-match mmelmo-entity-buffer-name x)
		(kill-buffer x)))
	  (mapcar 'buffer-name (buffer-list))))

(require 'mmbuffer)

(static-if (fboundp 'luna-define-method)
    ;; FLIM 1.13 or later
    (require 'mmelmo-2)
  ;; FLIM 1.12
  (require 'mmelmo-1))

(provide 'mmelmo)

;;; mmelmo.el ends here
