#!/usr/bin/perl

my $list = $ARGV[0];

%regexp = ('email' => '(\S+|\".*\")(@\S+)',
	   'host' => '[\w\.\-]+',
	   'listname' => '[a-z0-9][a-z0-9\-\._]+',
	   'sql_query' => 'SELECT.*',
	   'scenario' => '\w+'
	   );

%default = ('occurrence' => '0-1'
	    );

%param = ('subject' => {'value' => '.+',
			'occurrence' => '1'
			},
	  'visibility' => {'value' => 'conceal|noconceal',
			   'default' => 'conceal'
			   },
	  'topics' => {'value' => '\S+'
		       },
	  'account' => {'value' => '\S+'
			},
	  'lang' => {'value' => 'us|fr|de|es|it|cn-big5|cn-gb',
		     'default' => {'conf' => 'lang'
				   }
		     },
	  'host' => {'value' => $regexp{'host'},
		     'default' => {'conf' => 'host'
				   }
		 },
	  'owner' => {'value' => {'email' => {'value' => $regexp{'email'},
					      'occurrence' => '1'},
				  'reception' => {'value' => 'mail|nomail',
						      'default' => 'mail'},
				      'gecos' => {'value' => '.+'},
				      'info' => {'value' => '.+'},
				      'profile' => {'value' => 'privileged|normal',
						    'default' => 'normal'}
			      },
		      'occurrence' => '1-n'
		      },
	  'editor' => {'value' => {'email' => {'value' => $regexp{'email'},
					       'occurrence' => '1'},
				   'reception' => {'value' => 'mail|nomail',
						   'default' => 'mail'},
				   'gecos' => {'value' => '.+'},
				   'info' => {'value' => '.+'}
			       },
		       'occurrence' => '0-n'
		       },
	  'user_data_source' => {'value' => 'database|file|include',
                                 'default' => 'database'
				 },
          'ttl' => {'value' => '\d+',
		    'default' => 3600 
		    },
	  'include_list' => {'value' => $regexp{'listname'}
			     },
	  'include_sql_query' => {'value' => {'db_type' => {'value' => 'mysql|PgOracle|Sybase',
							    'occurrence' => '1'},
					      'host' => {'value' => $regexp{'host'},
							 'occurrence' => '1'},
					      'db_name' => {'value' => '\w+',
							    'occurrence' => '1'},
					      'user' => {'value' => '\w+',
							 'occurrence' => '1'},
					      'passwd' => {'value' => '.+'},
					      'sql_query' => {'value' => $regexp{'sql_query'},
							      'occurrence' => '1'}
					  },
				  'occurrence' => '0-n'
				  },
	  'include_ldap_query' => {'value' => {'host' => {'value' => $regexp{'host'},
							  'occurrence' => '1'},
					       'port' => {'value' => '\d+'},
					       'user' => {'value' => '\w+'},
					       'password' => {'value' => '.*'},
					       'suffix' => {'value' => '.*'},
					       'filter' => {'value' => '.*',
							    'occurrence' => '1'}
					   },
				   'occurrence' => '0-n'
				   },
	  'include_file' => {'value' => '\S+'
			     },
	  'subscribe' => {'value' => $regexp{'scenario'},
			  'scenario' => 1
			  },
	  'unsubscribe' => {'value' => $regexp{'scenario'},
			    'scenario' => 1
			  },
	  'add' => {'value' => $regexp{'scenario'},
		    'scenario' => 1
			  },
	  'del' => {'value' => $regexp{'scenario'},
		    'scenario' => 1
		    },
	  'remind' => {'value' => $regexp{'scenario'},
		       'scenario' => 1
		    },
	  'send' => {'value' => $regexp{'scenario'},
		     'scenario' => 1
		    },
	  'review' => {'value' => $regexp{'scenario'},
		       'scenario' => 1
		    },
	  'reply_to' => {'value' => '\S+'
			 },
	  'max_size' => {'value' => '\d+',
			 'default' => {'conf' => 'max_size'
				       }
		     },
	  'anonymous_sender' => {'value' => $regexp{'email'}
			     },
	  'custom_header' => {'value' => '\S+:\s+.*',
			      'occurrence' => '0-n'
			      },
	  'custom_subject' => {'value' => '.*'
			       },
	  'footer_type' => {'value' => 'mime|append',
			    'default' => 'mime'
			    },
	  'digest' => {'value' => '[\d,]+\s+\d+:\d+'
		       },
	  'default_user_options' => {'value' => {'reception' => {'value' => 'digest|mail',
								 'default' => 'mail'},
						 'visibility' => {'value' => 'conceal|noconceal'}
					     }
				 },
	  'cookie' => {'value' => '\w+'
		       },
	  'priority' => {'value' => '\w',
			 'default' => 'default' => {'conf' => 'default_list_priority'
						    }
		     },
	  'bounce' => {'value' => {'warn_rate' => {'value' => '\d+'},
				   'halt_rate' => {'value' => '\d+'}
			       }
		   },
	  'archive' => {'value' => {'period' => {'value' => 'day|week|month|quarter|year',
						 'default' => 'week'},
				    'access' => {'value' => 'private|public|owner|closed',
						 'default' => 'owner'}
				}
		    },
	  'web_archive'  => {'value' => {'access' => {'value' => 'private|public|owner|closed|listmaster',
						      'default' => 'public'}
				     }
			 }
	  );

&apply_defaults();

&load($ARGV[0]);

## Apply defaults to params
sub apply_defaults {
    ## Parameters
    foreach my $p (keys %param) {
	## Parameters
	foreach my $d (keys %default) {
	    unless (defined $param{$p}{$d}) {
		$param{$p}{$d} = $default{$d};
	    }
	}
	
	next unless (ref $param{$p}{'value'} eq 'HASH');
	
	## Parameters' keys
	foreach my $k (keys %{$param{$p}{'value'}}) {
	    foreach my $d (keys %default) {
		unless (defined $param{$p}{'value'}{$k}{$d}) {
		    $param{$p}{'value'}{$k}{$d} = $default{$d};
		}
	    }
	}
    }
}

## Load a config file
sub load {
    my $config_file = pop;
    my %admin;
    my (@paragraphs);

    unless (open CONFIG, $config_file) {
	die "Cannot open $config_file";
    }
    
    ## Split in paragraphs
    my $i = 0;
    while (<CONFIG>) {
	if (/^\s*$/) {
	    $i++ if $paragraphs[$i];
	}else {
	    push @{$paragraphs[$i]}, $_;
	}
    }

    for my $index (0..$#paragraphs) {
	my @paragraph = @{$paragraphs[$index]};

	my $pname;

	## Clean paragraph, keep comments
	for my $i (0..$#paragraph) {
	    my $changed = undef;
	    for my $j (0..$#paragraph) {
		if ($paragraph[$j] =~ /^\s*\#/) {
		    push @{$admin{'comment'}}, $paragraph[$j];
		    splice @paragraph, $j, 1;
		    $changed = 1;
		}elsif ($paragraph[$j] =~ /^\s*$/) {
		    splice @paragraph, $j, 1;
		    $changed = 1;
		}

		last if $changed;
	    }

	    last unless $changed;
	}

	## Empty paragraph
	next unless ($#paragraph > -1);
	
	## Look for first valid line
	unless ($paragraph[0] =~ /^\s*(\w+)(\s+.*)?$/) {
	    die "Bad paragraph @paragraph";
	}
	    
	$pname = $1;
	
#	print "Paragraph: $pname\n";

	unless (defined $param{$pname}) {
	    print STDERR "Unknown parameter $pname\n";
	    next;
	}

	## Uniqueness
	if (defined $admin{$pname}) {
	    unless (($param{$pname}{'occurrence'} eq '0-n') or
		    ($param{$pname}{'occurrence'} eq '1-n')) {
		die "Multiple parameter \"$pname\"";
	    }
	}
	
	## Line or Paragraph
	if (ref $param{$pname}{'value'} eq 'HASH') {
	    ## This should be a paragraph
	    unless ($#paragraph > 0) {
		die "Expecting a paragraph for $pname parameter";
	    }
	    
	    ## Skipping first line
	    shift @paragraph;

	    my %hash;
	    for my $i (0..$#paragraph) {	    
		next if ($paragraph[$i] =~ /^\s*\#/);
		
		unless ($paragraph[$i] =~ /^\s*(\w+)\s*/) {
		    die "Bad line $paragraph[$i]";
		}
		
		my $key = $1;
		
		unless (defined $param{$pname}{'value'}{$key}) {
		    print STDERR "Unknown key $key in paragraph $pname\n";
		    next;
		}
		
		unless ($paragraph[$i] =~ /^\s*$key\s+($param{$pname}{'value'}{$key}{'value'})\s*$/i) {
		    die "Bad format \"$paragraph[$i]\" for key \"$key\" in paragraph \"$pname\"";
		}

		$hash{$key} = $1;
	    }

	    ## Apply defaults & Check required keys
	    foreach my $k (keys %{$param{$pname}{'value'}}) {
#		print "\t$pname=>$k\n";

		## Default value
		unless (defined $hash{$k}) {
		    if (defined $param{$pname}{'value'}{$k}{'default'}) {
			$hash{$k} = $param{$pname}{'value'}{$k}{'default'};
		    }
		}

		## Required fields
		if ($param{$pname}{'value'}{$k}{'occurrence'} eq '1') {
		    unless (defined $hash{$k}) {
			die "Missing key \"$k\" in param \"$pname\"";
		    }
		}
	    }

	    ## Should we store it in an array
	    if (($param{$pname}{'occurrence'} eq '0-n') or
		($param{$pname}{'occurrence'} eq '1-n')) {
		push @{$admin{$pname}}, \%hash;
	    }else {
		$admin{$pname} = \%hash;
	    }
	}else {
	    ## This should be a single line
	    unless ($#paragraph == 0) {
		die "Expecting a single line for \"$pname\" parameter";
	    }

	    my $value;
	    unless ($paragraph[0] =~ /^\s*$pname\s+($param{$pname}{'value'})\s*$/i) {
		die "Bad format \"$paragraph[0]\" for parameter \"$pname\"";
	    }
  
	    $value = $1;

	    if (($param{$pname}{'occurrence'} eq '0-n') or
		($param{$pname}{'occurrence'} eq '1-n')) {
		push @{$admin{$pname}}, $value;
	    }else {
		$admin{$pname} = $value;
	    }
	}
    }
    
    close CONFIG;

    ## Apply defaults & check required parameters
    foreach my $p (keys %param) {

	## Defaults
	unless (defined $admin{$p}) {
	    if (defined $param{$p}{'default'}) {
		$admin{$p} = $param{$p}{'default'};
	    }
	}

	## Required fields
	if ($param{$p}{'occurrence'} eq '1') {
	    unless (defined $admin{$p}) {
		die "Missing parameter \"$p\"";
	    }
	}elsif ($param{$p}{'occurrence'} eq '1-n') {
	    unless (defined $admin{$p}) {
		die "Missing parameter \"$p\"";
	    }
	}
    }

}




