# check for perl and modules for SYMPA
#
# Laurent Ghys (Laurent.Ghys@ircam.fr)
#
# Changes
# 12/05/99 [O Salaun] Net-LDAP changed to Netperl-ldap 
# 20/05/99 [L Ghys]   added stuff for CPAN modules

## assume version = 1.0 if not specified.
## 
%versions = ("perl", "5.00403",
             "Net::LDAP", "0.10", 
	     "perl-ldap", "0.10",
	     "Mail::Internet", "1.32", 
	     "MailTools", "1.13",
	     "DBI", "1.06");

### key:left "module" used by SYMPA, 
### right CPAN module.		     
%req_CPAN = ("DB_File" , "DB_FILE",
	     "Locale::Msgcat", "Msgcat",
	     "MD5", "MD5",
	     "Mail::Internet", "MailTools",
	     "IO::Scalar", "IO-stringy",
	     "MIME::Tools", "MIME-Tools",
	     "MIME::Base64", "MIME-Base64");

%opt_CPAN = ("DBI", "DBI",
	     "Net::LDAP",   "perl-ldap");

### main:
print "******* Check perl for SYMPA ********\n";
### REQ perl version
print "\nChecking for PERL version:\n-----------------------------\n";
$rpv = $versions{"perl"};
if ($] ge $versions{"perl"}){
    print "your version of perl is OK ($]  >= $rpv)\n";
} else {
    print "Your version of perl is TOO OLD ($]  < $rpv)\nPlease INSTALL a new one !\n";
}

print "\nChecking for REQUIRED modules:\n------------------------------------------\n";
&check_modules(%req_CPAN);
print "\nChecking for OPTIONAL modules:\n------------------------------------------\n";
&check_modules(%opt_CPAN);

print <<EOM;
******* NOTE *******
You can retrive all theses modules from any CPAN server
(for example ftp://ftp.pasteur.fr/pub/computing/CPAN/CPAN.html)
EOM
###--------------------------
# reports modules status
###--------------------------
sub check_modules {
    my(%todo) = @_;
    my($vs, $v, $rv, $status);

    print "perl module          from CPAN       STATUS\n"; 
    print "-----------          ---------       ------\n";

    foreach $mod (keys (%todo)) {
	printf ("%-20s %-15s", $mod, $todo{$mod});
	$status = &test_module($mod);
	if ($status == 1) {
	    $vs = "$mod" . "::VERSION";
	    $v = $$vs;
	    $rv = $versions{$mod} || "1.0" ;
	    ### OK: check version
	    if ($v ge $rv) {
		printf ("OK (%-6s >= %s)\n", $v, $rv);
		next;
	    } else {
		print "version is too old ($v < $rv).\n";
                print ">>>>>>> You must update \"$todo{$mod}\" to version \"$versions{$todo{$mod}}\" <<<<<<.\n";
	    }
	} elsif ($status eq "nofile") {
	    ### not installed
	    print "seems to be not available on this system.\n";
	} elsif ($status eq "pb_retval") {
	    ### doesn't return 1;
	    print "$mod doesn't return 1 (check it).\n";
	} else {
	    print "$status";
	}
    }
}
###--------------------------
# test if module is there
# (from man perlfunc ...)
###--------------------------
sub test_module {
    my($filename) = @_;
    my($realfilename, $result);

    $filename =~ s/::/\//g;
    $filename .= ".pm";
    return 1 if $INC{$filename};
    
  ITER: {
      foreach $prefix (@INC) {
	  $realfilename = "$prefix/$filename";
	  if (-f $realfilename) {
	      $result = do $realfilename;
	      last ITER;
	  }
      }
      return "nofile";
  }
    return "pb_retval" unless $result;
    return $result;
}
### EOF


