/*  Spruce
 *  Copyright (C) 1999 Susixware
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include "status.h"

extern GtkWidget *frmStatus;

GtkWidget* create_frmStatus (gchar *title)
{
  GtkWidget *frmStatus;
  GtkWidget *fixed;
  GtkWidget *txtStatus;
  GtkWidget *progressbar;

  frmStatus = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_name (frmStatus, "frmStatus");
  gtk_object_set_data (GTK_OBJECT (frmStatus), "frmStatus", frmStatus);
  gtk_widget_set_usize (frmStatus, 300, 125);
  if (title != NULL)
     gtk_window_set_title (GTK_WINDOW (frmStatus), title);
  gtk_window_set_policy (GTK_WINDOW (frmStatus), FALSE, FALSE, FALSE);

  fixed = gtk_fixed_new ();
  gtk_widget_set_name (fixed, "fixed");
  gtk_object_set_data (GTK_OBJECT (frmStatus), "fixed", fixed);
  gtk_widget_show (fixed);
  gtk_container_add (GTK_CONTAINER (frmStatus), fixed);

  txtStatus = gtk_entry_new ();
  gtk_widget_set_name (txtStatus, "txtStatus");
  gtk_object_set_data (GTK_OBJECT (frmStatus), "txtStatus", txtStatus);
  gtk_widget_show (txtStatus);
  gtk_fixed_put (GTK_FIXED (fixed), txtStatus, 8, 8);
  gtk_widget_set_uposition (txtStatus, 8, 8);
  gtk_widget_set_usize (txtStatus, 280, 24);

  progressbar = gtk_progress_bar_new ();
  gtk_widget_set_name (progressbar, "progressbar");
  gtk_object_set_data (GTK_OBJECT (frmStatus), "progressbar", progressbar);
  gtk_widget_show (progressbar);
  gtk_fixed_put (GTK_FIXED (fixed), progressbar, 8, 56);
  gtk_widget_set_uposition (progressbar, 8, 56);
  gtk_widget_set_usize (progressbar, 280, 48);
  gtk_progress_set_show_text (GTK_PROGRESS (progressbar), TRUE);

  return frmStatus;
}
