/*  Spruce
 *  Copyright (C) 1999 Susixware
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef __MIME_H__
#define __MIME_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <gtk/gtk.h>
#undef MIN
#undef MAX
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "parse.h"
#include "mailbox.h"
#include "globals.h"

struct mime_part {
	gchar type[64];
	gchar subtype[64];
	gchar parameter[128];
	gchar encoding[64];
	guint pos,len;

};

gchar* encode_base64 (gchar *, gint *);
gchar* decode_base64 (gchar *, gint *);

gchar *decode_quoted_printable (gchar *message, gint *length);

gchar* encode_uu (gchar *);
gchar* decode_uu (gchar *);

gint mime_detect (gchar *message);
gint mime_parse (gchar *message);
gchar *mime_get_part (gchar *message, gint num, gint *len);
gint mime_parse_content_type (gchar *content_type, gchar *type, gchar *subtype, gchar *parameter);
gint mime_get_parameter_value (gchar *parameter, gchar *in_name, gchar *out);
gint mime_get_first_text(void);
gchar *mime_get_boundary(void);
gint mime_insert_part(gchar **message, gint index, gchar *boundary, gchar *file);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif
