/*  Spruce
 *  Copyright (C) 1999 Susixware
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "gui.h"

/* icons */
#include "xpm/check.xpm"
#include "xpm/new.xpm"
#include "xpm/msave.xpm"
#include "xpm/print.xpm"
#include "xpm/reply.xpm"
#include "xpm/fwd.xpm"
#include "xpm/maddr.xpm"
#include "xpm/del.xpm"
#include "xpm/larrow.xpm"
#include "xpm/rarrow.xpm"

extern gint texticons;

extern GtkWidget *frmMain;
GtkWidget *mnuMailboxes_menu;
GtkWidget *mnuMessage_menu;

GtkWidget* create_frmMain ()
{
  GtkWidget *frmMain;
  GtkWidget *vboxMain;
  GtkWidget *menubar;
  GtkWidget *mnuFile;
  GtkWidget *mnuFile_menu;
  GtkWidget *mnuNew_Message;
  GtkWidget *mnuSave_As;
  GtkWidget *mnuPrint;
  GtkWidget *separator1, *separator2, *separator3, *separator4;
  GtkWidget *separator5, *separator6, *separator7;
  GtkWidget *mnuCheck_Mail;
  GtkWidget *mnuExit;
  GtkWidget *mnuEdit;
  GtkWidget *mnuEdit_menu;
  GtkWidget *mnuAddress_Book;
  GtkWidget *mnuAccounts;
  GtkWidget *mnuFilters;
  GtkWidget *mnuOptions;
  GtkWidget *mnuMailboxes;
  /*GtkWidget *mnuMailboxes_menu;*/
  GtkWidget *mnuMailboxCreate;
  GtkWidget *mnuMailboxDelete;
  GtkWidget *mnuMessage;
  /*GtkWidget *mnuMessage_menu;*/
  GtkWidget *mnuMesgNext;
  GtkWidget *mnuMesgPrevious;
  GtkWidget *mnuMesgReply;
  GtkWidget *mnuMesgForward;
  GtkWidget *mnuMesgOpen;
  GtkWidget *mnuMesgDelete;
  GtkWidget *mnuMesgExpunge;
  GtkWidget *mnuCopy_to;
  GtkWidget *mnuMove_to;
  GtkWidget *mnuMime;
  GtkWidget *mnuMime_menu;
  GtkWidget *mnuMimeSave;
  GtkWidget *mnuHelp;
  GtkWidget *mnuHelp_menu;
  GtkWidget *mnuHelpAbout;
  GtkWidget *mnuHelpManual;
  GtkWidget *hboxBody;
  GtkWidget *txtMessage;
  GtkWidget *vsbMessage;
  GtkWidget *scrlBoxes;
  GtkWidget *treeBoxes;
  GtkWidget *treelocalBoxes, *treelocalBoxes_item;
  GtkWidget *treeremoteBoxes, *treeremoteBoxes_item;
  GtkWidget *treespoolBoxes, *treespoolBoxes_item;
  GtkWidget *scrlMail;
  GtkWidget *clistMail;
  GtkWidget *lblMesgID;
  GtkWidget *lblSender;
  GtkWidget *lblSubject;
  GtkWidget *lblDate;
  GtkAccelGroup *accel_group;  
  GtkWidget *handlebox;
  GtkWidget *toolbar = NULL;
  GtkWidget *iconw;
  GtkWidget *cmdNew, *cmdSave, *cmdReply, *cmdFwd, *cmdAddrbk, *cmdDel;
  GtkWidget *cmdCheckMail, *cmdPrevious, *cmdNext, *cmdPrint;
  GdkBitmap *mask;
  GdkPixmap *icon;
  GtkWidget *scrlMime;
  GtkWidget *clistMime;
  GtkWidget *pan1, *pan2, *pan3;
  GtkTargetEntry target[] = { {"STRING", 0, 1},
  			      {"text/plain", 0, 2}};

  frmMain = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_name (frmMain, "frmMain");
  gtk_object_set_data (GTK_OBJECT (frmMain), "frmMain", frmMain);
  gtk_widget_set_usize (frmMain, 640, 480);
  gtk_signal_connect_object (GTK_OBJECT (frmMain), "destroy",
                             GTK_SIGNAL_FUNC (on_frmMain_destroy),
                             GTK_OBJECT (frmMain));
  gtk_window_set_title (GTK_WINDOW (frmMain), _("Spruce"));
  gtk_window_set_policy (GTK_WINDOW (frmMain), TRUE, TRUE, FALSE);
  gtk_widget_realize(frmMain);
  
  accel_group = gtk_accel_group_new ();
  gtk_window_add_accel_group (GTK_WINDOW (frmMain), accel_group);

  vboxMain = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vboxMain, "vboxMain");
  gtk_object_set_data (GTK_OBJECT (frmMain), "vboxMain", vboxMain);
  gtk_widget_show (vboxMain);
  gtk_container_add (GTK_CONTAINER (frmMain), vboxMain);

  menubar = gtk_menu_bar_new ();
  gtk_widget_set_name (menubar, "menubar");
  gtk_object_set_data (GTK_OBJECT (frmMain), "menubar", menubar);
  gtk_widget_show (menubar);
  gtk_box_pack_start (GTK_BOX (vboxMain), menubar, FALSE, FALSE, 0);

  mnuFile = gtk_menu_item_new_with_label (_("File"));
  gtk_widget_set_name (mnuFile, "mnuFile");
  gtk_object_set_data (GTK_OBJECT (frmMain), "mnuFile", mnuFile);
  gtk_widget_show (mnuFile);
  gtk_container_add (GTK_CONTAINER (menubar), mnuFile);

  mnuFile_menu = gtk_menu_new ();
  gtk_widget_set_name (mnuFile_menu, "mnuFile_menu");
  gtk_object_set_data (GTK_OBJECT (frmMain), "mnuFile_menu", mnuFile_menu);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (mnuFile), mnuFile_menu);

  mnuNew_Message = gtk_menu_item_new_with_label (_("New Message"));
  gtk_widget_set_name (mnuNew_Message, "mnuNew_Message");
  gtk_object_set_data (GTK_OBJECT (frmMain), "mnuNew_Message", mnuNew_Message);
  gtk_widget_show (mnuNew_Message);
  gtk_container_add (GTK_CONTAINER (mnuFile_menu), mnuNew_Message);
  gtk_signal_connect (GTK_OBJECT (mnuNew_Message), "activate",
                      GTK_SIGNAL_FUNC (on_mnuNew_Message_activate),
                      NULL);
  gtk_widget_add_accelerator (mnuNew_Message, "activate", accel_group,
                              GDK_n, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);


  mnuSave_As = gtk_menu_item_new_with_label (_("Save As..."));
  gtk_widget_set_name (mnuSave_As, "mnuSave_As");
  gtk_object_set_data (GTK_OBJECT (frmMain), "mnuSave_As", mnuSave_As);
  gtk_widget_show (mnuSave_As);
  gtk_container_add (GTK_CONTAINER (mnuFile_menu), mnuSave_As);
  gtk_signal_connect (GTK_OBJECT (mnuSave_As), "activate",
                      GTK_SIGNAL_FUNC (on_mnuSave_As_activate),
                      NULL);
  gtk_widget_add_accelerator (mnuSave_As, "activate", accel_group,
                              GDK_s, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

  mnuPrint = gtk_menu_item_new_with_label (_("Print"));
  gtk_widget_set_name (mnuPrint, "mnuPrint");
  gtk_object_set_data (GTK_OBJECT (frmMain), "mnuPrint", mnuPrint);
  gtk_widget_show (mnuPrint);
  gtk_container_add (GTK_CONTAINER (mnuFile_menu), mnuPrint);
  gtk_signal_connect (GTK_OBJECT (mnuPrint), "activate",
                      GTK_SIGNAL_FUNC (on_mnuPrint_activate),
                      NULL);
  gtk_widget_add_accelerator (mnuPrint, "activate", accel_group,
                              GDK_p, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
  

  separator1 = gtk_menu_item_new ();
  gtk_widget_set_name (separator1, "separator1");
  gtk_object_set_data (GTK_OBJECT (frmMain), "separator1", separator1);
  gtk_widget_show (separator1);
  gtk_container_add (GTK_CONTAINER (mnuFile_menu), separator1);

  mnuCheck_Mail = gtk_menu_item_new_with_label (_("Check Mail"));
  gtk_widget_set_name (mnuCheck_Mail, "mnuCheck_Mail");
  gtk_object_set_data (GTK_OBJECT (frmMain), "mnuCheck_Mail", mnuCheck_Mail);
  gtk_widget_show (mnuCheck_Mail);
  gtk_container_add (GTK_CONTAINER (mnuFile_menu), mnuCheck_Mail);
  gtk_signal_connect (GTK_OBJECT (mnuCheck_Mail), "activate",
                      GTK_SIGNAL_FUNC (on_mnuCheck_Mail_activate),
                      NULL);
  /*gtk_widget_add_accelerator (mnuCheck_Mail, "activate", accel_group,
                              GDK_m, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);*/

  separator2 = gtk_menu_item_new ();
  gtk_widget_set_name (separator2, "separator2");
  gtk_object_set_data (GTK_OBJECT (frmMain), "separator2", separator2);
  gtk_widget_show (separator2);
  gtk_container_add (GTK_CONTAINER (mnuFile_menu), separator2);

  mnuExit = gtk_menu_item_new_with_label (_("Exit"));
  gtk_widget_set_name (mnuExit, "mnuExit");
  gtk_object_set_data (GTK_OBJECT (frmMain), "mnuExit", mnuExit);
  gtk_widget_show (mnuExit);
  gtk_container_add (GTK_CONTAINER (mnuFile_menu), mnuExit);
  gtk_signal_connect (GTK_OBJECT (mnuExit), "activate",
                      GTK_SIGNAL_FUNC (on_mnuExit_activate),
                      NULL);
  gtk_widget_add_accelerator (mnuExit, "activate", accel_group,
                              GDK_x, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);


  mnuEdit = gtk_menu_item_new_with_label (_("Edit"));
  gtk_widget_set_name (mnuEdit, "mnuEdit");
  gtk_object_set_data (GTK_OBJECT (frmMain), "mnuEdit", mnuEdit);
  gtk_widget_show (mnuEdit);
  gtk_container_add (GTK_CONTAINER (menubar), mnuEdit);

  mnuEdit_menu = gtk_menu_new ();
  gtk_widget_set_name (mnuEdit_menu, "mnuEdit_menu");
  gtk_object_set_data (GTK_OBJECT (frmMain), "mnuEdit_menu", mnuEdit_menu);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (mnuEdit), mnuEdit_menu);

  mnuAddress_Book = gtk_menu_item_new_with_label (_("Address Book"));
  gtk_widget_set_name (mnuAddress_Book, "mnuAddress_Book");
  gtk_object_set_data (GTK_OBJECT (frmMain), "mnuAddress_Book", mnuAddress_Book);
  gtk_widget_show (mnuAddress_Book);
  gtk_container_add (GTK_CONTAINER (mnuEdit_menu), mnuAddress_Book);
  gtk_signal_connect (GTK_OBJECT (mnuAddress_Book), "activate",
                      GTK_SIGNAL_FUNC (on_mnuAddress_Book_activate),
                      NULL);

  separator3 = gtk_menu_item_new ();
  gtk_widget_set_name (separator3, "separator3");
  gtk_object_set_data (GTK_OBJECT (frmMain), "separator3", separator3);
  gtk_widget_show (separator3);
  gtk_container_add (GTK_CONTAINER (mnuEdit_menu), separator3);

  mnuAccounts = gtk_menu_item_new_with_label (_("Accounts"));
  gtk_widget_set_name (mnuAccounts, "mnuAccounts");
  gtk_object_set_data (GTK_OBJECT (frmMain), "mnuAccounts", mnuAccounts);
  gtk_widget_show (mnuAccounts);
  gtk_container_add (GTK_CONTAINER (mnuEdit_menu), mnuAccounts);
  gtk_signal_connect (GTK_OBJECT (mnuAccounts), "activate",
                      GTK_SIGNAL_FUNC (on_mnuAccounts_activate),
                      NULL);
  
  separator7 = gtk_menu_item_new ();
  gtk_widget_set_name (separator7, "separator7");
  gtk_object_set_data (GTK_OBJECT (frmMain), "separator7", separator7);
  gtk_widget_show (separator7);
  gtk_container_add (GTK_CONTAINER (mnuEdit_menu), separator7);
  
  mnuFilters = gtk_menu_item_new_with_label (_("Filters"));
  gtk_widget_set_name (mnuFilters, "mnuFilters");
  gtk_object_set_data (GTK_OBJECT (frmMain), "mnuFilters", mnuFilters);
  gtk_widget_show (mnuFilters);
  gtk_container_add (GTK_CONTAINER (mnuEdit_menu), mnuFilters);
  gtk_signal_connect (GTK_OBJECT (mnuFilters), "activate",
                      GTK_SIGNAL_FUNC (on_mnuFilters_activate),
                      NULL);

  separator4 = gtk_menu_item_new ();
  gtk_widget_set_name (separator4, "separator4");
  gtk_object_set_data (GTK_OBJECT (frmMain), "separator4", separator4);
  gtk_widget_show (separator4);
  gtk_container_add (GTK_CONTAINER (mnuEdit_menu), separator4);

  mnuOptions = gtk_menu_item_new_with_label (_("Options..."));
  gtk_widget_set_name (mnuOptions, "mnuOptions");
  gtk_object_set_data (GTK_OBJECT (frmMain), "mnuOptions", mnuOptions);
  gtk_widget_show (mnuOptions);
  gtk_container_add (GTK_CONTAINER (mnuEdit_menu), mnuOptions);
  gtk_signal_connect (GTK_OBJECT (mnuOptions), "activate",
                      GTK_SIGNAL_FUNC (on_mnuOptions_activate),
                      NULL);

  mnuMailboxes = gtk_menu_item_new_with_label (_("Mailboxes"));
  gtk_widget_set_name (mnuMailboxes, "mnuMailboxes");
  gtk_object_set_data (GTK_OBJECT (frmMain), "mnuMailboxes", mnuMailboxes);
  gtk_widget_show (mnuMailboxes);
  gtk_container_add (GTK_CONTAINER (menubar), mnuMailboxes);

  mnuMailboxes_menu = gtk_menu_new ();
  gtk_widget_set_name (mnuMailboxes_menu, "mnuMailboxes_menu");
  gtk_object_set_data (GTK_OBJECT (frmMain), "mnuMailboxes_menu", mnuMailboxes_menu);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (mnuMailboxes), mnuMailboxes_menu);

  mnuMailboxCreate = gtk_menu_item_new_with_label (_("Create..."));
  gtk_widget_set_name (mnuMailboxCreate, "mnuMailboxCreate");
  gtk_object_set_data (GTK_OBJECT (frmMain), "mnuMailboxCreate", mnuMailboxCreate);
  gtk_widget_show (mnuMailboxCreate);
  gtk_container_add (GTK_CONTAINER (mnuMailboxes_menu), mnuMailboxCreate);
  gtk_signal_connect (GTK_OBJECT (mnuMailboxCreate), "activate",
                      GTK_SIGNAL_FUNC (on_mnuMailboxCreate_activate),
                      NULL);

  mnuMailboxDelete = gtk_menu_item_new_with_label (_("Delete"));
  gtk_widget_set_name (mnuMailboxDelete, "mnuMailboxDelete");
  gtk_object_set_data (GTK_OBJECT (frmMain), "mnuMailboxDelete", mnuMailboxDelete);
  gtk_widget_show (mnuMailboxDelete);
  gtk_container_add (GTK_CONTAINER (mnuMailboxes_menu), mnuMailboxDelete);
  gtk_signal_connect (GTK_OBJECT (mnuMailboxDelete), "activate",
                      GTK_SIGNAL_FUNC (on_mnuMailboxDelete_activate),
                      NULL);

  mnuMessage = gtk_menu_item_new_with_label (_("Message"));
  gtk_widget_set_name (mnuMessage, "mnuMessage");
  gtk_object_set_data (GTK_OBJECT (frmMain), "mnuMessage", mnuMessage);
  gtk_widget_show (mnuMessage);
  gtk_container_add (GTK_CONTAINER (menubar), mnuMessage);

  mnuMessage_menu = gtk_menu_new ();
  gtk_widget_set_name (mnuMessage_menu, "mnuMessage_menu");
  gtk_object_set_data (GTK_OBJECT (frmMain), "mnuMessage_menu", mnuMessage_menu);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (mnuMessage), mnuMessage_menu);

  mnuMesgNext = gtk_menu_item_new_with_label (_("Next"));
  gtk_widget_set_name (mnuMesgNext, "mnuMesgNext");
  gtk_object_set_data (GTK_OBJECT (frmMain), "mnuMesgNext", mnuMesgNext);
  gtk_widget_show (mnuMesgNext);
  gtk_container_add (GTK_CONTAINER (mnuMessage_menu), mnuMesgNext);
  gtk_signal_connect (GTK_OBJECT (mnuMesgNext), "activate",
                      GTK_SIGNAL_FUNC (on_mnuMesgNext_activate),
                      NULL);
  gtk_widget_add_accelerator (mnuMesgNext, "activate", accel_group,
                              GDK_period, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

  mnuMesgPrevious = gtk_menu_item_new_with_label (_("Previous"));
  gtk_widget_set_name (mnuMesgPrevious, "mnuMesgPrevious");
  gtk_object_set_data (GTK_OBJECT (frmMain), "mnuMesgPrevious", mnuMesgPrevious);
  gtk_widget_show (mnuMesgPrevious);
  gtk_container_add (GTK_CONTAINER (mnuMessage_menu), mnuMesgPrevious);
  gtk_signal_connect (GTK_OBJECT (mnuMesgPrevious), "activate",
                      GTK_SIGNAL_FUNC (on_mnuMesgPrevious_activate),
                      NULL);
  gtk_widget_add_accelerator (mnuMesgPrevious, "activate", accel_group,
                              GDK_comma, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

  separator5 = gtk_menu_item_new ();
  gtk_widget_set_name (separator5, "separator5");
  gtk_object_set_data (GTK_OBJECT (frmMain), "separator5", separator5);
  gtk_widget_show (separator5);
  gtk_container_add (GTK_CONTAINER (mnuMessage_menu), separator5);

  mnuMesgReply = gtk_menu_item_new_with_label (_("Reply"));
  gtk_widget_set_name (mnuMesgReply, "mnuMesgReply");
  gtk_object_set_data (GTK_OBJECT (frmMain), "mnuMesgReply", mnuMesgReply);
  gtk_widget_show (mnuMesgReply);
  gtk_container_add (GTK_CONTAINER (mnuMessage_menu), mnuMesgReply);
  gtk_signal_connect (GTK_OBJECT (mnuMesgReply), "activate",
                      GTK_SIGNAL_FUNC (on_mnuMesgReply_activate),
                      NULL);
  gtk_widget_add_accelerator (mnuMesgReply, "activate", accel_group,
                              GDK_r, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

  mnuMesgForward = gtk_menu_item_new_with_label (_("Forward"));
  gtk_widget_set_name (mnuMesgForward, "mnuMesgForward");
  gtk_object_set_data (GTK_OBJECT (frmMain), "mnuMesgForward", mnuMesgForward);
  gtk_widget_show (mnuMesgForward);
  gtk_container_add (GTK_CONTAINER (mnuMessage_menu), mnuMesgForward);
  gtk_signal_connect (GTK_OBJECT (mnuMesgForward), "activate",
                      GTK_SIGNAL_FUNC (on_mnuMesgForward_activate),
                      NULL);
  gtk_widget_add_accelerator (mnuMesgForward, "activate", accel_group,
                              GDK_f, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

  separator6 = gtk_menu_item_new ();
  gtk_widget_set_name (separator6, "separator6");
  gtk_object_set_data (GTK_OBJECT (frmMain), "separator6", separator6);
  gtk_widget_show (separator6);
  gtk_container_add (GTK_CONTAINER (mnuMessage_menu), separator6);

  mnuMesgOpen = gtk_menu_item_new_with_label (_("Open"));
  gtk_widget_set_name (mnuMesgOpen, "mnuMesgOpen");
  gtk_object_set_data (GTK_OBJECT (frmMain), "mnuMesgOpen", mnuMesgOpen);
  gtk_widget_show (mnuMesgOpen);
  gtk_container_add (GTK_CONTAINER (mnuMessage_menu), mnuMesgOpen);
  gtk_signal_connect (GTK_OBJECT (mnuMesgOpen), "activate",
                      GTK_SIGNAL_FUNC (on_mnuMesgOpen_activate),
                      NULL);
  gtk_widget_add_accelerator (mnuMesgOpen, "activate", accel_group,
                              GDK_o, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

  mnuMesgDelete = gtk_menu_item_new_with_label (_("Delete"));
  gtk_widget_set_name (mnuMesgDelete, "mnuMesgDelete");
  gtk_object_set_data (GTK_OBJECT (frmMain), "mnuMesgDelete", mnuMesgDelete);
  gtk_widget_show (mnuMesgDelete);
  gtk_container_add (GTK_CONTAINER (mnuMessage_menu), mnuMesgDelete);
  gtk_signal_connect (GTK_OBJECT (mnuMesgDelete), "activate",
                      GTK_SIGNAL_FUNC (on_mnuMesgDelete_activate),
                      NULL);
  gtk_widget_add_accelerator (mnuMesgDelete, "activate", accel_group,
                              GDK_d, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

  mnuMesgExpunge = gtk_menu_item_new_with_label (_("Expunge"));
  gtk_widget_set_name (mnuMesgExpunge, "mnuMesgExpunge");
  gtk_object_set_data (GTK_OBJECT (frmMain), "mnuMesgExpunge", mnuMesgExpunge);
  gtk_widget_show (mnuMesgExpunge);
  gtk_container_add (GTK_CONTAINER (mnuMessage_menu), mnuMesgExpunge);
  gtk_signal_connect (GTK_OBJECT (mnuMesgExpunge), "activate",
                      GTK_SIGNAL_FUNC (on_mnuMesgExpunge_activate),
                      NULL);
  gtk_widget_add_accelerator (mnuMesgExpunge, "activate", accel_group,
                              GDK_e, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
  
  mnuCopy_to = gtk_menu_item_new_with_label (_("Copy to..."));
  gtk_widget_set_name (mnuCopy_to, "mnuCopy_to");
  gtk_object_set_data (GTK_OBJECT (frmMain), "mnuCopy_to", mnuCopy_to);
  gtk_widget_show (mnuCopy_to);
  gtk_container_add (GTK_CONTAINER (mnuMessage_menu), mnuCopy_to);
  gtk_signal_connect (GTK_OBJECT (mnuCopy_to), "activate",
                      GTK_SIGNAL_FUNC (on_mnuCopy_to_activate),
                      NULL);
  gtk_widget_add_accelerator (mnuCopy_to, "activate", accel_group,
                              GDK_c, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
  
  mnuMove_to = gtk_menu_item_new_with_label (_("Move to..."));
  gtk_widget_set_name (mnuMove_to, "mnuMove_to");
  gtk_object_set_data (GTK_OBJECT (frmMain), "mnuMove_to", mnuMove_to);
  gtk_widget_show (mnuMove_to);
  gtk_container_add (GTK_CONTAINER (mnuMessage_menu), mnuMove_to);
  gtk_signal_connect (GTK_OBJECT (mnuMove_to), "activate",
                      GTK_SIGNAL_FUNC (on_mnuMove_to_activate),
                      NULL);
  gtk_widget_add_accelerator (mnuMove_to, "activate", accel_group,
                              GDK_m, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

  mnuMime = gtk_menu_item_new_with_label (_("Attachments"));
  gtk_widget_set_name(mnuMime,"mnuMime");
  gtk_object_set_data(GTK_OBJECT(frmMain),"mnuMime",mnuMime);
  gtk_widget_show(mnuMime);
  gtk_container_add(GTK_CONTAINER(menubar),mnuMime);

  mnuMime_menu = gtk_menu_new();
  gtk_widget_set_name(mnuMime_menu,"mnuMime_menu");
  gtk_object_set_data(GTK_OBJECT(frmMain),"mnuMime_menu",mnuMime_menu);
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(mnuMime),mnuMime_menu);

  mnuMimeSave = gtk_menu_item_new_with_label (_("Save"));
  gtk_widget_set_name(mnuMimeSave,"mnuMimeSave");
  gtk_object_set_data(GTK_OBJECT(frmMain),"mnuMimeSave",mnuMimeSave);
  gtk_widget_show(mnuMimeSave);
  gtk_container_add(GTK_CONTAINER(mnuMime_menu),mnuMimeSave);
  gtk_signal_connect(GTK_OBJECT(mnuMimeSave),"activate",GTK_SIGNAL_FUNC(on_mnuMimeSave_activate),NULL);

  mnuHelp = gtk_menu_item_new_with_label (_("Help"));
  gtk_widget_set_name (mnuHelp, "mnuHelp");
  gtk_object_set_data (GTK_OBJECT (frmMain), "mnuHelp", mnuHelp);
  gtk_widget_show (mnuHelp);
  gtk_container_add (GTK_CONTAINER (menubar), mnuHelp);
  gtk_menu_item_right_justify (GTK_MENU_ITEM (mnuHelp));

  mnuHelp_menu = gtk_menu_new ();
  gtk_widget_set_name (mnuHelp_menu, "mnuHelp_menu");
  gtk_object_set_data (GTK_OBJECT (frmMain), "mnuHelp_menu", mnuHelp_menu);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (mnuHelp), mnuHelp_menu);

  mnuHelpAbout = gtk_menu_item_new_with_label (_("About..."));
  gtk_widget_set_name (mnuHelpAbout, "mnuHelpAbout");
  gtk_object_set_data (GTK_OBJECT (frmMain), "mnuHelpAbout", mnuHelpAbout);
  gtk_widget_show (mnuHelpAbout);
  gtk_container_add (GTK_CONTAINER (mnuHelp_menu), mnuHelpAbout);
  gtk_signal_connect (GTK_OBJECT (mnuHelpAbout), "activate",
                      GTK_SIGNAL_FUNC (on_mnuHelpAbout_activate),
                      NULL);

  mnuHelpManual = gtk_menu_item_new_with_label (_("Spruce manual"));
  gtk_widget_set_name (mnuHelpManual, "mnuHelpManual");
  gtk_object_set_data (GTK_OBJECT (frmMain), "mnuHelpManual", mnuHelpManual);
  gtk_widget_show (mnuHelpManual);
  gtk_container_add (GTK_CONTAINER (mnuHelp_menu), mnuHelpManual);
  gtk_signal_connect (GTK_OBJECT (mnuHelpManual), "activate",
                      GTK_SIGNAL_FUNC (on_mnuHelpManual_activate),
                      NULL);


  /* the handlebox with buttons */
  handlebox = gtk_handle_box_new();
  gtk_box_pack_start (GTK_BOX (vboxMain), handlebox, FALSE, FALSE, 0);
  gtk_widget_show(handlebox);
  
  switch (texticons)
  {
     case (TB_TEXT):
        toolbar = gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_TEXT);
        break;
     case (TB_ICONS):
        toolbar = gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);
        break;
     case (TB_BOTH):
        toolbar = gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_BOTH);
        break;
  }

  gtk_toolbar_set_button_relief(GTK_TOOLBAR(toolbar), GTK_RELIEF_NONE);

  gtk_container_set_border_width (GTK_CONTAINER (toolbar), 2);
  gtk_toolbar_set_space_size (GTK_TOOLBAR (toolbar), 1);  
  gtk_container_add (GTK_CONTAINER (handlebox), toolbar);
  gtk_widget_show(toolbar);
  
  icon = gdk_pixmap_create_from_xpm_d (frmMain->window, &mask,
               &frmMain->style->white, check_xpm);
  iconw = gtk_pixmap_new(icon, mask);
  cmdCheckMail = gtk_toolbar_append_element(GTK_TOOLBAR(toolbar),
               GTK_TOOLBAR_CHILD_BUTTON, NULL, _("Check"), _("Check for new mail"), "Private",
               iconw, GTK_SIGNAL_FUNC(on_cmdCheckMail_clicked), toolbar);
  gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));
  
  icon = gdk_pixmap_create_from_xpm_d (frmMain->window, &mask,
               &frmMain->style->white, new_xpm);
  iconw = gtk_pixmap_new(icon, mask);
  cmdNew = gtk_toolbar_append_element(GTK_TOOLBAR(toolbar),
               GTK_TOOLBAR_CHILD_BUTTON, NULL, _("Compose"), _("Compose Message"), "Private",
               iconw, GTK_SIGNAL_FUNC(on_cmdNew_clicked), toolbar);
  /*gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));*/
  
  icon = gdk_pixmap_create_from_xpm_d (frmMain->window, &mask,
               &frmMain->style->white, msave_xpm);
  iconw = gtk_pixmap_new(icon, mask);
  cmdSave = gtk_toolbar_append_element(GTK_TOOLBAR(toolbar),
               GTK_TOOLBAR_CHILD_BUTTON, NULL, _("Save"), _("Save Message"), "Private",
               iconw, GTK_SIGNAL_FUNC(on_cmdSave_clicked), toolbar);
  gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));
  
  icon = gdk_pixmap_create_from_xpm_d (frmMain->window, &mask,
               &frmMain->style->white, print_xpm);
  iconw = gtk_pixmap_new(icon, mask);
  cmdPrint = gtk_toolbar_append_element(GTK_TOOLBAR(toolbar),
               GTK_TOOLBAR_CHILD_BUTTON, NULL, _("Print"), _("Print Message"), "Private",
               iconw, GTK_SIGNAL_FUNC(on_cmdPrintToolbar_clicked), toolbar);
  gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));
  
  icon = gdk_pixmap_create_from_xpm_d (frmMain->window, &mask,
               &frmMain->style->white, reply_xpm);
  iconw = gtk_pixmap_new(icon, mask);
  cmdReply = gtk_toolbar_append_element(GTK_TOOLBAR(toolbar),
               GTK_TOOLBAR_CHILD_BUTTON, NULL, _("Reply"), _("Reply"), "Private",
               iconw, GTK_SIGNAL_FUNC(on_cmdReply_clicked), toolbar);
  /*gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));*/
  
  icon = gdk_pixmap_create_from_xpm_d (frmMain->window, &mask,
               &frmMain->style->white, fwd_xpm);
  iconw = gtk_pixmap_new(icon, mask);
  cmdFwd = gtk_toolbar_append_element(GTK_TOOLBAR(toolbar),
               GTK_TOOLBAR_CHILD_BUTTON, NULL, _("Forward"), _("Forward"), "Private",
               iconw, GTK_SIGNAL_FUNC(on_cmdFwd_clicked), toolbar);
  gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));
  
  icon = gdk_pixmap_create_from_xpm_d (frmMain->window, &mask,
               &frmMain->style->white, maddr_xpm);
  iconw = gtk_pixmap_new(icon, mask);
  cmdAddrbk = gtk_toolbar_append_element(GTK_TOOLBAR(toolbar),
               GTK_TOOLBAR_CHILD_BUTTON, NULL, _("Address"), _("Address book"), "Private",
               iconw, GTK_SIGNAL_FUNC(on_cmdAddrbk_clicked), toolbar);
  gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));
  
  icon = gdk_pixmap_create_from_xpm_d (frmMain->window, &mask,
               &frmMain->style->white, del_xpm);
  iconw = gtk_pixmap_new(icon, mask);
  cmdDel = gtk_toolbar_append_element(GTK_TOOLBAR(toolbar),
               GTK_TOOLBAR_CHILD_BUTTON, NULL, _("Delete"), _("Delete Message"), "Private",
               iconw, GTK_SIGNAL_FUNC(on_cmdDel_clicked), toolbar);
  gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));

  icon = gdk_pixmap_create_from_xpm_d (frmMain->window, &mask,
               &frmMain->style->white, larrow_xpm);
  iconw = gtk_pixmap_new(icon, mask);
  cmdPrevious = gtk_toolbar_append_element(GTK_TOOLBAR(toolbar),
               GTK_TOOLBAR_CHILD_BUTTON, NULL, _("Previous"), _("Previous Message"), "Private",
               iconw, GTK_SIGNAL_FUNC(on_cmdPrevious_clicked), toolbar);
  /*gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));*/
  
  icon = gdk_pixmap_create_from_xpm_d (frmMain->window, &mask,
               &frmMain->style->white, rarrow_xpm);
  iconw = gtk_pixmap_new(icon, mask);
  cmdNext = gtk_toolbar_append_element(GTK_TOOLBAR(toolbar),
               GTK_TOOLBAR_CHILD_BUTTON, NULL, _("Next"), _("Next Message"), "Private",
               iconw, GTK_SIGNAL_FUNC(on_cmdNext_clicked), toolbar);
  /*gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));*/
  
  /* first, declare three paned windows:
        +--------------------------------------------------+
        | +-----------+----------------------------------+ |
        | |           |                                  | |
        | | boxes     |  list                            | |
        | |           2                                  | |
        | +-----------+----------------------------------+ |
        +------------------------------------------------1-+
        | +----------------------------------------------+ |
        | |                                              | |
        | | body                                         | |
        | |                                              | |
        | |                                              | |
        | +--------------------------------------------3-+ |
        | | mime                                         | |
        | |                                              | |
        | +----------------------------------------------+ |
        +--------------------------------------------------+ */
  pan1 = gtk_vpaned_new(); /* the main paned window */
  pan2 = gtk_hpaned_new(); /* mailboxes left, headers right */
  pan3 = gtk_vpaned_new(); /* message body top, attachments below */
  gtk_box_pack_start (GTK_BOX (vboxMain), pan1, TRUE, TRUE, 0);
  gtk_paned_pack1 (GTK_PANED (pan1), pan2, TRUE, FALSE);
  gtk_paned_pack2 (GTK_PANED (pan1), pan3, TRUE, FALSE);
  gtk_widget_show (pan3);
  gtk_widget_show (pan2);
  gtk_widget_show (pan1);
  gtk_paned_set_position (GTK_PANED (pan2), 148); /* not too much room for the mailboxes */
  
  /* the mailboxes */
  scrlBoxes = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_set_name (scrlBoxes, "scrlBoxes");
  gtk_object_set_data (GTK_OBJECT (frmMain), "scrlBoxes", scrlBoxes);
  gtk_widget_show (scrlBoxes);
  gtk_paned_pack1 (GTK_PANED (pan2), scrlBoxes, TRUE, FALSE);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrlBoxes), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_widget_set_usize(scrlBoxes, 130, 0); /* limit pane width */

  /*clistBoxes = gtk_clist_new (1);
  gtk_widget_set_name (clistBoxes, "clistBoxes");
  gtk_object_set_data (GTK_OBJECT (frmMain), "clistBoxes", clistBoxes);
  gtk_widget_show (clistBoxes);
  gtk_container_add (GTK_CONTAINER (scrlBoxes), clistBoxes);
  gtk_signal_connect_object (GTK_OBJECT (clistBoxes), "select_row",
                             GTK_SIGNAL_FUNC (on_clistBoxes_select_row),
                             GTK_OBJECT (clistBoxes));
  gtk_signal_connect_object (GTK_OBJECT (clistBoxes), "button_press_event",
                             GTK_SIGNAL_FUNC (on_clistBoxes_clicked),
                             GTK_OBJECT (clistBoxes));
  gtk_signal_connect(GTK_OBJECT(clistBoxes),"drag_data_received",GTK_SIGNAL_FUNC(on_clistBoxes_drag_data_recieved),NULL);
  gtk_drag_dest_set(clistBoxes,GTK_DEST_DEFAULT_ALL,target,2,GDK_ACTION_MOVE | GDK_ACTION_COPY);
  gtk_clist_set_column_width (GTK_CLIST (clistBoxes), 0, 80);
  gtk_clist_column_titles_hide (GTK_CLIST (clistBoxes));*/
  
  treeBoxes = gtk_tree_new();
  gtk_widget_set_name (treeBoxes, "treeBoxes");
  gtk_object_set_data (GTK_OBJECT(frmMain), "treeBoxes", treeBoxes);
  gtk_widget_show (treeBoxes);
  gtk_signal_connect (GTK_OBJECT(treeBoxes), "selection_changed", 
                      GTK_SIGNAL_FUNC(on_treeBoxes_selection_changed), treeBoxes);
  /* we may not want the Root trees to catch these signals since:
     left click: select
     middle click: expand
     right click: collapse */
  /*gtk_signal_connect (GTK_OBJECT(treeBoxes), "button_press_event", 
                      GTK_SIGNAL_FUNC(on_treeBoxes_clicked), treeBoxes);*/
  gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW(scrlBoxes), treeBoxes);

  treelocalBoxes_item = gtk_tree_item_new_with_label (_("Local Mailboxes"));
  gtk_widget_set_name (treelocalBoxes_item, "treelocalBoxes_item");
  gtk_object_set_data (GTK_OBJECT(frmMain), "treelocalBoxes_item", treelocalBoxes_item);
  gtk_tree_append (GTK_TREE(treeBoxes), treelocalBoxes_item);
  gtk_widget_show (treelocalBoxes_item);

  treelocalBoxes = gtk_tree_new();
  gtk_widget_set_name (treelocalBoxes, "treelocalBoxes");
  gtk_object_set_data (GTK_OBJECT(frmMain), "treelocalBoxes", treelocalBoxes);
  gtk_widget_show (treelocalBoxes);
  gtk_tree_item_set_subtree (GTK_TREE_ITEM(treelocalBoxes_item), treelocalBoxes);
  gtk_tree_item_expand (GTK_TREE_ITEM(treelocalBoxes_item));
  
  treeremoteBoxes_item = gtk_tree_item_new_with_label (_("Remote Mailboxes"));
  gtk_widget_set_name (treeremoteBoxes_item, "treeremoteBoxes_item");
  gtk_object_set_data (GTK_OBJECT(frmMain), "treeremoteBoxes_item", treeremoteBoxes_item);
  gtk_tree_append (GTK_TREE(treeBoxes), treeremoteBoxes_item);
  gtk_widget_show (treeremoteBoxes_item);

  treeremoteBoxes = gtk_tree_new();
  gtk_widget_set_name (treeremoteBoxes, "treeremoteBoxes");
  gtk_object_set_data (GTK_OBJECT(frmMain), "treeremoteBoxes", treeremoteBoxes);
  gtk_widget_show (treeremoteBoxes);
  gtk_tree_item_set_subtree(GTK_TREE_ITEM(treeremoteBoxes_item), treeremoteBoxes);

  treespoolBoxes_item = gtk_tree_item_new_with_label (_("Local Spool"));
  gtk_widget_set_name (treespoolBoxes_item, "treespoolBoxes_item");
  gtk_object_set_data (GTK_OBJECT(frmMain), "treespoolBoxes_item", treespoolBoxes_item);
  gtk_tree_append (GTK_TREE(treeBoxes), treespoolBoxes_item);
  gtk_widget_show (treespoolBoxes_item);

  treespoolBoxes = gtk_tree_new();
  gtk_widget_set_name (treespoolBoxes, "treespoolBoxes");
  gtk_object_set_data (GTK_OBJECT(frmMain), "treespoolBoxes", treespoolBoxes);
  gtk_widget_show (treespoolBoxes);
  gtk_tree_item_set_subtree(GTK_TREE_ITEM(treespoolBoxes_item), treespoolBoxes);
  
  /* the mail headers */
  scrlMail = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_set_name (scrlMail, "scrlMail");
  gtk_object_set_data (GTK_OBJECT (frmMain), "scrlMail", scrlMail);
  gtk_widget_show (scrlMail);
  gtk_paned_pack2 (GTK_PANED (pan2), scrlMail, TRUE, TRUE);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrlMail), GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);

  clistMail = gtk_clist_new (4);
  gtk_clist_set_selection_mode(GTK_CLIST(clistMail), GTK_SELECTION_EXTENDED);
  gtk_widget_set_name (clistMail, "clistMail");
  gtk_object_set_data (GTK_OBJECT (frmMain), "clistMail", clistMail);
  gtk_widget_show (clistMail);
  gtk_container_add (GTK_CONTAINER (scrlMail), clistMail);
  gtk_signal_connect_object (GTK_OBJECT (clistMail), "select_row",
                             GTK_SIGNAL_FUNC (on_clistMail_select_row),
                             GTK_OBJECT (clistMail));
  gtk_signal_connect_object (GTK_OBJECT (clistMail), "button_press_event",
                             GTK_SIGNAL_FUNC (on_clistMail_clicked),
                             GTK_OBJECT (clistMail));
  gtk_signal_connect_object (GTK_OBJECT (clistMail), "click_column",
                             GTK_SIGNAL_FUNC (on_clistMail_click_column),
                             GTK_OBJECT (clistMail));
  gtk_signal_connect(GTK_OBJECT(clistMail),"drag_data_get",GTK_SIGNAL_FUNC(on_clistMail_drag_data_get),NULL);
  gtk_drag_source_set(clistMail,GDK_BUTTON1_MASK,target,2,GDK_ACTION_MOVE | GDK_ACTION_COPY);
  gtk_clist_set_column_width (GTK_CLIST (clistMail), 0, 14);
  gtk_clist_set_column_width (GTK_CLIST (clistMail), 1, 120);
  gtk_clist_set_column_width (GTK_CLIST (clistMail), 2, 225);
  gtk_clist_set_column_width (GTK_CLIST (clistMail), 3, 75);
  gtk_clist_column_titles_show (GTK_CLIST (clistMail));
  /* set the default compare function */
  gtk_clist_set_compare_func (GTK_CLIST (clistMail), id_compare);
  
  /* a hbox for the message body and a scrollbar */
  hboxBody = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hboxBody, "hboxBody");
  gtk_object_set_data (GTK_OBJECT (frmMain), "hboxBody", hboxBody);
  gtk_widget_show (hboxBody);
  gtk_paned_pack1 (GTK_PANED (pan3), hboxBody, TRUE, FALSE);

  txtMessage = gtk_text_new (NULL, NULL);
  gtk_text_set_word_wrap (GTK_TEXT(txtMessage), TRUE);
  gtk_widget_set_name (txtMessage, "txtMessage");
  gtk_object_set_data (GTK_OBJECT (frmMain), "txtMessage", txtMessage);
  gtk_widget_show (txtMessage);
  gtk_box_pack_start (GTK_BOX (hboxBody), txtMessage, TRUE, TRUE, 0);
  gtk_signal_connect_object (GTK_OBJECT (txtMessage), "button_press_event",
                             GTK_SIGNAL_FUNC (on_txtMessage_clicked), 
                             GTK_OBJECT(txtMessage));
  

  vsbMessage = gtk_vscrollbar_new (GTK_TEXT(txtMessage)->vadj);
  gtk_widget_set_name (vsbMessage, "vsbMessage");
  gtk_object_set_data (GTK_OBJECT (frmMain), "vsbMessage", vsbMessage);
  gtk_widget_show (vsbMessage);
  gtk_box_pack_start (GTK_BOX (hboxBody), vsbMessage, FALSE, TRUE, 0);
  
  /* a box for mime attachments */
  scrlMime = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_set_name (scrlMime, "scrlMime");
  gtk_object_set_data (GTK_OBJECT (frmMain), "scrlMime", scrlMime);
  gtk_widget_show (scrlMime);
  gtk_paned_pack2 (GTK_PANED (pan3), scrlMime, TRUE, FALSE);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrlMime), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  clistMime=gtk_clist_new(4);
  gtk_widget_set_name(clistMime,"clistMime");
  gtk_object_set_data(GTK_OBJECT(frmMain),"clistMime",clistMime);
  gtk_container_add(GTK_CONTAINER(scrlMime),clistMime);
  gtk_clist_set_column_width(GTK_CLIST(clistMime),0,20);
  gtk_clist_set_column_width(GTK_CLIST(clistMime),1,190);
  gtk_clist_set_column_width(GTK_CLIST(clistMime),2,225);
  gtk_clist_set_column_width(GTK_CLIST(clistMime),3,50);
  gtk_signal_connect(GTK_OBJECT(clistMime),"select_row",GTK_SIGNAL_FUNC(on_clistMime_select_row),NULL);
  gtk_widget_show(clistMime);
  
  lblMesgID = gtk_label_new (_("id"));
  gtk_widget_set_name (lblMesgID, "lblMesgID");
  gtk_object_set_data (GTK_OBJECT (frmMain), "lblMesgID", lblMesgID);
  gtk_widget_show (lblMesgID);
  gtk_clist_set_column_widget (GTK_CLIST (clistMail), 0, lblMesgID);
  
  lblSender = gtk_label_new (_("Sender"));
  gtk_widget_set_name (lblSender, "lblSender");
  gtk_object_set_data (GTK_OBJECT (frmMain), "lblSender", lblSender);
  gtk_widget_show (lblSender);
  gtk_clist_set_column_widget (GTK_CLIST (clistMail), 1, lblSender);

  lblSubject = gtk_label_new (_("Subject"));
  gtk_widget_set_name (lblSubject, "lblSubject");
  gtk_object_set_data (GTK_OBJECT (frmMain), "lblSubject", lblSubject);
  gtk_widget_show (lblSubject);
  gtk_clist_set_column_widget (GTK_CLIST (clistMail), 2, lblSubject);

  lblDate = gtk_label_new (_("Date"));
  gtk_widget_set_name (lblDate, "lblDate");
  gtk_object_set_data (GTK_OBJECT (frmMain), "lblDate", lblDate);
  gtk_widget_show (lblDate);
  gtk_clist_set_column_widget (GTK_CLIST (clistMail), 3, lblDate);
  
  return frmMain;
}

GtkWidget* create_frmMainSaveAs ()
{
  GtkWidget *frmMainSaveAs;
  GtkWidget *cmdMainSaveAs_OK;
  GtkWidget *cmdMainSaveAs_Cancel;

  frmMainSaveAs = gtk_file_selection_new (_("Save Email As..."));
  gtk_widget_set_name (frmMainSaveAs, "frmMainSaveAs");
  gtk_object_set_data (GTK_OBJECT (frmMainSaveAs), "frmMainSaveAs", 
		       frmMainSaveAs);
  gtk_container_border_width (GTK_CONTAINER (frmMainSaveAs), 10);
  gtk_signal_connect_object (GTK_OBJECT (frmMainSaveAs), "destroy",
                             GTK_SIGNAL_FUNC (on_frmMainSaveAs_destroy),
                             GTK_OBJECT (frmMainSaveAs));

  cmdMainSaveAs_OK = GTK_FILE_SELECTION (frmMainSaveAs)->ok_button;
  gtk_widget_set_name (cmdMainSaveAs_OK, "cmdMainSaveAs_OK");
  gtk_object_set_data (GTK_OBJECT (frmMainSaveAs), "cmdMainSaveAs_OK", 
		       cmdMainSaveAs_OK);
  gtk_widget_show (cmdMainSaveAs_OK);
  GTK_WIDGET_SET_FLAGS (cmdMainSaveAs_OK, GTK_CAN_DEFAULT);
  gtk_signal_connect_object (GTK_OBJECT (cmdMainSaveAs_OK), "clicked",
                             GTK_SIGNAL_FUNC (on_cmdMainSaveAs_OK_clicked),
                             GTK_OBJECT (cmdMainSaveAs_OK));

  cmdMainSaveAs_Cancel = GTK_FILE_SELECTION (frmMainSaveAs)->cancel_button;
  gtk_widget_set_name (cmdMainSaveAs_Cancel, "cmdMainSaveAs_Cancel");
  gtk_object_set_data (GTK_OBJECT (frmMainSaveAs), "cmdMainSaveAs_Cancel", 
		       cmdMainSaveAs_Cancel);
  gtk_widget_show (cmdMainSaveAs_Cancel);
  GTK_WIDGET_SET_FLAGS (cmdMainSaveAs_Cancel, GTK_CAN_DEFAULT);
  gtk_signal_connect_object (GTK_OBJECT (cmdMainSaveAs_Cancel), "clicked",
                             GTK_SIGNAL_FUNC (on_cmdMainSaveAs_Cancel_clicked),
                             GTK_OBJECT (cmdMainSaveAs_Cancel));

  return frmMainSaveAs;
}

GtkWidget* create_dlgNewMailbox ()
{
  GtkWidget *dlgNewMailbox;
  GtkWidget *dialog_vbox1;
  GtkWidget *vbox1;
  GtkWidget *hbox2;
  GtkWidget *lblType;
  GSList *mailbox_type_group = NULL;
  GtkWidget *radSpruce;
  GtkWidget *radSpool;
  GtkWidget *hbox3;
  GtkWidget *lblMailboxName;
  GtkWidget *txtMailboxName;
  GtkWidget *dialog_action_area1;
  GtkWidget *hbox1;
  GtkWidget *cmdDlgNewMailboxOK;
  GtkWidget *cmdDlgNewMailboxCancel;

  dlgNewMailbox = gtk_dialog_new ();
  gtk_widget_set_name (dlgNewMailbox, "dlgNewMailbox");
  gtk_object_set_data (GTK_OBJECT (dlgNewMailbox), "dlgNewMailbox", dlgNewMailbox);
  gtk_signal_connect_object (GTK_OBJECT (dlgNewMailbox), "destroy",
                             GTK_SIGNAL_FUNC (on_dlgNewMailbox_destroy),
                             GTK_OBJECT (dlgNewMailbox));
  GTK_WINDOW (dlgNewMailbox)->type = GTK_WINDOW_DIALOG;
  gtk_window_set_title (GTK_WINDOW (dlgNewMailbox), _("Add Mailbox"));
  gtk_window_position (GTK_WINDOW (dlgNewMailbox), GTK_WIN_POS_CENTER);
  gtk_window_set_policy (GTK_WINDOW (dlgNewMailbox), TRUE, TRUE, FALSE);

  dialog_vbox1 = GTK_DIALOG (dlgNewMailbox)->vbox;
  gtk_widget_set_name (dialog_vbox1, "dialog_vbox1");
  gtk_object_set_data (GTK_OBJECT (dlgNewMailbox), "dialog_vbox1", dialog_vbox1);
  gtk_widget_show (dialog_vbox1);

  vbox1 = gtk_vbox_new (TRUE, 5);
  gtk_widget_set_name (vbox1, "vbox1");
  gtk_object_set_data (GTK_OBJECT (dlgNewMailbox), "vbox1", vbox1);
  gtk_widget_show (vbox1);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), vbox1, TRUE, TRUE, 4);
  gtk_container_border_width (GTK_CONTAINER (vbox1), 8);

  hbox2 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbox2, "hbox2");
  gtk_object_set_data (GTK_OBJECT (dlgNewMailbox), "hbox2", hbox2);
  gtk_widget_show (hbox2);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox2, TRUE, TRUE, 0);

  lblType = gtk_label_new (_("Mailbox type:"));
  gtk_widget_set_name (lblType, "lblType");
  gtk_object_set_data (GTK_OBJECT (dlgNewMailbox), "lblType", lblType);
  gtk_widget_show (lblType);
  gtk_box_pack_start (GTK_BOX (hbox2), lblType, TRUE, TRUE, 0);
  gtk_misc_set_padding (GTK_MISC (lblType), 4, 0);

  radSpruce = gtk_radio_button_new_with_label (mailbox_type_group, _("Spruce Spool"));
  mailbox_type_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radSpruce));
  gtk_widget_set_name (radSpruce, "radSpruce");
  gtk_object_set_data (GTK_OBJECT (dlgNewMailbox), "radSpruce", radSpruce);
  gtk_widget_show (radSpruce);
  gtk_box_pack_start (GTK_BOX (hbox2), radSpruce, TRUE, TRUE, 0);
  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (radSpruce), TRUE);

  radSpool = gtk_radio_button_new_with_label (mailbox_type_group, _("Local Spool"));
  mailbox_type_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radSpool));
  gtk_widget_set_name (radSpool, "radSpool");
  gtk_object_set_data (GTK_OBJECT (dlgNewMailbox), "radSpool", radSpool);
  gtk_widget_show (radSpool);
  gtk_box_pack_start (GTK_BOX (hbox2), radSpool, TRUE, TRUE, 0);

  hbox3 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbox3, "hbox3");
  gtk_object_set_data (GTK_OBJECT (dlgNewMailbox), "hbox3", hbox3);
  gtk_widget_show (hbox3);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox3, TRUE, TRUE, 0);

  lblMailboxName = gtk_label_new (_("Mailbox:"));
  gtk_widget_set_name (lblMailboxName, "lblMailboxName");
  gtk_object_set_data (GTK_OBJECT (dlgNewMailbox), "lblMailboxName", lblMailboxName);
  gtk_widget_show (lblMailboxName);
  gtk_box_pack_start (GTK_BOX (hbox3), lblMailboxName, TRUE, TRUE, 0);

  txtMailboxName = gtk_entry_new ();
  gtk_widget_set_name (txtMailboxName, "txtMailboxName");
  gtk_object_set_data (GTK_OBJECT (dlgNewMailbox), "txtMailboxName", txtMailboxName);
  gtk_widget_show (txtMailboxName);
  gtk_box_pack_start (GTK_BOX (hbox3), txtMailboxName, TRUE, TRUE, 0);

  dialog_action_area1 = GTK_DIALOG (dlgNewMailbox)->action_area;
  gtk_widget_set_name (dialog_action_area1, "dialog_action_area1");
  gtk_object_set_data (GTK_OBJECT (dlgNewMailbox), "dialog_action_area1", dialog_action_area1);
  gtk_widget_show (dialog_action_area1);
  gtk_container_border_width (GTK_CONTAINER (dialog_action_area1), 10);

  hbox1 = gtk_hbox_new (TRUE, 0);
  gtk_widget_set_name (hbox1, "hbox1");
  gtk_object_set_data (GTK_OBJECT (dlgNewMailbox), "hbox1", hbox1);
  gtk_widget_show (hbox1);
  gtk_box_pack_start (GTK_BOX (dialog_action_area1), hbox1, TRUE, TRUE, 0);

  cmdDlgNewMailboxOK = gtk_button_new_with_label (_("OK"));
  gtk_widget_set_name (cmdDlgNewMailboxOK, "cmdDlgNewMailboxOK");
  gtk_object_set_data (GTK_OBJECT (dlgNewMailbox), "cmdDlgNewMailboxOK", cmdDlgNewMailboxOK);
  gtk_widget_show (cmdDlgNewMailboxOK);
  gtk_box_pack_start (GTK_BOX (hbox1), cmdDlgNewMailboxOK, TRUE, TRUE, 0);
  gtk_signal_connect_object (GTK_OBJECT (cmdDlgNewMailboxOK), "clicked",
                             GTK_SIGNAL_FUNC (on_cmdDlgNewMailboxOK_clicked),
                             GTK_OBJECT (cmdDlgNewMailboxOK));

  cmdDlgNewMailboxCancel = gtk_button_new_with_label (_("Cancel"));
  gtk_widget_set_name (cmdDlgNewMailboxCancel, "cmdDlgNewMailboxCancel");
  gtk_object_set_data (GTK_OBJECT (dlgNewMailbox), "cmdDlgNewMailboxCancel", cmdDlgNewMailboxCancel);
  gtk_widget_show (cmdDlgNewMailboxCancel);
  gtk_box_pack_start (GTK_BOX (hbox1), cmdDlgNewMailboxCancel, TRUE, TRUE, 0);
  gtk_signal_connect_object (GTK_OBJECT (cmdDlgNewMailboxCancel), "clicked",
                             GTK_SIGNAL_FUNC (on_cmdDlgNewMailboxCancel_clicked),
                             GTK_OBJECT (cmdDlgNewMailboxCancel));

  return dlgNewMailbox;
}

GtkWidget* create_dlgCopyMove (gchar *title)
{
  GtkWidget *dlgCopyMove;
  GtkWidget *fixed;
  GtkWidget *cmboMailbox;
  GList *cmboMailbox_items = NULL;
  GtkWidget *lblMailbox;
  GtkWidget *cmdCopyMoveOK;
  GtkWidget *cmdCopyMoveCancel;
  GtkWidget *treelocalBoxes = get_widget(frmMain, "treelocalBoxes");
  /*GtkWidget *treespoolBoxes = get_widget(frmMain, "treespoolBoxes");*/
  gchar *mailbox;
  GList *items;

  dlgCopyMove = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_name (dlgCopyMove, "dlgCopyMove");
  gtk_object_set_data (GTK_OBJECT (dlgCopyMove), "dlgCopyMove", dlgCopyMove);
  gtk_widget_set_usize (dlgCopyMove, 230, 115);
  gtk_signal_connect_object (GTK_OBJECT (dlgCopyMove), "destroy",
                             GTK_SIGNAL_FUNC (on_dlgCopyMove_destroy),
                             GTK_OBJECT (dlgCopyMove));
  gtk_window_set_title (GTK_WINDOW (dlgCopyMove), _(title));
  gtk_window_set_policy (GTK_WINDOW (dlgCopyMove), FALSE, FALSE, FALSE);

  fixed = gtk_fixed_new ();
  gtk_widget_set_name (fixed, "fixed");
  gtk_object_set_data (GTK_OBJECT (dlgCopyMove), "fixed", fixed);
  gtk_widget_show (fixed);
  gtk_container_add (GTK_CONTAINER (dlgCopyMove), fixed);

  cmboMailbox = gtk_combo_new ();
  gtk_widget_set_name (cmboMailbox, "cmboMailbox");
  gtk_object_set_data (GTK_OBJECT (dlgCopyMove), "cmboMailbox", cmboMailbox);
  gtk_widget_show (cmboMailbox);
  gtk_fixed_put (GTK_FIXED (fixed), cmboMailbox, 24, 32);
  gtk_widget_set_uposition (cmboMailbox, 24, 32);
  gtk_widget_set_usize (GTK_COMBO (cmboMailbox)->entry, 168, 24);
  gtk_widget_set_usize (cmboMailbox, 184, 24);
  items = GTK_TREE(treelocalBoxes)->children;
  while (items != NULL)
  {
     gtk_label_get (GTK_LABEL (GTK_BIN (GTK_WIDGET(items->data))->child), &mailbox);
     cmboMailbox_items = g_list_append (cmboMailbox_items, mailbox);
     items = items->next;
  }
  gtk_combo_set_popdown_strings (GTK_COMBO (cmboMailbox), cmboMailbox_items);
  gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(cmboMailbox)->entry), FALSE);
  g_list_free (cmboMailbox_items);

  lblMailbox = gtk_label_new (_("Choose mailbox"));
  gtk_widget_set_name (lblMailbox, "lblMailbox");
  gtk_object_set_data (GTK_OBJECT (dlgCopyMove), "lblMailbox", lblMailbox);
  gtk_widget_show (lblMailbox);
  gtk_fixed_put (GTK_FIXED (fixed), lblMailbox, 8, 8);
  gtk_widget_set_uposition (lblMailbox, 8, 8);
  gtk_widget_set_usize (lblMailbox, 216, 16);

  cmdCopyMoveOK = gtk_button_new_with_label (_("OK"));
  gtk_widget_set_name (cmdCopyMoveOK, "cmdCopyMoveOK");
  gtk_object_set_data (GTK_OBJECT (dlgCopyMove), "cmdCopyMoveOK", cmdCopyMoveOK);
  gtk_widget_show (cmdCopyMoveOK);
  gtk_fixed_put (GTK_FIXED (fixed), cmdCopyMoveOK, 24, 72);
  gtk_widget_set_uposition (cmdCopyMoveOK, 24, 72);
  gtk_widget_set_usize (cmdCopyMoveOK, 72, 32);
  gtk_signal_connect_object (GTK_OBJECT (cmdCopyMoveOK), "clicked",
                             GTK_SIGNAL_FUNC (on_cmdCopyMoveOK_clicked),
                             GTK_OBJECT (cmdCopyMoveOK));

  cmdCopyMoveCancel = gtk_button_new_with_label (_("Cancel"));
  gtk_widget_set_name (cmdCopyMoveCancel, "cmdCopyMoveCancel");
  gtk_object_set_data (GTK_OBJECT (dlgCopyMove), "cmdCopyMoveCancel", cmdCopyMoveCancel);
  gtk_widget_show (cmdCopyMoveCancel);
  gtk_fixed_put (GTK_FIXED (fixed), cmdCopyMoveCancel, 136, 72);
  gtk_widget_set_uposition (cmdCopyMoveCancel, 136, 72);
  gtk_widget_set_usize (cmdCopyMoveCancel, 72, 32);
  gtk_signal_connect_object (GTK_OBJECT (cmdCopyMoveCancel), "clicked",
                             GTK_SIGNAL_FUNC (on_cmdCopyMoveCancel_clicked),
                             GTK_OBJECT (cmdCopyMoveCancel));

  return dlgCopyMove;
}
