/*  Spruce
 *  Copyright (C) 1999 Susixware
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "accounts.h"

/* globals for accounts */
gint cRow;                   /* highlighted row */
gint mRow;                   /* current max row */
gboolean dm;                 /* delete mail? */
gint Accounts_reread;

/* external variables */
extern gchar *spruceconf;                /* spruce config file name */
extern GtkWidget *frmAccounts;
extern gboolean AccountsOpen;            /* is frmAccounts opened?? */
extern GtkWidget *frmOptions;
extern gboolean OptionsOpen;
extern accounts_t AccountsList[MAX_ACCOUNTS];
extern gint NumAccounts;
extern gint first_time;

extern gint NumMailboxes;

extern GtkWidget *frmMain;              /* for use when creating the combo box of Mailboxes */


GtkWidget* create_frmAccounts (gint readAccounts)
{
  GtkWidget *frmAccounts;
  GtkWidget *fixed;
  GtkWidget *lblMailbox;
  GtkWidget *txtServer;
  GtkWidget *txtPort;
  GtkWidget *lblPort;
  GtkWidget *cmdAccountsAppend;
  GtkWidget *cmdAccountsDelete;
  GtkWidget *cmdAccountsOK;
  GtkWidget *cmdAccountsCancel;
  GtkWidget *lblServer;
  GtkWidget *txtLogin;
  GtkWidget *txtPasswd;
  GtkWidget *lblLogin;
  GtkWidget *lblPasswd;
  GtkWidget *cmdAccountsModify;
  GtkWidget *chkAccountsDeleMail;
  GtkWidget *cmboMailbox;
  GList *cmboMailbox_items = NULL;
  GtkWidget *scrlAccounts;
  GtkWidget *clistAccounts;
/*  GtkWidget *lblServer;
  GtkWidget *lblPort;
  GtkWidget *lblMailbox;
  GtkWidget *lblLogin;*/
  GtkWidget *lblDM;
  GtkWidget *servertype;
  GtkWidget *lblservertype;
  GList *cmboservertype_items = NULL;
  GtkWidget *treelocalBoxes = get_widget(frmMain, "treelocalBoxes");
  GList *items;
  gchar *mailbox;

  frmAccounts = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_name (frmAccounts, "frmAccounts");
  gtk_object_set_data (GTK_OBJECT (frmAccounts), "frmAccounts", frmAccounts);
  gtk_widget_set_usize (frmAccounts, 530, 300);
  gtk_signal_connect_object (GTK_OBJECT (frmAccounts), "destroy",
                             GTK_SIGNAL_FUNC (on_frmAccounts_destroy),
                             GTK_OBJECT (frmAccounts));
  gtk_signal_connect_object (GTK_OBJECT (frmAccounts), "show",
                             GTK_SIGNAL_FUNC (on_frmAccounts_show),
                             GTK_OBJECT (frmAccounts));
  gtk_window_set_title (GTK_WINDOW (frmAccounts), _("Spruce Incoming Mail Accounts"));
  gtk_window_set_policy (GTK_WINDOW (frmAccounts), FALSE, FALSE, FALSE);

  fixed = gtk_fixed_new ();
  gtk_widget_set_name (fixed, "fixed");
  gtk_object_set_data (GTK_OBJECT (frmAccounts), "fixed", fixed);
  gtk_widget_show (fixed);
  gtk_container_add (GTK_CONTAINER (frmAccounts), fixed);

  lblMailbox = gtk_label_new (_("Mailbox"));
  gtk_widget_set_name (lblMailbox, "lblMailbox");
  gtk_object_set_data (GTK_OBJECT (frmAccounts), "lblMailbox", lblMailbox);
  gtk_widget_show (lblMailbox);
  gtk_fixed_put (GTK_FIXED (fixed), lblMailbox, 272, 160);
  gtk_widget_set_uposition (lblMailbox, 272, 160);
  gtk_widget_set_usize (lblMailbox, 120, 16);

  txtServer = gtk_entry_new ();
  gtk_widget_set_name (txtServer, "txtServer");
  gtk_object_set_data (GTK_OBJECT (frmAccounts), "txtServer", txtServer);
  gtk_widget_show (txtServer);
  gtk_fixed_put (GTK_FIXED (fixed), txtServer, 8, 176);
  gtk_widget_set_uposition (txtServer, 8, 176);
  gtk_widget_set_usize (txtServer, 184, 24);

  txtPort = gtk_entry_new ();
  gtk_widget_set_name (txtPort, "txtPort");
  gtk_object_set_data (GTK_OBJECT (frmAccounts), "txtPort", txtPort);
  gtk_widget_show (txtPort);
  gtk_fixed_put (GTK_FIXED (fixed), txtPort, 200, 176);
  gtk_widget_set_uposition (txtPort, 200, 176);
  gtk_widget_set_usize (txtPort, 64, 24);
  gtk_entry_set_text (GTK_ENTRY (txtPort), "110");

  lblPort = gtk_label_new (_("Port"));
  gtk_widget_set_name (lblPort, "lblPort");
  gtk_object_set_data (GTK_OBJECT (frmAccounts), "lblPort", lblPort);
  gtk_widget_show (lblPort);
  gtk_fixed_put (GTK_FIXED (fixed), lblPort, 192, 160);
  gtk_widget_set_uposition (lblPort, 192, 160);
  gtk_widget_set_usize (lblPort, 80, 16);

  cmdAccountsAppend = gtk_button_new_with_label (_("Append"));
  gtk_widget_set_name (cmdAccountsAppend, "cmdAccountsAppend");
  gtk_object_set_data (GTK_OBJECT (frmAccounts), "cmdAccountsAppend", cmdAccountsAppend);
  gtk_widget_show (cmdAccountsAppend);
  gtk_fixed_put (GTK_FIXED (fixed), cmdAccountsAppend, 445, 8);
  gtk_widget_set_uposition (cmdAccountsAppend, 445, 8);
  gtk_widget_set_usize (cmdAccountsAppend, 72, 32);
  gtk_signal_connect_object (GTK_OBJECT (cmdAccountsAppend), "clicked",
                             GTK_SIGNAL_FUNC (on_cmdAccountsAppend_clicked),
                             GTK_OBJECT (cmdAccountsAppend));

  cmdAccountsDelete = gtk_button_new_with_label (_("Delete"));
  gtk_widget_set_name (cmdAccountsDelete, "cmdAccountsDelete");
  gtk_object_set_data (GTK_OBJECT (frmAccounts), "cmdAccountsDelete", cmdAccountsDelete);
  gtk_widget_show (cmdAccountsDelete);
  gtk_fixed_put (GTK_FIXED (fixed), cmdAccountsDelete, 445, 72);
  gtk_widget_set_uposition (cmdAccountsDelete, 445, 72);
  gtk_widget_set_usize (cmdAccountsDelete, 72, 32);
  gtk_signal_connect_object (GTK_OBJECT (cmdAccountsDelete), "clicked",
                             GTK_SIGNAL_FUNC (on_cmdAccountsDelete_clicked),
                             GTK_OBJECT (cmdAccountsDelete));

  cmdAccountsOK = gtk_button_new_with_label (_("OK"));
  gtk_widget_set_name (cmdAccountsOK, "cmdAccountsOK");
  gtk_object_set_data (GTK_OBJECT (frmAccounts), "cmdAccountsOK", cmdAccountsOK);
  gtk_widget_show (cmdAccountsOK);
  gtk_fixed_put (GTK_FIXED (fixed), cmdAccountsOK, 445, 176);
  gtk_widget_set_uposition (cmdAccountsOK, 445, 176);
  gtk_widget_set_usize (cmdAccountsOK, 72, 32);
  gtk_signal_connect_object (GTK_OBJECT (cmdAccountsOK), "clicked",
                             GTK_SIGNAL_FUNC (on_cmdAccountsOK_clicked),
                             GTK_OBJECT (cmdAccountsOK));

  cmdAccountsCancel = gtk_button_new_with_label (_("Cancel"));
  gtk_widget_set_name (cmdAccountsCancel, "cmdAccountsCancel");
  gtk_object_set_data (GTK_OBJECT (frmAccounts), "cmdAccountsCancel", cmdAccountsCancel);
  gtk_widget_show (cmdAccountsCancel);
  gtk_fixed_put (GTK_FIXED (fixed), cmdAccountsCancel, 445, 216);
  gtk_widget_set_uposition (cmdAccountsCancel, 445, 216);
  gtk_widget_set_usize (cmdAccountsCancel, 72, 32);
  gtk_signal_connect_object (GTK_OBJECT (cmdAccountsCancel), "clicked",
                             GTK_SIGNAL_FUNC (on_cmdAccountsCancel_clicked),
                             GTK_OBJECT (cmdAccountsCancel));

  lblServer = gtk_label_new (_("Server"));
  gtk_widget_set_name (lblServer, "lblServer");
  gtk_object_set_data (GTK_OBJECT (frmAccounts), "lblServer", lblServer);
  gtk_widget_show (lblServer);
  gtk_fixed_put (GTK_FIXED (fixed), lblServer, 8, 160);
  gtk_widget_set_uposition (lblServer, 8, 160);
  gtk_widget_set_usize (lblServer, 184, 16);

  txtLogin = gtk_entry_new ();
  gtk_widget_set_name (txtLogin, "txtLogin");
  gtk_object_set_data (GTK_OBJECT (frmAccounts), "txtLogin", txtLogin);
  gtk_widget_show (txtLogin);
  gtk_fixed_put (GTK_FIXED (fixed), txtLogin, 8, 224);
  gtk_widget_set_uposition (txtLogin, 8, 224);
  gtk_widget_set_usize (txtLogin, 136, 24);

  txtPasswd = gtk_entry_new ();
  gtk_widget_set_name (txtPasswd, "txtPasswd");
  gtk_object_set_data (GTK_OBJECT (frmAccounts), "txtPasswd", txtPasswd);
  gtk_widget_show (txtPasswd);
  gtk_fixed_put (GTK_FIXED (fixed), txtPasswd, 152, 224);
  gtk_widget_set_uposition (txtPasswd, 152, 224);
  gtk_widget_set_usize (txtPasswd, 136, 24);
  gtk_entry_set_visibility (GTK_ENTRY (txtPasswd), FALSE);

  lblLogin = gtk_label_new (_("Login"));
  gtk_widget_set_name (lblLogin, "lblLogin");
  gtk_object_set_data (GTK_OBJECT (frmAccounts), "lblLogin", lblLogin);
  gtk_widget_show (lblLogin);
  gtk_fixed_put (GTK_FIXED (fixed), lblLogin, 8, 208);
  gtk_widget_set_uposition (lblLogin, 8, 208);
  gtk_widget_set_usize (lblLogin, 136, 16);

  lblPasswd = gtk_label_new (_("Password"));
  gtk_widget_set_name (lblPasswd, "lblPasswd");
  gtk_object_set_data (GTK_OBJECT (frmAccounts), "lblPasswd", lblPasswd);
  gtk_widget_show (lblPasswd);
  gtk_fixed_put (GTK_FIXED (fixed), lblPasswd, 152, 208);
  gtk_widget_set_uposition (lblPasswd, 152, 208);
  gtk_widget_set_usize (lblPasswd, 136, 16);

  lblservertype = gtk_label_new (_("Server type"));
  gtk_widget_set_name (lblservertype, "lblservertype");
  gtk_object_set_data (GTK_OBJECT (frmAccounts), "lblservertype", lblservertype);
  gtk_widget_show (lblservertype);
  gtk_fixed_put (GTK_FIXED (fixed), lblservertype, 24, 255);
  gtk_widget_set_uposition (lblservertype, 24, 255);

  servertype = gtk_combo_new ();
  gtk_widget_set_name (servertype, "servertype");
  gtk_object_set_data (GTK_OBJECT (frmAccounts), "servertype", servertype);
  gtk_widget_show (servertype);
  gtk_fixed_put (GTK_FIXED (fixed), servertype, 8, 270);
  gtk_widget_set_uposition (servertype, 8, 270);
  gtk_widget_set_usize (servertype, 136, 24);
  gtk_entry_set_editable (GTK_ENTRY (GTK_COMBO (servertype)->entry), FALSE);
  
  cmboservertype_items = g_list_append (cmboservertype_items, "POP3");
  cmboservertype_items = g_list_append (cmboservertype_items, "IMAP");
  gtk_combo_set_popdown_strings (GTK_COMBO (servertype), cmboservertype_items);
  g_list_free (cmboservertype_items);
  
  gtk_signal_connect (GTK_OBJECT (GTK_COMBO (servertype)->entry), "changed",
  			GTK_SIGNAL_FUNC (on_servertype_activate), NULL);

  cmdAccountsModify = gtk_button_new_with_label (_("Modify"));
  gtk_widget_set_name (cmdAccountsModify, "cmdAccountsModify");
  gtk_object_set_data (GTK_OBJECT (frmAccounts), "cmdAccountsModify", cmdAccountsModify);
  gtk_widget_show (cmdAccountsModify);
  gtk_fixed_put (GTK_FIXED (fixed), cmdAccountsModify, 445, 40);
  gtk_widget_set_uposition (cmdAccountsModify, 445, 40);
  gtk_widget_set_usize (cmdAccountsModify, 72, 32);
  gtk_signal_connect_object (GTK_OBJECT (cmdAccountsModify), "clicked",
                             GTK_SIGNAL_FUNC (on_cmdAccountsModify_clicked),
                             GTK_OBJECT (cmdAccountsModify));

  chkAccountsDeleMail = gtk_check_button_new_with_label (_("Delete mail"));
  gtk_widget_set_name (chkAccountsDeleMail, "chkAccountsDeleMail");
  gtk_object_set_data (GTK_OBJECT (frmAccounts), "chkAccountsDeleMail", chkAccountsDeleMail);
  gtk_widget_show (chkAccountsDeleMail);
  gtk_fixed_put (GTK_FIXED (fixed), chkAccountsDeleMail, 296, 224);
  gtk_widget_set_uposition (chkAccountsDeleMail, 296, 224);
  gtk_widget_set_usize (chkAccountsDeleMail, 99, 24);
  gtk_signal_connect_object (GTK_OBJECT (chkAccountsDeleMail), "toggled",
                             GTK_SIGNAL_FUNC (on_chkAccountsDeleMail_toggled),
                             GTK_OBJECT (chkAccountsDeleMail));
  dm = TRUE;
  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (chkAccountsDeleMail), dm);

  cmboMailbox = gtk_combo_new ();
  gtk_widget_set_name (cmboMailbox, "cmboMailbox");
  gtk_object_set_data (GTK_OBJECT (frmAccounts), "cmboMailbox", cmboMailbox);
  gtk_widget_show (cmboMailbox);
  gtk_fixed_put (GTK_FIXED (fixed), cmboMailbox, 272, 176);
  gtk_widget_set_uposition (cmboMailbox, 272, 176);
  gtk_widget_set_usize (GTK_COMBO (cmboMailbox)->entry, 104, 24);
  gtk_widget_set_usize (cmboMailbox, 120, 24);

  items = GTK_TREE (GTK_WIDGET (treelocalBoxes))->children;
  while (items != NULL)
  {
      gtk_label_get (GTK_LABEL (GTK_BIN (GTK_WIDGET(items->data))->child), &mailbox);
      cmboMailbox_items = g_list_append (cmboMailbox_items, mailbox);
      items = items->next;
  }
  gtk_combo_set_popdown_strings (GTK_COMBO (cmboMailbox), cmboMailbox_items);
  g_list_free (cmboMailbox_items);
  gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(cmboMailbox)->entry), FALSE);

  scrlAccounts = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_set_name (scrlAccounts, "scrlAccounts");
  gtk_object_set_data (GTK_OBJECT (frmAccounts), "scrlAccounts", scrlAccounts);
  gtk_widget_show (scrlAccounts);
  gtk_fixed_put (GTK_FIXED (fixed), scrlAccounts, 8, 8);
  gtk_widget_set_uposition (scrlAccounts, 8, 8);
  gtk_widget_set_usize (scrlAccounts, 430, 144);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrlAccounts), GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);

  clistAccounts = gtk_clist_new (6);
  gtk_widget_set_name (clistAccounts, "clistAccounts");
  gtk_object_set_data (GTK_OBJECT (frmAccounts), "clistAccounts", clistAccounts);
  gtk_widget_show (clistAccounts);
  gtk_container_add (GTK_CONTAINER (scrlAccounts), clistAccounts);
  gtk_signal_connect_object (GTK_OBJECT (clistAccounts), "select_row",
                             GTK_SIGNAL_FUNC (on_clistAccounts_select_row),
                             GTK_OBJECT (clistAccounts));
  gtk_clist_set_column_width (GTK_CLIST (clistAccounts), 0, 130);
  gtk_clist_set_column_width (GTK_CLIST (clistAccounts), 1, 38);
  gtk_clist_set_column_width (GTK_CLIST (clistAccounts), 2, 38);
  gtk_clist_set_column_width (GTK_CLIST (clistAccounts), 3, 69);
  gtk_clist_set_column_width (GTK_CLIST (clistAccounts), 4, 69);
  gtk_clist_set_column_width (GTK_CLIST (clistAccounts), 5, 15);
  gtk_clist_column_titles_show (GTK_CLIST (clistAccounts));

  lblServer = gtk_label_new (_("Server"));
  gtk_widget_set_name (lblServer, "lblServer");
  gtk_object_set_data (GTK_OBJECT (frmAccounts), "lblServer", lblServer);
  gtk_widget_show (lblServer);
  gtk_clist_set_column_widget (GTK_CLIST (clistAccounts), 0, lblServer);

  lblservertype = gtk_label_new (_("Type"));
  gtk_widget_show (lblservertype);
  gtk_clist_set_column_widget (GTK_CLIST (clistAccounts), 1, lblservertype);
  
  lblPort = gtk_label_new (_("Port"));
  gtk_widget_set_name (lblPort, "lblPort");
  gtk_object_set_data (GTK_OBJECT (frmAccounts), "lblPort", lblPort);
  gtk_widget_show (lblPort);
  gtk_clist_set_column_widget (GTK_CLIST (clistAccounts), 2, lblPort);

  lblMailbox = gtk_label_new (_("Mailbox"));
  gtk_widget_show (lblMailbox);
  gtk_clist_set_column_widget (GTK_CLIST (clistAccounts), 3, lblMailbox);

  lblLogin = gtk_label_new (_("Login"));
  gtk_widget_set_name (lblLogin, "lblLogin");
  gtk_object_set_data (GTK_OBJECT (frmAccounts), "lblLogin", lblLogin);
  gtk_widget_show (lblLogin);
  gtk_clist_set_column_widget (GTK_CLIST (clistAccounts), 4, lblLogin);

  lblDM = gtk_label_new (_("dm"));
  gtk_widget_show (lblDM);
  gtk_clist_set_column_widget (GTK_CLIST (clistAccounts), 5, lblDM);

  Accounts_reread = readAccounts;
 
  return frmAccounts;
}

void on_frmAccounts_destroy (GtkObject *object, gpointer user_data)
{
   gtk_widget_destroy(frmAccounts);
   AccountsOpen = FALSE;
   dm = TRUE;
}

void on_frmAccounts_show (GtkWidget *widget, gpointer user_data)
{
   cRow = -1;
   mRow = NumAccounts - 1;
   if(!first_time)
      refresh_clistAccounts(TRUE);
}

void on_cmdAccountsAppend_clicked (GtkButton *button, gpointer user_data)
{
   GtkWidget *txtServer   = get_widget(frmAccounts, "txtServer");
   GtkWidget *txtPort     = get_widget(frmAccounts, "txtPort");
   GtkWidget *cmboMailbox = get_widget(frmAccounts, "cmboMailbox");
   GtkWidget *txtLogin    = get_widget(frmAccounts, "txtLogin");
   GtkWidget *txtPasswd   = get_widget(frmAccounts, "txtPasswd");
   GtkWidget *clist       = get_widget(frmAccounts, "clistAccounts");
   GtkWidget *servertype  = get_widget(frmAccounts, "servertype");
   gchar *buffer;
   gchar *type;
   gchar *text[6] = {"Server", "Type", "Port", "Mailbox", "Login", "dm"};

   /* Make sure that the fields aren't blank */
   if (!strlen(gtk_entry_get_text(GTK_ENTRY(txtServer))))
      return;
   if (!strlen(gtk_entry_get_text(GTK_ENTRY(txtLogin))))
      return;
   if (!strlen(gtk_entry_get_text(GTK_ENTRY(txtPasswd))))
      return;

   type = gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (servertype)->entry));
   if(NumAccounts < MAX_ACCOUNTS)
   {
      mRow++;
      NumAccounts++;
	      
      gtk_clist_freeze(GTK_CLIST(clist));

      gtk_clist_append(GTK_CLIST(clist), (gchar**) text);

      /* set the hostname */
      buffer = gtk_entry_get_text(GTK_ENTRY(txtServer));
      AccountsList[mRow].server.hostname = g_strdup(buffer);
      gtk_clist_set_text(GTK_CLIST(clist), mRow, 0, buffer);

      /* set the Login */
      buffer = gtk_entry_get_text(GTK_ENTRY(txtLogin));
      AccountsList[mRow].login = g_strdup(buffer);
      gtk_clist_set_text(GTK_CLIST(clist), mRow, 4, buffer);

      /* set the Passwd */
      buffer = gtk_entry_get_text(GTK_ENTRY(txtPasswd));
      strcpy(buffer, gtk_entry_get_text(GTK_ENTRY(txtPasswd)));
      AccountsList[mRow].passwd = g_strdup(buffer);

      if (!strcmp(type, "POP3"))
      {
         /* set the port */
         if (gtk_entry_get_text(GTK_ENTRY(txtPort)) != NULL)
         {
            AccountsList[mRow].server.port = atoi(gtk_entry_get_text(GTK_ENTRY(txtPort)));
         }
         else
         {
            AccountsList[mRow].server.port = 110;
         }
         gtk_clist_set_text(GTK_CLIST(clist), mRow, 2, gtk_entry_get_text(GTK_ENTRY(txtPort)));

         /* set the mailbox */
         buffer = gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(cmboMailbox)->entry));
         AccountsList[mRow].mailbox = g_realloc(NULL, strlen(buffer) + 1);
         strcpy(AccountsList[mRow].mailbox, buffer);
         gtk_clist_set_text(GTK_CLIST(clist), mRow, 3, buffer);

         /* set the DeleMail variable */
         AccountsList[mRow].delemail = dm;
         if (dm)
            gtk_clist_set_text(GTK_CLIST(clist), mRow, 5, _("yes"));
         else
            gtk_clist_set_text(GTK_CLIST(clist), mRow, 5, _("no"));

         gtk_clist_set_text(GTK_CLIST(clist), mRow, 1, "POP3");

         AccountsList[mRow].type = TYPE_POP3;
      }

      if (!strcmp(type, "IMAP"))
      {
         /* set the port */
         if (gtk_entry_get_text(GTK_ENTRY(txtPort)) != NULL)
         {
            AccountsList[mRow].server.port = atoi(gtk_entry_get_text(GTK_ENTRY(txtPort)));
         }
         else
         {
            AccountsList[mRow].server.port = 143;
         }

         gtk_clist_set_text(GTK_CLIST(clist), mRow, 2, gtk_entry_get_text(GTK_ENTRY(txtPort)));

         gtk_clist_set_text(GTK_CLIST(clist), mRow, 1, "IMAP");

         AccountsList[mRow].type = TYPE_IMAP;
      }
      
      cRow = mRow;
      gtk_clist_select_row(GTK_CLIST(clist), cRow, 0);
      gtk_clist_moveto(GTK_CLIST(clist), cRow, 0, 1.0, 0.0);

      refresh_clistAccounts(FALSE);
      
      gtk_clist_thaw(GTK_CLIST(clist));
      
      /* reset the defaults for the next entry... */
      gtk_entry_set_text(GTK_ENTRY(txtServer), "");
      gtk_entry_set_text(GTK_ENTRY(txtPort), "110");
      gtk_entry_set_text(GTK_ENTRY(txtLogin), "");
      gtk_entry_set_text(GTK_ENTRY(txtPasswd), "");
      gtk_entry_set_text(GTK_ENTRY (GTK_COMBO (servertype)->entry), "POP3");
   }
   else
	{
      fprintf(stderr, "Cannot append any more Accounts - %d is the limit.\n", MAX_ACCOUNTS);
	}
    
    
}

void on_cmdAccountsDelete_clicked (GtkButton *button, gpointer user_data)
{
   /* yea...I know this is sloppy...I should probably just copy from the highlighted + 1
    * position to the end and then copy that back...but oh well. */
   GtkWidget *clist = get_widget(frmAccounts, "clistAccounts");
   gint i;

   if (mRow >= 0 && cRow >= 0)
	{
      gtk_clist_freeze(GTK_CLIST(clist));
      gtk_clist_remove(GTK_CLIST(clist), cRow);

      /* lets delete the stuff */
      if (cRow == mRow)
		{
         g_free(AccountsList[mRow].server.hostname);
         AccountsList[mRow].server.hostname = NULL;
         if (AccountsList[mRow].mailbox != NULL)
         {
            g_free(AccountsList[mRow].mailbox);
            AccountsList[mRow].mailbox = NULL;
         }
         g_free(AccountsList[mRow].login);
         g_free(AccountsList[mRow].passwd);
      }
      else
		{
			for (i = cRow; i < mRow; i++)
			{
            g_free(AccountsList[i].server.hostname);
            if (AccountsList[i].mailbox != NULL)
            {
			      g_free(AccountsList[i].mailbox);
               AccountsList[i].mailbox = NULL;
            }
            g_free(AccountsList[i].login);
            g_free(AccountsList[i].passwd);
				AccountsList[i].server.hostname = g_strdup(AccountsList[i+1].server.hostname);
				AccountsList[i].server.port     = AccountsList[i+1].server.port;
            if (AccountsList[i+1].mailbox != NULL)
               AccountsList[i].mailbox      = g_strdup(AccountsList[i+1].mailbox);
            AccountsList[i].login           = g_strdup(AccountsList[i+1].login);
            AccountsList[i].passwd          = g_strdup(AccountsList[i+1].passwd);
			}
         g_free(AccountsList[i].server.hostname);
         AccountsList[i].server.hostname = NULL;
         if (AccountsList[i].mailbox != NULL)
         {
            g_free(AccountsList[i].mailbox);
            AccountsList[i].mailbox = NULL;
         }
         g_free(AccountsList[i].login);
         AccountsList[i].login = NULL;
         g_free(AccountsList[i].passwd);
         AccountsList[i].passwd = NULL;
		}

      mRow--;
      NumAccounts--;
      cRow = cRow > mRow ? mRow : cRow;

      gtk_clist_select_row(GTK_CLIST(clist), cRow, 0);
      gtk_clist_moveto(GTK_CLIST(clist), cRow, 0, 1.0, 0.0);

      gtk_clist_thaw(GTK_CLIST(clist));
	}
   else
	{
      fprintf(stderr, "Cannot delete any more Accounts - you have none left!\n");
      fflush(stderr);
	}
}

void on_cmdAccountsOK_clicked (GtkButton *button, gpointer user_data)
{
   if (first_time)
      first_time = FALSE;

   rc_save_defaults();

   if (OptionsOpen)
      refresh_clistPop3Servers(TRUE);
   gtk_widget_destroy(frmAccounts);
   refresh_mailboxes(TRUE);
   AccountsOpen = FALSE;
   dm = TRUE;
}

void on_cmdAccountsCancel_clicked (GtkButton *button, gpointer user_data)
{
   gtk_widget_destroy(frmAccounts);
   AccountsOpen = FALSE;
   dm = TRUE;
}

void on_cmdAccountsModify_clicked (GtkButton *button, gpointer user_data)
{
   GtkWidget *txtServer   = get_widget(frmAccounts, "txtServer");
   GtkWidget *txtPort     = get_widget(frmAccounts, "txtPort");
   GtkWidget *cmboMailbox = get_widget(frmAccounts, "cmboMailbox");
   GtkWidget *txtLogin    = get_widget(frmAccounts, "txtLogin");
   GtkWidget *txtPasswd   = get_widget(frmAccounts, "txtPasswd");
   GtkWidget *clist       = get_widget(frmAccounts, "clistAccounts");
   GtkWidget *servertype  = get_widget(frmAccounts, "servertype");
   gchar *buffer;
   gchar *type;

   type = gtk_entry_get_text(GTK_ENTRY (GTK_COMBO (servertype)->entry));
   if(mRow >= 0 && cRow >= 0)
	{
      gtk_clist_freeze(GTK_CLIST(clist));

      /* set the hostname */
      buffer = gtk_entry_get_text(GTK_ENTRY(txtServer));
      g_free(AccountsList[cRow].server.hostname);
      AccountsList[cRow].server.hostname = g_strdup(buffer);
      gtk_clist_set_text(GTK_CLIST(clist), cRow, 0, buffer);

      /* set the port */
      AccountsList[cRow].server.port = atoi(gtk_entry_get_text(GTK_ENTRY(txtPort)));
      gtk_clist_set_text(GTK_CLIST(clist), cRow, 2, gtk_entry_get_text(GTK_ENTRY(txtPort)));

      
      /* set the Login */
      buffer = gtk_entry_get_text(GTK_ENTRY(txtLogin));
      g_free(AccountsList[cRow].login);
      AccountsList[cRow].login = g_strdup(buffer);
      gtk_clist_set_text(GTK_CLIST(clist), cRow, 4, buffer);

      /* set the Passwd */
      buffer = gtk_entry_get_text(GTK_ENTRY(txtPasswd));
      AccountsList[cRow].passwd = g_strdup(buffer);

      if (!strcmp(type, "POP3"))
      {
	      /* set the mailbox */
	      buffer = gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(cmboMailbox)->entry));
         g_free(AccountsList[cRow].mailbox);
	      AccountsList[cRow].mailbox = g_strdup(buffer);
	      gtk_clist_set_text(GTK_CLIST(clist), cRow, 3, buffer);

	      /* set the DeleMail variable */
	      AccountsList[cRow].delemail = dm;
	      if (dm)
	         gtk_clist_set_text(GTK_CLIST(clist), cRow, 5, _("yes"));
	      else
	         gtk_clist_set_text(GTK_CLIST(clist), cRow, 5, _("no"));

	      AccountsList[cRow].type = TYPE_POP3;
      }
      if (!strcmp(type, "IMAP"))
      {
	      AccountsList[cRow].type = TYPE_IMAP;
	      gtk_clist_set_text(GTK_CLIST(clist), cRow, 3, "");
	      gtk_clist_set_text(GTK_CLIST(clist), cRow, 5, "");
      }
      
      gtk_clist_thaw(GTK_CLIST(clist));
	}
}

void on_clistAccounts_select_row (GtkCList *clist, gint row, gint column,
                                  GdkEvent *event, gpointer user_data)
{
   GtkWidget *txtServer   = get_widget(frmAccounts, "txtServer");
   GtkWidget *txtPort     = get_widget(frmAccounts, "txtPort");
   GtkWidget *cmboMailbox = get_widget(frmAccounts, "cmboMailbox");
   GtkWidget *txtLogin    = get_widget(frmAccounts, "txtLogin");
   GtkWidget *txtPasswd   = get_widget(frmAccounts, "txtPasswd");
   GtkWidget *servertype  = get_widget(frmAccounts, "servertype");
   GtkWidget *chkAccountsDeleMail = get_widget(frmAccounts, "chkAccountsDeleMail");
   gchar buffer[256];

	/* set the current row to the highlighted row */
   cRow = row;

   /* update the info in the fields... */
   dm = AccountsList[cRow].delemail;
   gtk_entry_set_text(GTK_ENTRY(txtServer), AccountsList[cRow].server.hostname);
   g_snprintf(buffer, 255, "%d", AccountsList[cRow].server.port);
   gtk_entry_set_text(GTK_ENTRY(txtPort), buffer);
   gtk_entry_set_text(GTK_ENTRY(txtLogin), AccountsList[cRow].login);
   gtk_entry_set_text(GTK_ENTRY(txtPasswd), AccountsList[cRow].passwd);
   if (AccountsList[cRow].type == TYPE_POP3)
   {
   	gtk_entry_set_text(GTK_ENTRY (GTK_COMBO (servertype)->entry), "POP3");
   	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(cmboMailbox)->entry), AccountsList[cRow].mailbox);
   	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(chkAccountsDeleMail), dm);
   }
   if (AccountsList[cRow].type == TYPE_IMAP)
   {
   	gtk_entry_set_text(GTK_ENTRY (GTK_COMBO (servertype)->entry), "IMAP");
   	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(cmboMailbox)->entry), "");
   	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(chkAccountsDeleMail), FALSE);
   }
}

void on_chkAccountsDeleMail_toggled (GtkToggleButton *togglebutton, gpointer user_data)
{
   /* probably don't really need this function because all I'd really need to
    * do is query the state when I go to save it or whatever...but oh well :p */

   dm = GTK_TOGGLE_BUTTON (togglebutton)->active;
}

void on_servertype_activate (GtkWidget *entry, gpointer user_data)
{
	GtkWidget *port = get_widget(frmAccounts, "txtPort");
	GtkWidget *mailbox = get_widget(frmAccounts, "cmboMailbox");
	GtkWidget *lblmailbox = get_widget(frmAccounts, "lblMailbox");
	GtkWidget *dm = get_widget(frmAccounts, "chkAccountsDeleMail");
	gchar *type;
	
	type = gtk_entry_get_text (GTK_ENTRY (entry));

	if (!strcmp(type, "POP3"))
	{
		gtk_entry_set_text (GTK_ENTRY (port), "110");
		gtk_widget_show(mailbox);
		gtk_widget_show(lblmailbox);
		gtk_widget_show(dm);
	}
	if (!strcmp(type, "IMAP"))
	{
		gtk_entry_set_text (GTK_ENTRY (port), "143");
		gtk_widget_hide(mailbox);
		gtk_widget_hide(lblmailbox);
		gtk_widget_hide(dm);
	}
}

void null_accounts()
{
   gint i;

   for (i = 0; i < MAX_ACCOUNTS; i++)
   {
      if (AccountsList[i].server.hostname != NULL)
      {
         /*fprintf(stderr, "\thostname[%d]\n", i); fflush(stderr);*/
         g_free(AccountsList[i].server.hostname);
         AccountsList[i].server.hostname = NULL;
      }
      if (AccountsList[i].mailbox != NULL)
      {
         /*fprintf(stderr, "\tmailbox[%d]\n", i); fflush(stderr);*/
         g_free(AccountsList[i].mailbox);
         AccountsList[i].mailbox = NULL;
      }
      if (AccountsList[i].login != NULL)
      {
         /*fprintf(stderr, "\tlogin[%d]\n", i); fflush(stderr);*/
         g_free(AccountsList[i].login);
         AccountsList[i].login = NULL;
      }
      if (AccountsList[i].passwd != NULL)
      {
         /*fprintf(stderr, "\tpasswd[%d]\n", i); fflush(stderr);*/
         g_free(AccountsList[i].passwd);
         AccountsList[i].passwd = NULL;
      }
   }
}

gint read_accounts()
{
   gchar buffer[257];
   FILE *fp;
   gchar *server  = NULL;
   gchar *mailbox = NULL;
   gchar *login   = NULL;
   gchar *passwd  = NULL;
   gchar *port_buff = NULL;
   gchar *del_buff  = NULL;
   gint port = 110, del = 1;

   fp = fopen(spruceconf, "rt");
   if (fp == NULL)
	{
      fprintf(stderr, "Spruce: %s failed to open for reading.\n", spruceconf);
      fprintf(stderr, "Please check with your local Administrator.\n");
      return 0;
	}

   /*fprintf(stderr, "null_accounts()\n"); fflush(stderr);*/
   null_accounts();
   /*fprintf(stderr, "done\n"); fflush(stderr);*/

   mRow = -1;
   NumAccounts = 0;
   while (!feof(fp) && NumAccounts < MAX_ACCOUNTS)
	{
      fgets(buffer, 256, fp);
      trim_leadspc(buffer);
      if(buffer[0] != '\n' && buffer[0] != '#')
		{
         if (!strncmp("pop3-server", buffer, strlen("pop3-server")))
         {
            mRow++;
            NumAccounts++;
            strcut(buffer, 0, strlen("pop3-server"));
            trim_whtspc(buffer);

            server    = get_field(buffer, 1, ':');
            port_buff = get_field(buffer, 2, ':');
            port      = atoi(port_buff);
            g_free(port_buff);
            mailbox   = get_field(buffer, 3, ':');
            login     = get_field(buffer, 4, ':');
            passwd    = get_field(buffer, 5, ':');
            del_buff  = get_field(buffer, 6, ':');
            del = atoi(del_buff);
            g_free(del_buff);

            AccountsList[mRow].server.hostname = g_strdup(server);
            g_free(server);
            AccountsList[mRow].server.port = (port_t) port;
            AccountsList[mRow].mailbox = g_strdup(mailbox);
            g_free(mailbox);
            AccountsList[mRow].login = g_strdup(login);
            g_free(login);
            AccountsList[mRow].passwd = g_strdup(passwd);
            g_free(passwd);
            AccountsList[mRow].delemail = del;
            AccountsList[mRow].type = TYPE_POP3;
         }

         if (!strncmp("imap-server", buffer, strlen("imap-server")))
         {
            mRow++;
            NumAccounts++;
            strcut(buffer, 0, strlen("imap-server"));
            trim_whtspc(buffer);

            server    = get_field(buffer, 1, ':');
            port_buff = get_field(buffer, 2, ':');
            port = atoi(port_buff);
            g_free(port_buff);
            login     = get_field(buffer, 3, ':');
            passwd    = get_field(buffer, 4, ':');

            AccountsList[mRow].server.hostname = g_strdup(server);
            g_free(server);
            AccountsList[mRow].server.port     = (port_t) port;
            AccountsList[mRow].login           = g_strdup(login);
            g_free(login);
            AccountsList[mRow].passwd          = g_strdup(passwd);
            g_free(passwd);
            AccountsList[mRow].type            = TYPE_IMAP;
         }
      }
   }
   cRow = mRow >= 0 ? 0 : -1;

   fclose(fp);
   return 1;
}

void refresh_clistAccounts(gboolean reread)
{
   GtkWidget *clist = get_widget(frmAccounts, "clistAccounts");
   gchar buffer[256];
   gint i = 0;
   gchar *text[6] = {"Server", "Type", "Port", "Mailbox", "Login", "dm"};

   if (reread)
	{
      read_accounts();
	}
   else
	{
      mRow = NumAccounts - 1;
	}

   if (NumAccounts > 0)
	{
      gtk_clist_freeze(GTK_CLIST(clist));
      gtk_clist_clear(GTK_CLIST(clist));

      for(i = 0; i <= mRow; i++)
	   {
         gtk_clist_append(GTK_CLIST(clist), (gchar**) text);
         gtk_clist_set_text(GTK_CLIST(clist), i, 0, AccountsList[i].server.hostname);
         g_snprintf(buffer, 255, "%d", AccountsList[i].server.port);
         gtk_clist_set_text(GTK_CLIST(clist), i, 2, buffer);
         gtk_clist_set_text(GTK_CLIST(clist), i, 4, AccountsList[i].login);
         if (AccountsList[i].type == TYPE_POP3)
         {
            gtk_clist_set_text(GTK_CLIST(clist), i, 1, "POP3");
            gtk_clist_set_text(GTK_CLIST(clist), i, 3, AccountsList[i].mailbox);
            if (AccountsList[i].delemail)
               gtk_clist_set_text(GTK_CLIST(clist), i, 5, _("yes"));
            else
               gtk_clist_set_text(GTK_CLIST(clist), i, 5, _("no"));
         }
         if (AccountsList[i].type == TYPE_IMAP)
         {
            gtk_clist_set_text(GTK_CLIST(clist), i, 1, "IMAP");
            gtk_clist_set_text(GTK_CLIST(clist), i, 3, "");
            gtk_clist_set_text(GTK_CLIST(clist), i, 5, "");
         }
	   }

      gtk_clist_thaw(GTK_CLIST(clist));
	}

   cRow = cRow < mRow ? cRow : mRow;
   if (cRow >= 0)
      gtk_clist_select_row(GTK_CLIST(clist), cRow, 0);
}
