/* DSTART                                                                    */
/*                                                                           */
/*           maildrop - mail delivery agent with filtering abilities         */
/*                                                                           */
/*  Copyright 1998-1999, Double Precision Inc.                               */
/*                                                                           */
/*  This program is distributed under the terms of the GNU General Public    */
/*  License. See COPYING for additional information.                         */
/* DEND                                                                      */
/*
** $Id: rfc2045_fromfd.c,v 1.2 1999/10/25 04:01:18 mrsam Exp $
*/
#if	HAVE_CONFIG_H
#include	"config.h"
#endif

#include	"rfc2045.h"
#if	HAVE_UNISTD_H
#include	<unistd.h>
#endif

/* Convert a message to the RFC2045 structure */

struct rfc2045 *rfc2045_fromfd(int fd)
{
struct	rfc2045	*rfc;
char	buf[BUFSIZ];
int	n;

	if (lseek(fd, 0L, SEEK_SET) == -1)	return (NULL);
	if ((rfc=rfc2045_alloc()) == 0)	return (NULL);

	while ((n=read(fd, buf, sizeof(buf))) > 0)
		rfc2045_parse(rfc, buf, n);
	return (rfc);
}
