/* DSTART                                                                    */
/*                                                                           */
/*           maildrop - mail delivery agent with filtering abilities         */
/*                                                                           */
/*  Copyright 1998-1999, Double Precision Inc.                               */
/*                                                                           */
/*  This program is distributed under the terms of the GNU General Public    */
/*  License. See COPYING for additional information.                         */
/* DEND                                                                      */
#include	"bdbobj.h"
#include	<stdio.h>
#include	<string.h>

int main(int argc, char **argv)
{
	if (argc < 2)	exit(1);

	if (argc < 3)
	{
	BDbObj	dbw;
	char	*key, *data;
	size_t	keylen, datalen;

		if (dbw.Open(argv[1], "R"))
		{
			perror("open");
			exit(1);
		}

		printf("Dumping %s:\n", argv[1]);
		for (key=dbw.FetchFirstKeyVal(keylen, data, datalen);
			key; key=dbw.FetchNextKeyVal(keylen, data, datalen))
		{
			printf("Key: ");
			fwrite(key, keylen, 1, stdout);
			printf(", Data: ");
			fwrite(data, datalen, 1, stdout);
			printf("\n");
			free(data);
		}

		dbw.Close();
	} else if (argc < 4 && argv[2][0] == '-')
	{
	BDbObj	dbw;

		if (dbw.Open(argv[1], "W"))
		{
			perror("open");
			exit(1);
		}

		printf("Deleting %s from %s:\n", argv[2], argv[1]);
		if (dbw.Delete(argv[2]+1, strlen(argv[2]+1)))
			fprintf(stderr, "Not found.\n");

		dbw.Close();
	} else if (argc < 4)
	{
	BDbObj	dbw;

		if (dbw.Open(argv[1], "R"))
		{
			perror("open");
			exit(1);
		}

	size_t len;
	char *val=dbw.Fetch(argv[2], strlen(argv[2]), len, 0);

		if (!val)
		{
			fprintf(stderr, "%s: not found.\n", argv[2]);
			exit(1);
		}
		printf("Fetching %s from %s: ", argv[2], argv[1]);
		fwrite(val, len, 1, stdout);
		printf("\n");
		free(val);
		dbw.Close();
	}
	else
	{
	BDbObj	dbw;

		if (dbw.Open(argv[1], "C"))
		{
			perror("open");
			exit(1);
		}

	size_t len;

		printf("Storing %s/%s into %s:\n", argv[2], argv[3], argv[1]);
		if (dbw.Store(argv[2], strlen(argv[2]),
			argv[3], strlen(argv[3]), "R"))
		{
			perror("write");
			exit(1);
		}

		dbw.Close();
	}
	exit(0);
	return (0);
}
