static char rcsid[] = "@(#)$Id: getarpdate.c,v 1.3.4.1 1999/11/07 17:33:04 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.3.4.1 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

#include "headers.h"

static char *arpa_dayname[] = { "Sun", "Mon", "Tue", "Wed", "Thu",
		  "Fri", "Sat", "" };

static char *arpa_monname[] = { "Jan", "Feb", "Mar", "Apr", "May", "Jun",
		  "Jul", "Aug", "Sep", "Oct", "Nov", "Dec", ""};

char * get_arpa_date()
{
	/** returns an ARPA standard date.  The format for the date
	    according to DARPA document RFC-822 is exemplified by;

	       	      Mon, 12 Aug 85 6:29:08 MST


	    Actually generates following kind result:
                      
                      Mon, 12 Aug 1985 6:29:0 +0400 (MST)

	**/

	static char buffer[SLEN];	/* static character buffer       */
	time_t	  curr_time;		/* time in seconds....		 */
	struct tm curr_tm;		/* Time structure, see CTIME(3C) */
	long      tzmin;		/* number of minutes off gmt 	 */
	int	  tzsign;		/* + or - gmt 			 */
	int	  year;			/* current year - with century	 */

	/*
	 * The get_tz_mins() routine steps on the static data returned
	 * by localtime(), so we need to save off the value obtained here.
	 */
	(void) time(&curr_time);
	curr_tm = *localtime(&curr_time);

	year = curr_tm.tm_year + 1900;

	if ((tzmin = -get_tz_mins()) >= 0) {
		tzsign = '+';
	} else {
		tzsign = '-';
		tzmin = -tzmin;
	}

	elm_sfprintf(buffer, sizeof buffer,
		     FRM("%s, %d %s %d %02d:%02d:%02d %c%02d%02d (%s)"),
		     arpa_dayname[curr_tm.tm_wday],
		     curr_tm.tm_mday, arpa_monname[curr_tm.tm_mon], year,
		     curr_tm.tm_hour, curr_tm.tm_min, curr_tm.tm_sec,
		     tzsign, tzmin / 60, tzmin % 60, get_tz_name(&curr_tm));
	
	return buffer;
}


#ifdef _TEST
int debug = 1;
main()
{
	printf("system(\"date\") says:   ");
	fflush(stdout);
	system("date");
	fflush(stdout);
	printf("get_arpa_date() says:  %s\n", get_arpa_date());
	exit(0);
}
#endif

