#ifndef	waitlib_h
#define	waitlib_h

/*
** Copyright 1998 - 1999 Double Precision, Inc.
** See COPYING for distribution information.
*/

#if	HAVE_CONFIG_H
#include	"config.h"
#endif

static const char waitlib_h_rcsid[]="$Id: waitlib.h,v 1.3 1999/12/06 13:32:02 mrsam Exp $";

#include <sys/types.h>
#if HAVE_SYS_WAIT_H
#include <sys/wait.h>
#endif
#ifndef WEXITSTATUS
#define WEXITSTATUS(stat_val) ((unsigned)(stat_val) >> 8)
#endif
#ifndef WIFEXITED
#define WIFEXITED(stat_val) (((stat_val) & 255) == 0)
#endif

/*
** Ok, wait() pecularities are handled by the following functions.  Except
** for them, nobody else should care about wait's quirks.
**
** First, call signal(SIGCHLD) as usual to set up your signal handler.
** Within the signal handler, call wait_reap to reap one (or more)
** child processes.
*/

void wait_reap( void (*)(pid_t, int), /* Called to process reaped child */
	RETSIGTYPE (*)(int));	/* Should point back to signal handler */

/*
** Main program can call wait_block and wait_clear to temporarily
** suspend reaping while in a critical section.
*/

void wait_block();
void wait_clear(RETSIGTYPE (*)(int));	/* The signal handler */

/*
** wait_restore should be called instead of signal(SIGCHLD, SIG_DFL)
** to restore the signal handler just before exiting.  It should also
** be called by any forked process.
*/

void wait_restore();

/*
** Sometimes the parent wants to wait for one child to terminate.
** call wait_forchild for that.  First, wait_block() must be called to
** suspend all asynchronous reaping.  Then, call wait_forchild.  Before
** wait_forchild returns, the reaper function is guaranteed to be called.
** Asynchronous reaping is still blocked upon exit, call wait_clear() to
** reenable it.
*/

void wait_forchild( void (*)(pid_t, int), /* Reaper */
	RETSIGTYPE (*)(int));	/* Signal handler stub */

#endif
