/*
** Copyright 1998 - 1999 Double Precision, Inc.
** See COPYING for distribution information.
*/

#include	"rfc1035.h"
#include	"rfc1035mxlist.h"
#include	"rfc1035_res.h"
#include	<sys/types.h>
#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<netinet/in.h>
#include	<arpa/inet.h>

static const char rcsid[]="$Id: testmxlookup.c,v 1.5 2000/02/21 03:01:18 mrsam Exp $";

static void setns(const char *p)
{
struct in_addr ia[4];
int	i=0;
char	*q=malloc(strlen(p)+1), *r;

	strcpy(q, p);
	for (r=q; (r=strtok(r, ", ")) != 0; r=0)
		if (i < 4)	ia[i++].s_addr=rfc1035_aton(r);

	rfc1035_init_ns(&rfc1035_default_resolver, ia, i);
	free(q);
}

int main(int argc, char **argv)
{
int	argn;
const char *q_name;
struct rfc1035_mxlist *mxlist, *p;

	argn=1;
	while (argn < argc)
	{
		if (argv[argn][0] == '@')
		{
			setns(argv[argn]+1);
			++argn;
			continue;
		}

		break;
	}

	if (argn >= argc)	exit(0);

	q_name=argv[argn++];

	switch (rfc1035_mxlist_create(&rfc1035_default_resolver,
		q_name, &mxlist))	{
	case	RFC1035_MX_OK:
		break;
	case	RFC1035_MX_SOFTERR:
		printf("Soft error.\n");
		exit(0);
	case	RFC1035_MX_HARDERR:
		printf("Hard error.\n");
		exit(0);
	case	RFC1035_MX_INTERNAL:
		printf("Internal error.\n");
		exit(0);
	case	RFC1035_MX_BADDNS:
		printf("Bad DNS records (recursive CNAME).\n");
		exit(0);
	}

	printf("Domain %s, mail sent to:\n", q_name);
	for (p=mxlist; p; p=p->next)
	{
	struct	sockaddr_in sin;
	const char *a;

		memcpy(&sin, &p->address, sizeof(sin));
		if (sin.sin_family != AF_INET)	continue;

		a=inet_ntoa(sin.sin_addr);
		printf("Host: %s, Priority: %d, Address: %s%s\n",
			p->hostname, p->priority, a,
			strcmp(p->hostname, a) ? "":" [ ERROR ]");
	}

	rfc1035_mxlist_free(mxlist);
	return (0);
}
