#ifndef	imapscanclient_h
#define	imapscanclient_h

/*
** Copyright 1998 - 1999 Double Precision, Inc.
** See COPYING for distribution information.
*/

static const char imapscanclient_h_rcsid[]="$Id: imapscanclient.h,v 1.2 1999/12/06 13:33:00 mrsam Exp $";
/*
** Stuff we want to know about an individual message in the maildir.
*/

struct imapscanmessageinfo {
	unsigned long uid;	/* See RFC 2060 */
	char *filename;
	int recentflag;
	int changedflags;	/* Set by imapscan_open */
	} ;

/*
** Stuff we want to know about the maildir.
*/

struct imapscaninfo {
	unsigned long nmessages;	/* # of messages */
	unsigned long uidv;		/* See RFC 2060 */
	unsigned long left_unseen;
	unsigned long nextuid;
	struct imapscanmessageinfo *msgs;
	} ;

int imapscan_maildir(struct imapscaninfo *, const char *, int);
void imapscan_free(struct imapscaninfo *);

int imapscan_openfile(const char *, struct imapscaninfo *, unsigned);

char *readline(unsigned, FILE *);

#endif
