/*
** Copyright 1998 - 1999 Double Precision, Inc.  See COPYING for
** distribution information.
*/

#if	HAVE_CONFIG_H
#include	"config.h"
#endif
#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<errno.h>
#include	<pwd.h>
#if	HAVE_UNISTD_H
#include	<unistd.h>
#endif

#include	"auth.h"
#include	"authmod.h"

static const char rcsid[]="$Id: authuserdb.c,v 1.9 2000/02/20 21:48:36 mrsam Exp $";

extern int auth_userdb_pre_common(const char *, const char *, int,
        int (*callback)(struct authinfo *, void *),
                        void *arg);

extern void auth_userdb_cleanup();

struct callback_info {
        const char *pass;
        char *userret;
        };

static int callback_userdb(struct authinfo *a, void *p)
{
struct callback_info *i=(struct callback_info *)p;

        if (a->passwd == 0 || authcheckpassword(i->pass, a->passwd))
                return (-1);

        if ((i->userret=strdup(a->sysusername)) == 0)
        {
                perror("malloc");
                return (1);
        }


	{
	static	char *prevp=0;
	const char *cp=a->maildir;
        char    *p;

		if (!cp)	cp="";
		p=malloc(sizeof("MAILDIR=")+strlen(cp));
                if (!p)
		{
			perror("malloc");
			free(i->userret);
			return (1);
		}
                strcat(strcpy(p, "MAILDIR="), cp);
                putenv(p);
		if (prevp)	free(prevp);
		prevp=p;
        }

        authsuccess(a->homedir, 0, a->sysuserid,
		&a->sysgroupid, a->address, a->fullname);

        return (0);
}


char *auth_userdb(const char *service, const char *authtype, char *authdata,
	int issession)
{
const char *user, *pass;
int	rc;
struct	callback_info	ci;

	if (strcmp(authtype, AUTHTYPE_LOGIN) ||
		(user=strtok(authdata, "\n")) == 0 ||
		(pass=strtok(0, "\n")) == 0)
	{
		errno=EPERM;
		return (0);
	}

	ci.pass=pass;
	rc=auth_userdb_pre_common(user, service, 1, &callback_userdb, &ci);
	auth_userdb_cleanup();
	if (rc < 0)
	{
		errno=EPERM;
		return (0);
	}
	if (rc > 0)
	{
		errno=EACCES;
		return (0);
	}
        return (ci.userret);
}

