/* Generated by GOB (v0.90.5) on Tue Dec 21 17:43:57 1999
   (do not edit directly) */

#include "balsa-druid-page-directory.h"


#line 29 "balsa-druid-page-directory.gob"

#include "balsa-app.h"
#include "save-restore.h"
#include "balsa-druid-page-error.h"

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <unistd.h>

static void unconditional_mailbox( const gchar *path, const gchar *prettyname, gchar **error );

static void unconditional_mailbox( const gchar *path, const gchar *prettyname, gchar **error )
{
	struct stat sb;
	gchar *dup;
	gchar *index;
	int fd;
	MailboxType mt;
	Mailbox *box;

	if( (*error) != NULL )
		return;

	dup = g_strdup( path );
	index = g_basename( dup );

	if( index == NULL ) {
		(*error) = g_strdup_printf( _("The pathname \"%s\" must be specified"
			" canonically -- it must start with a \'/\'."), dup );
		g_free( dup );
		return;
	}

	index[-1] = '\0'; /*Split off the dirs from the file.*/

	if( balsa_init_create_to_directory( dup, error ) ) {
		/*TRUE->error*/
		g_free( dup );
		return;
	}

	index[-1] = '/';

	if( stat( dup, &sb ) < 0 ) {
		if( (fd = creat( dup, S_IRUSR | S_IWUSR )) < 0 ) {
			(*error) = g_strdup_printf( _("An error occurred when attempting "
				"to creat(2) the file \"%s\"."), dup );
			g_free( dup );
			return;
		}

		close( fd );
	} else if( mailbox_valid( dup ) == MAILBOX_UNKNOWN ) {
		(*error) = g_strdup_printf( _("The mailbox \"%s\" does not appear to be valid."),
			dup );
		g_free( dup );
		return;
	}

	mt = mailbox_valid( dup );
	box = BALSA_MAILBOX( mailbox_new( mt ) );
	box->name = g_strdup( prettyname );
	(MAILBOX_LOCAL( box ))->path = dup;
	config_mailbox_add( box, (char *) prettyname );
	add_mailboxes_for_checking( box );
	gtk_object_destroy( GTK_OBJECT( box ) );
}


#line 80 "balsa-druid-page-directory.c"
static void balsa_druid_page_directory_class_init (BalsaDruidPageDirectoryClass *c);
static void balsa_druid_page_directory_init (BalsaDruidPageDirectory *self);
static void balsa_druid_page_directory_construct (BalsaDruidPage *self);
static void balsa_druid_page_directory_prepare (GnomeDruidPage *_self, GtkWidget *druid);
static gboolean balsa_druid_page_directory_next (GnomeDruidPage *_self, GtkWidget *druid);
static gboolean balsa_druid_page_directory_back (GnomeDruidPage *_self, GtkWidget *druid);

static BalsaDruidPageClass *parent_class = NULL;

guint
balsa_druid_page_directory_get_type (void)
{
	static guint type = 0;

	if (!type) {
		static const GtkTypeInfo info = {
			"BalsaDruidPageDirectory",
			sizeof (BalsaDruidPageDirectory),
			sizeof (BalsaDruidPageDirectoryClass),
			(GtkClassInitFunc) balsa_druid_page_directory_class_init,
			(GtkObjectInitFunc) balsa_druid_page_directory_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};

		type = gtk_type_unique (balsa_druid_page_get_type(), &info);
	}

	return type;
}


static GtkObject *(* new) (BalsaInitDruid *druid) = balsa_druid_page_directory_new;

#define GET_NEW (gtk_type_new(balsa_druid_page_directory_get_type()))
static void 
balsa_druid_page_directory_class_init (BalsaDruidPageDirectoryClass *c)
{
	BalsaDruidPageClass *balsa_druid_page_class = (BalsaDruidPageClass *)c;
	GnomeDruidPageClass *gnome_druid_page_class = (GnomeDruidPageClass *)c;

	parent_class = gtk_type_class (balsa_druid_page_get_type ());

	balsa_druid_page_class->construct = balsa_druid_page_directory_construct;
	gnome_druid_page_class->prepare = balsa_druid_page_directory_prepare;
	gnome_druid_page_class->next = balsa_druid_page_directory_next;
	gnome_druid_page_class->back = balsa_druid_page_directory_back;
return;
}
#line 125 "balsa-druid-page-directory.gob"
static void 
balsa_druid_page_directory_init (BalsaDruidPageDirectory *self)
#line 134 "balsa-druid-page-directory.c"
{
 {
#line 126 "balsa-druid-page-directory.gob"

		GtkTable *table;
		GtkLabel *label;
		gchar *preset;

		self->paths_locked = FALSE;

		self->emaster.setbits = 0;
		self->emaster.numentries = 0;
		self->emaster.donemask = 0;

		self->ed0.master = &( self->emaster );
		self->ed1.master = &( self->emaster );
		self->ed2.master = &( self->emaster );
		self->ed3.master = &( self->emaster );
		self->ed4.master = &( self->emaster );

		table = GTK_TABLE( gtk_table_new( 6, 2, FALSE ) );
	
		label = GTK_LABEL( gtk_label_new( _(
			"Please confirm the locations of your default mail files.\n"
			"These will be created if necessary." ) ) );
		gtk_label_set_justify( label, GTK_JUSTIFY_RIGHT );
		gtk_label_set_line_wrap( label, TRUE );
		gtk_table_attach( table, GTK_WIDGET( label ), 0, 2, 0, 1,
			GTK_EXPAND | GTK_FILL, GTK_EXPAND | GTK_FILL,
			8, 4 );

		preset = getenv( "MAIL" );
		if( preset )
			preset = g_strdup( preset );
		balsa_init_add_table_entry( table, 0, _("Inbox:"), preset, 
			&( self->ed0 ), GTK_WIDGET( self ), &( self->inbox ) );
		if( preset )
			g_free( preset );

		/* This used to set all the mail directories to their proper values
		 * as in the prepare code. But at this point balsa_app.local_mail_directory
		 * is NULL, so we use a dummy value. 
		 */
		balsa_init_add_table_entry( table, 1, _("Outbox:"), "[dummy value]", 
			&( self->ed1 ), GTK_WIDGET( self ), &( self->outbox ) );

		balsa_init_add_table_entry( table, 2, _("Sentbox:"), "[dummy value]", 
			&( self->ed2 ), GTK_WIDGET( self ), &( self->sentbox ) );

		balsa_init_add_table_entry( table, 3, _("Draftbox:"), "[dummy value]", 
			&( self->ed3 ), GTK_WIDGET( self ), &( self->draftbox ) );

		balsa_init_add_table_entry( table, 4, _("Trash:"), "[dummy value]", 
			&( self->ed4 ), GTK_WIDGET( self ), &( self->trash ) );

		gtk_box_pack_start( GTK_BOX( (GNOME_DRUID_PAGE_STANDARD( self ))->vbox ),
			GTK_WIDGET( table ), TRUE, TRUE, 8 );
		gtk_widget_show_all( GTK_WIDGET( table ) );
	
#line 194 "balsa-druid-page-directory.c"
 }
}


#line 117 "balsa-druid-page-directory.gob"
GtkObject *
balsa_druid_page_directory_new (BalsaInitDruid *druid)
{
	g_return_val_if_fail (BALSA_IS_INITDRUID (druid), (GtkObject *)0);
	g_return_val_if_fail (druid != NULL, (GtkObject *)0);
	{
#line 118 "balsa-druid-page-directory.gob"
		 
		GtkObject *self = GTK_OBJECT( GET_NEW );
		(BALSA_DRUID_PAGE( self ))->druid = GNOME_DRUID( druid );
		balsa_druid_page_directory_construct( BALSA_DRUID_PAGE( self ) );
		return self;
	
#line 213 "balsa-druid-page-directory.c"
	}
}


#line 183 "balsa-druid-page-directory.gob"
static void 
balsa_druid_page_directory_construct (BalsaDruidPage *self)
#define PARENT_HANDLER(args...) \
	{ if(BALSA_DRUID_PAGE_CLASS(parent_class)->construct) \
		(* BALSA_DRUID_PAGE_CLASS(parent_class)->construct)(##args); }
{
	{
#line 185 "balsa-druid-page-directory.gob"
		
		(GNOME_DRUID_PAGE_STANDARD( self ))->title = g_strdup( _("Mail Files" ) );

		g_return_if_fail( (BALSA_DRUID_PAGE( self ))->druid != NULL );
		(GNOME_DRUID_PAGE_STANDARD( self ))->logo_image = (BALSA_INITDRUID( (BALSA_DRUID_PAGE( self ))->druid ))->default_logo;

		PARENT_HANDLER( self );
	
#line 235 "balsa-druid-page-directory.c"
	}
}
#undef PARENT_HANDLER

#line 194 "balsa-druid-page-directory.gob"
static void 
balsa_druid_page_directory_prepare (GnomeDruidPage *_self, GtkWidget *druid)
#define PARENT_HANDLER(args...) \
	{ if(GNOME_DRUID_PAGE_CLASS(parent_class)->prepare) \
		(* GNOME_DRUID_PAGE_CLASS(parent_class)->prepare)(##args); }
{
	g_return_if_fail (GTK_IS_WIDGET (druid));
	g_return_if_fail (druid != NULL);
	{
#line 196 "balsa-druid-page-directory.gob"
		
		gchar *buf;
		BalsaDruidPageDirectory *self = BALSA_DRUID_PAGE_DIRECTORY( _self );

		/* We want a change in the local mailroot to be reflected in the directories
		 * here, but we don't want to trash user's custom settings if needed. Hence
		 * the paths_locked variable; it should work pretty well, because only a movement
		 * backwards should change the mailroot; going forward should not lock the paths:
		 * envision an error occurring; upon return to the Dir page the entries should be
		 * the same. 
		 */

		if( !self->paths_locked ) {
			buf = g_strconcat( balsa_app.local_mail_directory, "/outbox", NULL );
			gtk_entry_set_text( GTK_ENTRY( self->outbox ), buf );
			g_free( buf );

			buf = g_strconcat( balsa_app.local_mail_directory, "/sentbox", NULL );
			gtk_entry_set_text( GTK_ENTRY( self->sentbox ), buf );
			g_free( buf );

			buf = g_strconcat( balsa_app.local_mail_directory, "/draftbox", NULL );
			gtk_entry_set_text( GTK_ENTRY( self->draftbox ), buf );
			g_free( buf );

			buf = g_strconcat( balsa_app.local_mail_directory, "/trash", NULL );
			gtk_entry_set_text( GTK_ENTRY( self->trash ), buf );
			g_free( buf );
		}

		/* Don't let them continue unless all entries have something. */
		if( ENTRY_MASTER_DONE( self->emaster ) ) {
			gnome_druid_set_buttons_sensitive( GNOME_DRUID( druid ), TRUE, TRUE, TRUE );
		} else {
			gnome_druid_set_buttons_sensitive( GNOME_DRUID( druid ), TRUE, FALSE, TRUE );
		}

		gnome_druid_set_show_finish( GNOME_DRUID( druid ), FALSE );
	
#line 290 "balsa-druid-page-directory.c"
	}
}
#undef PARENT_HANDLER

#line 236 "balsa-druid-page-directory.gob"
static gboolean 
balsa_druid_page_directory_next (GnomeDruidPage *_self, GtkWidget *druid)
#define PARENT_HANDLER(args...) \
	{ if(GNOME_DRUID_PAGE_CLASS(parent_class)->next) \
		(* GNOME_DRUID_PAGE_CLASS(parent_class)->next)(##args); }
{
	g_return_val_if_fail (GTK_IS_WIDGET (druid), (gboolean )0);
	g_return_val_if_fail (druid != NULL, (gboolean )0);
	{
#line 238 "balsa-druid-page-directory.gob"
		
		gchar *error = NULL;
		BalsaDruidPageDirectory *self = BALSA_DRUID_PAGE_DIRECTORY( _self );	

		unconditional_mailbox( gtk_entry_get_text( GTK_ENTRY( self->inbox ) ),
			_("Inbox"), &error );
		unconditional_mailbox( gtk_entry_get_text( GTK_ENTRY( self->outbox ) ),
			_("Outbox"), &error );
		unconditional_mailbox( gtk_entry_get_text( GTK_ENTRY( self->sentbox ) ),
			_("Sentbox"), &error );
		unconditional_mailbox( gtk_entry_get_text( GTK_ENTRY( self->draftbox ) ),
			_("Draftbox"), &error );
		unconditional_mailbox( gtk_entry_get_text( GTK_ENTRY( self->trash ) ),
			_("Trash"), &error );

		self->paths_locked = TRUE;

		if( error ) {
			BalsaDruidPageError *ep;

			ep = BALSA_DRUID_PAGE_ERROR( balsa_druid_page_error_new_after( BALSA_DRUID_PAGE( self ),
				_("Problem Creating Mailboxes"), error ) );
			g_free( error );
			balsa_druid_page_error_goto_me( ep );
		} else {
			PARENT_HANDLER( _self, druid );
		}

		return TRUE;
	
#line 336 "balsa-druid-page-directory.c"
	}
}
#undef PARENT_HANDLER

#line 269 "balsa-druid-page-directory.gob"
static gboolean 
balsa_druid_page_directory_back (GnomeDruidPage *_self, GtkWidget *druid)
#define PARENT_HANDLER(args...) \
	{ if(GNOME_DRUID_PAGE_CLASS(parent_class)->back) \
		(* GNOME_DRUID_PAGE_CLASS(parent_class)->back)(##args); }
{
	g_return_val_if_fail (GTK_IS_WIDGET (druid), (gboolean )0);
	g_return_val_if_fail (druid != NULL, (gboolean )0);
	{
#line 271 "balsa-druid-page-directory.gob"
		
		BalsaDruidPageDirectory *self = BALSA_DRUID_PAGE_DIRECTORY( _self );	
		
		self->paths_locked = FALSE;
		PARENT_HANDLER( _self, druid );
		return TRUE;
	
#line 359 "balsa-druid-page-directory.c"
	}
}
#undef PARENT_HANDLER
#undef GET_NEW


/*REALLY BAD HACK
  This is to avoid unused warnings if you don't call
  some method, it pollutes the namespace but the call
  is weird enough.  I need to find a better way to do
  this */
void __balsa_druid_page_directory_really_bad_hack_to_avoid_warnings(void);
void
__balsa_druid_page_directory_really_bad_hack_to_avoid_warnings(void)
{
	((void (*)(void))new)();
}

