/*
                           Generic Dialog

	Function:

	void GenDialogDestroyCB(  
	        GtkWidget *widget,
	        GdkEvent *event,
	        gpointer data
	)
	void GenDialogButtonCB(GtkWidget *widget, gpointer data)
	void GenDialogShowMessage(
	        gen_dialog_struct *d,
	        char *label
	)
	void dprint(gen_dialog_struct *d, char *label) 

	int GenDialogCreate(
	        gen_dialog_struct *d,
	        char *label,
	        unsigned long options
	)
	void GenDialogDestroy(gen_dialog_struct *d)

	---

 */

#include "gendialog.h"



void gtk_widget_center(
	GtkWidget *widget,
	gint flags
)
{
	GdkWindow *parent;
	gint width1, height1, width2, height2;


	if(widget == NULL)
	    return;

	gtk_widget_realize(widget);

	if(widget->window == NULL)
	    return;

	parent = gdk_window_get_parent(widget->window);
        if(parent != NULL)
        {
	    gdk_window_get_size(widget->window, &width1, &height1);
            gdk_window_get_size(parent, &width2, &height2);

            gtk_widget_set_uposition(
		widget,
		((int)width2 / 2) - ((int)width1 / 2),
		((int)height2 / 2) - ((int)height1 / 2)
            );
	}

	return;
}


void GenDialogDestroyCB(
        GtkWidget *widget,
        GdkEvent *event,
        gpointer data
)
{
        gen_dialog_struct *d;


        d = (gen_dialog_struct *)data;
        if(d == NULL)
            return;

	GenDialogDestroy(d);


	return;
}

void GenDialogButtonCB(GtkWidget *widget, gpointer data)
{
	gen_dialog_struct *d;


	d = (gen_dialog_struct *)data;
	if(d == NULL)
	    return;

	if(d->ok_btn == widget)
	{
	    if(d->toplevel != NULL)
		gtk_widget_hide(d->toplevel);
	}

	return;
}


/*
 *	Changes dialog label message (if label is not NULL) and
 *	shows it.
 */
void GenDialogShowMessage(
	gen_dialog_struct *d,
        char *label
)
{
	if(d == NULL)
	    return;

	if(!d->initialized)
	    return;

	if((d->toplevel == NULL) ||
           (d->label == NULL)
	)
	    return;

	if(label == NULL)
	    gtk_label_set_text(GTK_LABEL(d->label), "");
	else
	    gtk_label_set_text(GTK_LABEL(d->label), label);

	gtk_widget_center(d->toplevel, 0);
	gtk_widget_show(d->toplevel);


	return;
}
void dprint(gen_dialog_struct *d, char *label)
{
	GenDialogShowMessage(d, label);

	return;
}



int GenDialogCreate(
        gen_dialog_struct *d,
        char *label,
        unsigned long options
)
{
	GtkWidget *w, *parent, *label_hbox, *btn_hbox;


	if(d == NULL)
	    return(-1);


	/* Check if this dialog is already initialized. */
	if(!d->initialized)
	{
	    d->initialized = 1;

            /* Load fonts. */
            d->font = gdk_font_load(
                "-misc-fixed-medium-r-*-*-*-100-*-*-*-*-*-*"
            );


            /* Toplevel. */
            w = gtk_window_new(GTK_WINDOW_DIALOG);
            d->toplevel = w;
	    gtk_widget_realize(w);
            gtk_window_set_policy(
                GTK_WINDOW(w),
                TRUE, TRUE, FALSE
            );
            gtk_signal_connect(
                GTK_OBJECT(w), 
                "delete_event",
                GTK_SIGNAL_FUNC(GenDialogDestroyCB),
                d
            );
            gtk_signal_connect(
                GTK_OBJECT(w),
                "destroy",
                GTK_SIGNAL_FUNC(GenDialogDestroyCB),
                d
            );
            gtk_window_set_title(GTK_WINDOW(w), "Dialog");
            gtk_container_set_border_width(GTK_CONTAINER(w), 5);

            /* Main vertical box. */
	    parent = d->toplevel;
            w = gtk_vbox_new(FALSE, 5);
            gtk_container_add(GTK_CONTAINER(parent), w);
            gtk_widget_show(w);

	    parent = w;	/* Parent is now the vertical box. */


	    /* Horizontal box (for label and icons). */
	    label_hbox = gtk_hbox_new(FALSE, 5);
	    w = label_hbox;
            gtk_container_add(GTK_CONTAINER(parent), w);
            gtk_widget_show(w);

	    /* Label. */
            w = gtk_label_new(
                ((label == NULL) ? "No message." : label)
            );
            d->label = w;
            gtk_container_add(GTK_CONTAINER(label_hbox), w);
            gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_LEFT);
            gtk_widget_show(w);


	    /* Horizontal seperator. */
            w = gtk_hseparator_new();
            gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 2);
            gtk_widget_show(w);

	    /* Ok button. */
	    if(options & GDIALOG_OPT_OK_BTN)
	    {
                /* Horizontal box for button. */
                w = gtk_hbox_new(TRUE, 0);
                btn_hbox = w;
                gtk_container_add(GTK_CONTAINER(parent), w);
                gtk_widget_show(w);


                w = gtk_button_new_with_label("OK");
	        d->ok_btn = w;
		gtk_widget_set_usize(w, 60, 25);
	        gtk_box_pack_start(GTK_BOX(btn_hbox), w, FALSE, FALSE, 2);
                gtk_signal_connect(
                    GTK_OBJECT(w),
                    "clicked",
                    GTK_SIGNAL_FUNC(GenDialogButtonCB),
                    d
                );
                gtk_widget_show(w);
	    }
	    else
	    {
		d->ok_btn = NULL;
	    }
	}
	else
	{
	    /* Should be already initialized, double check. */
	    if(d->toplevel == NULL)
	    {
		d->initialized = 0;
		return(-1);
	    }


	    /* Just change label. */


	}


	if(options & GDIALOG_OPT_SHOWONCREATE)
	    gtk_widget_show(d->toplevel);


	return(0);
}

void GenDialogDestroy(gen_dialog_struct *d)
{
	if(d == NULL)
	    return;

	if(d->initialized)
	{
	    if(d->toplevel != NULL)
		gtk_widget_hide(d->toplevel);
	}

	d->initialized = 0;
	d->toplevel = NULL;


	return;
}
