/*								-*- C++ -*-
 * $Id: IPC_socket.h,v 1.1 1996-09-25 11:06:29+02 mho Exp $
 *
 * Purpose: socket managment
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifndef SafeSock_h
#define SafeSock_h

#ifdef __GNUG__
#pragma interface
#endif

class MiniStopwatch {
    timeval startTV, stopTV;
    Bool    running;
public:
    MiniStopwatch(void);
    ~MiniStopwatch(void);

    long howLong(void);
    Bool isRunning(void);
    Bool past(long msec);
    Bool slowPast(long msec);
    void start(void);
    void stop(void);
    void tick(void);
};

// Manage a file descriptor.  Wrap data on writes and unwrap it on reads.
class SafeSock {
public:
    SafeSock(int fd_, Bool ownFd_ = FALSE);
    ~SafeSock(void);

    void clearTimedOut(void);
    Bool findMsg(char*& start, char*& end);
    int  getFd(void);
    Bool lastTimedOut(void);
    int  read(char *buf, int nBytes, Bool& isWhole, Bool& isMore);
    void setTimeout(int msec);
    int  write(char *buf, int nBytes);
private:
    friend class SockMgr;

    char*  inBox;		  // Accumulates incoming messages.
    size_t inBoxLen;		  // strlen of preceding.
    const  int fd;		  // The fd that this SafeSock manages.
    Bool   ownFd;		  // If true, close fd in dtor.
    Bool   timedOut;		  // Flag: last read/write op timed out?
    int    timeout;		  // msec to wait before giving up.

    static const char* MAGIC;	  // Magic sequence must appear at msg end.
    static const int   MAGIC_LEN; // strlen of preceding.
    static const int   COUNT_LEN; // Exact # digits in byte-count wrapper.
    static const int   OVRHD_LEN; // Total bytes of overhead info per write.
    static const char  SEP_CHAR;  // Magic char to separate count from data.

    MiniStopwatch stopwatch;
};

class SockMgr {
public:
    SockMgr(void);
    ~SockMgr(void);

    // No fn bodies: prevent copying.
    SockMgr(const SockMgr &);
    SockMgr& operator = (const SockMgr &);

    int       accept(int fd, struct sockaddr* addr, int * addrLen);
    void      addSock(int fd);
    void      clearTimedOut(int fd);
    int       close(int fd);
    int       connect(int fd, struct sockaddr* name, int nameLen);
    static SockMgr& create(void);
    SafeSock* getSock(int fd);
    Bool      lastTimedOut(int fd);
    int       read(int fd, char* buf, int nBytes, Bool& isWhole, Bool& isMore);
    void      setTimeout(int fd, int msec);
    int       write(int fd, char * buf, int nBytes);
private:
    static SockMgr* master;   // A ptr to the sole SockMgr (or 0 if none).
    wxList socks;             // A list of ptrs to SafeSock objects.
};

#endif // SafeSock_h
