/*								-*- C++ -*-
 * $Id: WIN_choice.cpp,v 1.2 1997-01-15 14:59:00+01 mho Exp $
 *
 * Purpose: choice panel item
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifdef __GNUG__
#pragma implementation "WIN_choice.h"
#endif

#define  Uses_XtIntrinsic
#define  Uses_wxChoice
#include "wx.h"
#define  Uses_EnforcerWidget
#define  Uses_MenuWidget
#include <widgets.h>

//-----------------------------------------------------------------------------
// create and destroy button
//-----------------------------------------------------------------------------

IMPLEMENT_DYNAMIC_CLASS(wxChoice, wxItem)

wxChoice::wxChoice(void) : wxItem()
{
    __type = wxTYPE_CHOICE;

    top         = NULL;
    last        = NULL;
    num_choices = 0;
    selection   = -1;
}

wxChoice::wxChoice(wxPanel *panel, wxFunction function, Const char *label,
		   int x, int y, int width, int height,
		   int n, char *choices[], long style, Constdata char *name) : wxItem()
{
    __type = wxTYPE_BUTTON;

    top         = NULL;
    last        = NULL;
    num_choices = 0;
    selection   = -1;

    Create(panel, function, label, x, y, width, height, n, choices, style, name);
}

Bool wxChoice::Create(wxPanel *panel, wxFunction function, Const char *label,
		      int x, int y, int width, int height,
		      int n, char *choices[], long style, Constdata char *name)
{
    ChainToPanel(panel, style, name);

    int  i;

    // create the list (first twice for the visible selection)
    //if  (n)		     Append(choices[0]);
    for (i = 0; i < n; ++i)  Append(choices[i]);
    selection = n > 0 ? 0 : -1;
    // create frame
    FWidget() = XtVaCreateManagedWidget
	(name, xfwfEnforcerWidgetClass, GetParentWidget(parent),
	 XtNlabel,       label,
	 XtNlabelOffset, 2,
	 XtNalignment,   (label_position == wxVERTICAL) ? XfwfTop : XfwfLeft,
	 XtNbackground,  bg.GetPixel(&cmap),
	 XtNforeground,  label_fg.GetPixel(&cmap),
	 XtNfont,        label_font.GetInternalFont(),
	 XtNshrinkToFit, TRUE,
	 XtNhighlightThickness, 0,
	 NULL);
    // make sure the widget is wide enough initially
    char *top_old = 0;
    if (width < 0 && top) {
	char *wide_label = 0;
	int w, w_max=0;

	for(menu_item *item = ((menu_item *)top)->contents;
	    item;
	    item=item->next) {
	    w = XTextWidth(font.GetInternalFont(), item->label,
			   strlen(item->label));
	    if(w > w_max) {
		w_max = w;
		wide_label = item->label;
	    }
	}
	top_old = ((menu_item*)top)->label;
	((menu_item*)top)->label = wide_label;
    }
    // create widget
    HWidget() = XtVaCreateManagedWidget
	(name, xfwfMenuWidgetClass, FWidget(),
	 XtNbackground,         bg.GetPixel(&cmap),
	 XtNforeground,         fg.GetPixel(&cmap),
	 XtNfont,               font.GetInternalFont(),
	 XtNcursor,		cursor->GetCursor(),
	 XtNhorizontal,		FALSE,
	 XtNhighlightThickness, 2,
	 XtNframeWidth,         2,
	 XtNusedAsChoice,       TRUE,
	 XtNmenu,               top,
	 NULL);
    // set shrinkToFit
    XtVaSetValues(FWidget(), XtNshrinkToFit, FALSE, NULL);
    if(top_old) {
	((menu_item*)top)->label = top_old;
	XfwfSetMenu(HWidget(), (menu_item*)top, FALSE);
    }
    // set data declared in wxItem
    callback = function;
    XtAddCallback(HWidget(), XtNonSelect, wxChoice::EventCallback, (XtPointer)this);

    panel->PositionItem(this, x, y, width, height);
    AddEventHandlers();

    return TRUE;
}

wxChoice::~wxChoice (void)
{
    menu_item *top_item = (menu_item*)top;

    Clear();
    if (top_item) {
	if (top_item->label)
	    XtFree(top_item->label);
	XtFree((char*)top);
	top = NULL;
    }
}

//-----------------------------------------------------------------------------
// methods to access internal data
//-----------------------------------------------------------------------------

void wxChoice::Append(char *s)
{
    menu_item *new_item  = XtNew(menu_item); // new item to append to menu
    menu_item *last_item = (menu_item*)last; // last item in current list
    menu_item *top_item  = (menu_item*)top;  // top item (= "menubar")

    // initialize menu_item
    new_item->label       = (char*)XtNewString(s);
    new_item->underline   = NULL;
    new_item->key_binding = (char*)NULL;
    new_item->help_text   = (char*)NULL;
    new_item->ID          = last_item ? last_item->ID + 1 : 0;
    new_item->enabled     = TRUE;
    new_item->set         = FALSE;
    new_item->contents    = (menu_item*)NULL;
    new_item->next        = (menu_item*)NULL;
    new_item->user_data   = NULL;
    new_item->type        = top ? MENU_BUTTON : MENU_CASCADE;

    Boolean shrink = False;
    if (FWidget()) XtVaGetValues(FWidget(), XtNshrinkToFit, &shrink, NULL);

    if (top_item) {
	if (last_item)	last_item->next = new_item;	// append to submenu
	else		top_item->contents = new_item;	// init submenu
	last = (void*)new_item;				// new last item
	++num_choices;					// new choice added
    } else {
	top = (void*)new_item;				// new "menubar"
	selection = 0;
	if (HWidget()) XfwfSetMenu(HWidget(), (menu_item*)top, shrink);
	Append(s);
    }
}

void wxChoice::Clear(void)
{
    menu_item *top_item  = (menu_item*)top;
    menu_item *item      = (top_item ? top_item->contents : (menu_item*)NULL);

    // delete everything but the top (= "menubar");
    while (item) {
	menu_item *next = item->next;
	if (item->label)
	    XtFree(item->label);
	XtFree((char*)item);
	item = next;
    }
    last = NULL;
    if (top) {
	if (top_item->label)
	    XtFree(top_item->label);
	top_item->label = NULL;
	top_item->contents = NULL;
    }
    selection   = -1;
    num_choices = 0;
}

int wxChoice::FindString(char *s)
{
    menu_item *top_item = (menu_item*)top;
    menu_item *item     = (top ? top_item->contents : (menu_item*)NULL);

    while (item) {
	if (strcmp(s, item->label) == 0)
	    return (item->ID);
	item = item->next;
    }
    return (-1);
}

char *wxChoice::GetString(int n)
{
    menu_item *top_item = (menu_item*)top;
    menu_item *item     = (top ? top_item->contents : (menu_item*)NULL);

    if (0 <= n && n < num_choices) {
	int i;
	for (i = 0; i < n && item; ++i)
	    item = item->next;
	return (item ? item->label : (char*)NULL);
    }
    return (char*)NULL;
}

char *wxChoice::GetStringSelection(void)
{
    return GetString(selection);
}

void wxChoice::SetSelection(int n)
{
    menu_item *top_item = (menu_item*)top;

    if (0 <= n && n < num_choices && n != selection) {
	selection = n;
	/* set new label for menu */
	if (top_item->label)
	    XtFree(top_item->label);
	top_item->label = (char*)XtNewString(GetString(selection));
	/* redisplay menu */
	Boolean shrink = False;
	if (FWidget()) XtVaGetValues(FWidget(), XtNshrinkToFit, &shrink, NULL);
	if (HWidget()) XfwfSetMenu(HWidget(), top_item, shrink);
    }
}

void wxChoice::SetStringSelection(char *s)
{
    SetSelection(FindString(s));
}

//-----------------------------------------------------------------------------
// callback for commandWidgetClass
//-----------------------------------------------------------------------------

void wxChoice::EventCallback(Widget WXUNUSED(w), XtPointer dclient, XtPointer dcall)
{
    wxChoice  *choice = (wxChoice*)dclient;
    menu_item *item   = (menu_item*)dcall;

    if (item->ID == choice->selection)
	/* no change */
	return;

    wxCommandEvent event(wxEVENT_TYPE_CHOICE_COMMAND);
  
    event.commandInt    = item->ID;
    event.commandString = item->label;

    choice->SetSelection(item->ID);
    choice->ProcessCommand(event);
}
