/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *   
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */


#include "vdk/vdkcsortlist.h"
#include "vdk/forms.h"

VDKCustomSortedList::VDKCustomSortedList(VDKForm* owner,
		      int keyPos,
		      int columns,
		      char **titles,
					 GtkSelectionMode mode):
    VDKCustomList(owner,columns,titles,mode),keypos(keyPos)
{
Unique = false;
oldkey = NULL;
}

bool VDKCustomSortedList::AddKey(char **s, 
				 char** pixdata, 
				 int col)
{
 
  Tuple tuple(columns,keypos);
  int j ;
  for(j = 0; j < tuple.size(); j++)
    tuple[j] = s[j];
  int row = Tuples.insert(tuple,Unique);
  // in case of key clush
  if( row < 0)
    return false;
  row = gtk_clist_insert(GTK_CLIST(custom_widget),row,s);
  SetStyle(row);
  pointer = pointer < 0 ? 0 : pointer;
  if(pixdata)
    _update_pix(row,s[col],pixdata,col);
  return true;
}  
/*
 */
void VDKCustomSortedList::UpdateKey(char* key, char** s, 
	      char** pixdata, int col)
{
  VDKString k(key); 
  int row = 0;
  TupleListIterator li(Tuples);
  for(;li;li++,row++)
    if (li.current()[keypos] == k)
      break;
  if(row < Tuples.size())
    {
      VDKCustomList::RemoveRow(row);
      AddRow(s,pixdata,col);
    }
}
/*
 */
void VDKCustomSortedList::UpdateCellKey(char* key, int col, 
		  char* s, char** pixdata)
{
  VDKString k(key);
  int row = 0;
  TupleListIterator li(Tuples);
  if(col == keypos) 
    return; // changing key not allowed
  for(;li;li++,row++)
    if (li.current()[keypos] == k)
      break;
  if(row < Tuples.size())
	VDKCustomList::UpdateCell(row,col,s,pixdata);
}
/*
 */
void VDKCustomSortedList::RemoveKey(char* key)
{
  VDKString k(key);
  int row = 0;
  TupleListIterator li(Tuples);
  for(;li;li++,row++)
    if (li.current()[keypos] == k)
      break;
  if(row < Tuples.size())
    VDKCustomList::RemoveRow(row);
}
/*
 */
int
VDKCustomSortedList::FindKey(char* key)
{
int t = 0;
if(! oldkey)
  return -1;
TupleListIterator li(Tuples);
for(;li;li++,t++)
  {
    char* p = (char*) li.current()[keypos];
    if(!strcmp(p,key))
      return t;
  }
return -1;
}

 

