/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
*/


#include "vdk/rawobj.h"
#include "vdk/vdkobj.h"
#include "vdk/forms.h"
#include <config.h>
#include <stdio.h>

#ifdef VDKDEBUG
extern int objectC;
extern int objectD;
#endif
/*
 */
VDKRawObject::VDKRawObject(VDKObject* owner): 
  owner(owner)
{
if(owner) 
  {
    owner->raws.add(this);
#ifdef VDKDEBUG
      objectC++;
#endif
  }
}
/*
 */

bool VDKRawObject::Destroy()
{
  
  RawList *raws = &owner->raws;
  if(raws->remove(this))
    {
#ifdef VDKDEBUG
      printf("\n(raw) destroyed:%p",this);
      fflush(stdout);
#endif
      delete this;
      return true;
    }
  else
    return false;
}
/*
 */
VDKRawObject::~VDKRawObject() 
{
#ifdef VDKDEBUG
      objectD++;
#endif
}

