#include <testclasses.h>

extern "C" {
#    include <string.h>
#    include <stdio.h>
}

VDKObjectTest::VDKObjectTest(VDKObject* obj)
{
     _classname="VDKObject";
     obj->OnKeyPress.connect(slot(*this, 
				  &VDKObjectTest::onkeypress_response));
     obj->OnKeyPress.connect(slot(*this,
				  &VDKObjectTest::onkeyrelease_response));
     obj->SetTip(_classname);
}

void
VDKObjectTest::onkeypress_response(VDKObject* obj, char* key)
{
     char mesg[256];
     sprintf(mesg,"%s\n\t OnKeyPress: %s\n", _classname, key);
     OnMesg(obj, mesg);
}

void
VDKObjectTest::onkeyrelease_response(VDKObject* obj, char* key)
{
     char mesg[256];
     sprintf(mesg,"%s\n\t OnKeyRelease: %s\n", _classname, key);
     OnMesg(obj, mesg);
}

VDKAbstractButtonTest::VDKAbstractButtonTest(VDKAbstractButton* obj)
     : VDKObjectTest(obj)
{
     _classname="VDKAbstractButton";
     obj->OnButtonPressed.connect(slot(*this,
				       &VDKAbstractButtonTest::onbtnpressed_resp));
     obj->OnButtonLeave.connect(slot(*this,
				     &VDKAbstractButtonTest::onbtnleave_resp));
     obj->OnButtonClicked.connect(slot(*this,
				       &VDKAbstractButtonTest::onbtnclicked_resp));
     obj->SetTip(_classname);
}

void
VDKAbstractButtonTest::onbtnclicked_resp(VDKObject* obj)
{
     char mesg[256];
     sprintf(mesg,"%s\n\t OnButtonClicked\n", _classname);
     OnMesg(obj, mesg);
}

void
VDKAbstractButtonTest::onbtnpressed_resp(VDKObject* obj)
{
     char mesg[256];
     sprintf(mesg,"%s\n\t OnButtonPressed\n", _classname);
     OnMesg(obj, mesg);
}

void
VDKAbstractButtonTest::onbtnleave_resp(VDKObject* obj)
{
     char mesg[256];
     sprintf(mesg,"%s\n\t OnButtonLeave\n", _classname);
     OnMesg(obj, mesg);
}

/* VDKCheckButtonTest */

VDKCheckButtonTest::VDKCheckButtonTest(VDKCheckButton* obj)
     : VDKAbstractButtonTest(obj)

{
     _classname="VDKCheckButton";
     obj->OnButtonToggled.connect(slot(*this,
				       &VDKCheckButtonTest::onbtntog_resp));
     obj->SetTip(_classname);
}

void
VDKCheckButtonTest::onbtntog_resp(VDKObject* obj, bool state)
{
     char mesg[256];

     if(state)
       sprintf(mesg,"%s\n\t OnButtonToggled: true\n", _classname);
     else
       sprintf(mesg,"%s\n\t OnButtonToggled: false\n", _classname);
     OnMesg(obj, mesg);
}

/* VDKToggleButtonTest */

VDKToggleButtonTest::VDKToggleButtonTest(VDKToggleButton* obj)
  : VDKAbstractButtonTest(obj)
{
     _classname="VDKToggleButton";
     obj->OnButtonToggled.connect(slot(*this,
				       &VDKToggleButtonTest::onbtntog_resp));
     obj->SetTip(_classname);
}

void
VDKToggleButtonTest::onbtntog_resp(VDKObject* obj, bool state)
{
     char mesg[256];
     
     if(state)
       sprintf(mesg ,"%s\n\t OnButtonToggled: true\n", _classname);
     else
       sprintf(mesg ,"%s\n\t OnButtonToggled: false\n", _classname);
     OnMesg(obj, mesg);
}

/* VDKSpinButtonTest */
VDKSpinButtonTest::VDKSpinButtonTest(VDKSpinButton* obj)
     : VDKObjectTest(obj)
{
     _classname="VDKSpinButton";
     obj->OnSpinValueChanged.connect(slot(*this,
					  &VDKSpinButtonTest::onvaluechanged));
     obj->SetTip(_classname);
}

void
VDKSpinButtonTest::onvaluechanged(VDKObject* obj, float val)
{
     char mesg[256];

     sprintf(mesg,"%s\n\t OnSpinValueChanged %f\n",
	     _classname, val);
     OnMesg(obj, mesg);
}

/* VDKCustomTest */
VDKCustomTest::VDKCustomTest(VDKCustom* obj)
  : VDKObjectTest(obj)
{
     _classname="VDKCustom";
     obj->OnColumnClick.connect(slot(*this,
				     &VDKCustomTest::oncolumnclick));
     obj->SetTip(_classname);
}

void
  VDKCustomTest::oncolumnclick(VDKObject* obj, int col)
{
     char mesg[256];
     sprintf(mesg, "%s\n\t OnColumnClicked %i\n", _classname, col);
     OnMesg(obj, mesg);
}

/* VDKCustomListTest */
VDKCustomListTest::VDKCustomListTest(VDKCustomList* obj)
     : VDKCustomTest(obj)
{
     _classname="VDKCustomList";

     char* r1[4]={"Dies","ist","der", "Text"};
     char* r2[4]={"This","is","the","text"};
     char* r3[4]={"Tri","Tra","Tru","Lala"};
     obj->AddRow(r1);
     obj->AddRow(r2);
     obj->AddRow(r3);

     obj->OnRowSelect.connect(slot(*this,
				   &VDKCustomListTest::onrowselect));
     obj->OnRowUnselect.connect(slot(*this,
				     &VDKCustomListTest::onrowunselect));
//      obj->OnRowRemove.connect(slot(*this,
// 				   &VDKCustomListTest::onrowremove));
//      obj->OnRowInsert.connect(slot(*this,
// 				   &VDKCustomListTest::onrowinsert));
     obj->OnRowMove.connect(slot(*this,
				 &VDKCustomListTest::onrowmove));
     obj->SetTip(_classname);
}

void
VDKCustomListTest::onrowselect(VDKObject* obj, int row, int col)
{
     char mesg[256];
     sprintf(mesg,"%s\n\t OnRowSelect:  Row=%i, Column=%i\n",
	     _classname, row, col);
     OnMesg(obj,mesg);
}

void
VDKCustomListTest::onrowunselect(VDKObject* obj, int row, int col)
{
     char mesg[256];
     sprintf(mesg,"%s\n\t OnRowUnselect: Row=%i, Column=%i\n",
	     _classname, row, col);
     OnMesg(obj, mesg);
}

// void
// VDKCustomListTest::onrowremove(VDKObject* obj, int row)
// {
//      char mesg[256];
//      sprintf(mesg,"%s\n\t OnRowRemove: Row=%i\n",
// 	     _classname, row);
//      OnMesg(obj, mesg);
// }

// void
// VDKCustomListTest::onrowinsert(VDKObject* obj, int row, const char** titles)
// {
//      char mesg[256];
//      sprintf(mesg,"%s\n\t OnRowInsert: Row:%i\n", // Noch nicht fertig
// 	     _classname, row);
//      OnMesg(obj, mesg);
// }

void
VDKCustomListTest::onrowmove(VDKObject* obj, int from, int to)
{
     char mesg[256];
     sprintf(mesg,"%s\n\t OnRowMove: From: %i To; %i\n",
	     _classname, from, to);
     OnMesg(obj, mesg);
}


/* VDKCustomTreeTest */
VDKCustomTreeTest::VDKCustomTreeTest(VDKCustomTree* obj)
     : VDKCustomTest(obj)
{
     _classname="VDKCustomTreeTest";
     char* nname1[1]={"Node 1"};
     char* nname2[1]={"Node 2"};
     char* nname3[1]={"Node 3"};
     char* nname4[1]={"Node 4"};
     char* nname5[1]={"Node 5"};
     char* nname1_1[1]={"Node 1.1"};
     char* nname2_1[1]={"Node 2.1"};
     char* nname3_1[1]={"Node 3.1"};
     char* nname3_2[1]={"Node 3.1.1"};

     obj->AddNode(nname1_1,obj->AddNode(nname1,NULL));
     obj->AddNode(nname2_1,obj->AddNode(nname2,NULL));
     obj->AddNode(nname3_2,
		  obj->AddNode(nname3_1, 
			       obj->AddNode(nname3, NULL))); // is_lisp? ;)
     obj->AddNode(nname4,NULL);
     obj->AddNode(nname5,NULL);

     obj->OnNodeSelect.connect(slot(*this,
				    &VDKCustomTreeTest::onnodeselect));
     obj->OnNodeUnselect.connect(slot(*this,
				      &VDKCustomTreeTest::onnodeunselect));
     obj->OnTreeMove.connect(slot(*this,
				  &VDKCustomTreeTest::ontreemove));
     obj->SetTip(_classname);
}

void
VDKCustomTreeTest::onnodeselect(VDKObject* obj, VDKTreeNode node, int col)
{
     char mesg[256];
     sprintf(mesg, "%s\n\t OnNodeSelect: Node: %s, Col: %i\n",
	     _classname, 
	     reinterpret_cast<VDKCustomTree*>(obj)->Key(node),
	     col);
     OnMesg(obj, mesg);
}

void
VDKCustomTreeTest::onnodeunselect(VDKObject* obj, VDKTreeNode node, int col)
{
     char mesg[256];
     sprintf(mesg, "%s\n\t OnNodeUnselect: Node: %s, Col: %i\n",
	     _classname, 
	     reinterpret_cast<VDKCustomTree*>(obj)->Key(node),
	     col);
     OnMesg(obj, mesg);
}

void
VDKCustomTreeTest::ontreemove(VDKObject* obj, VDKTreeNode node,
			      VDKTreeNode parent, VDKTreeNode sibling)
{
     char mesg[256];
     sprintf(mesg, "%s\n\t OnTreeMove:\n", _classname);
     OnMesg(obj, mesg);
}

/* VDKComboTest */

VDKComboTest::VDKComboTest(VDKCombo* obj)
     : VDKObjectTest(obj)
{
     _classname="VDKCombo";

     StringList sl = obj->PopdownStrings;
     sl.add(VDKString("Item 0"));
     sl.add(VDKString("Item 1"));
     sl.add(VDKString("Item 2"));
     sl.add(VDKString("Item 3"));
     sl.add(VDKString("Item 4"));
     sl.add(VDKString("Item 5"));			     
     obj->PopdownStrings=sl;

     obj->OnItemSelect.connect(slot(*this,
				    &VDKComboTest::onitemselect));
     obj->OnItemUnselect.connect(slot(*this,
				      &VDKComboTest::onitemunselect));
     obj->OnItemActivate.connect(slot(*this,
				      &VDKComboTest::onitemactivate));
     obj->OnItemTextChanged.connect(slot(*this,
					 &VDKComboTest::onitemtextchanged));
     obj->SetTip(_classname);
}

void
VDKComboTest::onitemselect(VDKObject* obj, int item)
{
     char mesg[256];
     // gtk-signale abkoppeln im Destruktor!!!
     if(item >= 0){
	  sprintf(mesg,"%s \n\t OnItemSelect: %i (%s)\n",
		  _classname, item, 
		  (char*) (((VDKCombo*) obj)->GetPopdownStrings()[item]));
     OnMesg(obj, mesg);
     }
}

void
VDKComboTest::onitemunselect(VDKObject* obj, int item)
{
     char mesg[256];
     
     if(item >= 0){
	  sprintf(mesg,"%s \n\t OnItemUnselect: %i (%s)\n",
		  _classname, item, 
		  (char*)(((VDKCombo*) obj)->GetPopdownStrings()[item]));
	  OnMesg(obj, mesg);
     }
}

void
VDKComboTest::onitemactivate(VDKObject* obj, int item)
{
     char mesg[256];
     if(item >= 0){
	  sprintf(mesg,"%s \n\t OnItemActviate: %i (%s)\n",
		  _classname, item, 
		  (char*) (((VDKCombo*) obj)->GetPopdownStrings()[item]));
	  OnMesg(obj, mesg);
     }
}

void
VDKComboTest::onitemtextchanged(VDKObject* obj, int item, const char* text)
{
     char mesg[256];
     sprintf(mesg, "%s \n\t OnItemTextChanged : %i, %s\n",
	     _classname, item, text);
     OnMesg(obj, mesg);
}





