/*
 * ===========================
 * VDK Visual Develeopment Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef FORMS_H
#define FORMS_H

#include <vdk/application.h>
#include <vdk/dlist.h>
#include <vdk/vdktypes.h>
#include <vdk/rawobj.h>
#include <vdk/vdkprops.h>
#include <vdk/vdkutils.h>
#include <vdk/vdkstring.h>
#include <vdk/vdkobj.h>
class VDKObject;

class VDKColor;
class VDKForm;
class VDKFont;
class VDKBox;
class VDKRawPixmap;

typedef VDKList<VDKForm> ChildList;
typedef VDKListiterator<VDKForm> ChildListIterator;

typedef VDKList<VDKObject> ObjectList;
typedef VDKListiterator<VDKObject> ObjectListIterator;


/*
=============
CLASS VDKFORM
=============
 */
class VDKForm : public VDKObject
{

 private:
  /*
    copy and assignement prohibited
  */
  VDKForm(VDKForm& ):VDKObject( NULL) {}
  VDKForm& operator=(VDKForm& ) { return *this; }
protected:
  void SignalsConnect();
  VDKApplication* app;
  ChildList childs,childsGarbage;
  GtkWidget *window;
  VDKBox* box;
  bool isModal;
  bool never_showed;
  VDKPoint _oldPos;
  VDKPoint _oldSize;
  // counts how many modal childs we have
  // should be always max 1
  int modalCount;

  static int ConfigureEvent(GtkWidget* ,
			     GdkEventConfigure* ev,
			     gpointer gp);
  static int DestroyEvent (GtkWidget*, gpointer gp);
  static int DeleteEvent(GtkWidget* , GdkEvent* , gpointer gp);
  static int ExposeEvent(GtkWidget* ,
			  GdkEventExpose* ev, gpointer gp);
  static void RealizeSignal(GtkWidget* , gpointer gp);
  static int MapEvent(GtkWidget* , GdkEvent* ev ,gpointer gp);
  static int UnmapEvent(GtkWidget* , GdkEvent* ev ,gpointer gp);
  static int FocusInEvent(GtkWidget* , GdkEvent* ev ,gpointer gp);
  static int FocusOutEvent(GtkWidget* , GdkEvent* ev ,gpointer gp);
  static void SizeAllocateSignal(GtkWidget      *widget,
			    GtkAllocation  *allocation,
			    gpointer gp);
public:
  /*
properties
*/

  VDKReadWriteValueProp<VDKForm,bool> Visible;
  VDKReadWriteValueProp<VDKForm,VDKString> Title;
  VDKReadWriteValueProp<VDKForm,VDKPoint> Position;
  VDKReadWriteValueProp<VDKForm,bool> Iconized;
  VDKReadWriteValueProp<VDKForm,VDKRawPixmap*> BackgroundPixmap;
  VDKReadWriteValueProp<VDKForm,VDKObject*> FocusWidget;

/*
  constructors
*/
VDKForm(VDKApplication* app,
	char* title = (char*) NULL,
	int mode = v_box,
	GtkWindowType display = GTK_WINDOW_TOPLEVEL);
VDKForm(VDKForm* owner,
	char* title = (char*) NULL,
	int mode = v_box,
	GtkWindowType display = GTK_WINDOW_TOPLEVEL);

VDKForm(VDKApplication* app,
	 GtkWidget* wid,
	 char* title = (char*) NULL);

#if HAVE_GNOME
VDKForm(VDKForm* owner,
	 GtkWidget* wid,
	 char* title = (char*) NULL);
#endif

 virtual ~VDKForm();
 bool                     Destroy();
 virtual int              isA() { return form_class; }

 VDKBox*                   Box() { return box; }

 virtual void              Show(GtkWindowPosition pos = GTK_WIN_POS_NONE);

 virtual void              Hide();

 virtual void              ShowModal(GtkWindowPosition pos = GTK_WIN_POS_NONE);

 bool                      IsModal() { return isModal; }

 virtual void Add(VDKObject* obj, int justify = l_justify,
		  int expand = TRUE, int fill = TRUE ,
		  int padding = 1);

 void              AddChild(VDKForm* child);

 VDKForm*                 Owner() { return owner; }

 void                       RemoveChild(VDKForm* child);

 virtual bool               CanClose(void);

 virtual void               Close(void);

 // this makes a VDKForm an abstract class
 virtual void               Setup(void) = 0;

 void                       SetTitle(VDKString title)
   { gtk_window_set_title(GTK_WINDOW(window),(char*) title); }

 VDKString                  GetTitle(void)
   {
     VDKString title = Title;
     return VDKString(title);
   }

 GtkWidget*                  Window() { return window; }

 VDKApplication*             Application() { return app; }

 void                        CloseChilds(void);

 void                        CollectGarbage();

 ObjectList& Objects(void) { return items; }

 ChildList&                  Childs(void) { return childs; }
 ChildList&                  ChildsGarbage(void)
   { return childsGarbage; }

 void                 Raise();
 void                 Lower();

 void                 SetVisible(bool flag)
   {
     if(flag) Show();
     else Hide();
   }
 bool                        GetVisible()
   { return GTK_WIDGET_VISIBLE(window); };
 /*
  */
 void SetIcon(VDKRawPixmap*);
 void SetIconName(char* name);
 void SetPosition(VDKPoint p);
 VDKPoint GetPosition();
 //
 void SetDefaultSize(VDKPoint p);
 void SetFormSize(VDKPoint p)
   { if(window) gdk_window_resize(window->window,p.X(),p.Y()); }
 bool GetIconized();
 void SetIconized(bool flag);
 void SetBackgroundPixmap(VDKRawPixmap* pix);
 void SetFocusWidget(VDKObject* focuswidget);
 /*
event response (place holders for subclasses)
*/
 static void  ButtonPressEvent(GtkWidget* ,
			       GdkEventButton* ev,
			       gpointer gp);

 virtual void OnExpose( VDKForm* sender, GdkRectangle area);
 virtual void OnChildClosing(VDKForm* child);
 virtual void OnShow(VDKForm* sender);
 virtual void OnRealize(VDKForm* sender);
 virtual void OnConfigure(VDKForm* sender);
 virtual void OnMove(VDKForm* sender);
 virtual void OnResize(VDKForm* sender, VDKPoint& size);
 virtual void OnIconize(VDKForm* sender);
 virtual void OnRestore(VDKForm* sender);
 virtual void OnFormActivate(VDKForm* sender, bool in_out);
/*
  Answers to a MS Windows-like message.
  Not very useful, just added  to facilitate
  porting my neural lib from MS Windows to VDK.
  Casual user should override in his own forms.
  */
 virtual int
     WindozeMessage(int /*msg*/,
		    unsigned int /*wParam*/,
		    long unsigned int /*lParam*/)
     {
	 return 0;
     }
};

#endif



