/*
 * ===========================
 * VDK Visual Develeopment Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
#ifndef EVHANDLE_H
#define EVHANDLE_H
#include <vdk/vdkobj.h>
#include <gdk/gdktypes.h>
/*
==============================================
         SIGNAL DISPATCHER ROUTINES
==============================================
*/
/*
_VDKSignalTable_:
Obj/Signal/Response method Table 
*/
template <class T>
class _VDKSignalTable_ {
  public:
  typedef bool (T::*PMF)(VDKObject* sender);
  VDKObject* T::*Pm; /* <class T> member offset */
  int signal; /* signal type (see enum VDKSignal in vdkobj.h) */
  PMF    Pmf;  /* <class T> member function offset */
  bool connected; /* connected flag, if false denies signal */
};

/*
Signal response function map declaration:
declare a static signal table for each form
*/

#define DECLARE_SIGNAL_MAP(_Parent_Class_)  \
private:\
static _VDKSignalTable_< _Parent_Class_ > _STEntries_[];\
typedef _VDKSignalTable_< _Parent_Class_ >::PMF _Member_;\
typedef _Parent_Class_  _Parent_MyClass_;\
protected:\
    virtual int  VDKSignalResponseTableSize();\
public:\
    virtual int  VDKSignalResponse(GtkWidget* , int signal, void*, void*,bool);\
    virtual int  SignalDetach(VDKObject* Pm, int signal);\
    virtual bool SignalAttach(int slot);

/*
define form signal response function that in turn call
object signal response function
algorithm:
1. scan table until find table end
   2. if  matches object and signal then slot is found
     3. if slot is connected
        4. bind object address with member function class offset
        5. call callback
           6. if callback return true consider signal "treated"
7. if signal is treated finish
   otherwise recursively call himself to ancestor class
*/

#define DEFINE_SIGNAL_MAP(_Parent_Class_,base)\
\
int _Parent_Class_::VDKSignalResponse(GtkWidget* mobj, \
int signal, void* obj, void* real_sender, bool treated) \
{\
int t=0;\
	  /*bool treated = false;*/\
VDKObject* vdkobj = reinterpret_cast<VDKObject*>(obj);\
VDKObject* real = reinterpret_cast<VDKObject*>(real_sender);\
for(;_STEntries_[t].Pm != NULL ;t++)\
{\
VDKObject* _Parent_Class_::*memberOffset = _STEntries_[t].Pm;\
if ( ((*this).*memberOffset == vdkobj) &&\
     (_STEntries_[t].signal == signal) )\
   {\
     if (_STEntries_[t].connected)\
       {\
	bool(_Parent_Class_::*response)(VDKObject* sender)= \
                              _STEntries_[t].Pmf;\
	if(((*this).*response)(real) == true)\
            treated = true;\
	}\
	   /*break;*/\
    }\
   }\
if(treated) return 1;\
else return base::VDKSignalResponse(mobj,signal,obj,real_sender, treated);\
}\
\
\
int _Parent_Class_::VDKSignalResponseTableSize()\
{\
int t = 0;\
for(;_STEntries_[t].Pm != NULL;t++)\
   ;\
return t;\
}\
\
\
\
int _Parent_Class_::SignalDetach(VDKObject* Pm, int signal)\
{\
int t=0;\
for(;_STEntries_[t].Pm != NULL ;t++)\
  {\
     VDKObject* _Parent_Class_::*memberOffset = _STEntries_[t].Pm;\
     if ( ((*this).*memberOffset == Pm) &&\
	 (_STEntries_[t].signal == signal) &&\
	 _STEntries_[t].connected != false)\
       {\
	 _STEntries_[t].connected = false;\
         return t;\
       }\
   }\
return -1;\
}\
\
\
\
bool _Parent_Class_::SignalAttach(int slot)\
{\
if( (slot >= 0) && (slot <= VDKSignalResponseTableSize()) )\
     {\
     _STEntries_[slot].connected = true;\
     return true;\
     }\
else\
     return false;\
}\
\
\
_VDKSignalTable_< _Parent_Class_ > _Parent_Class_::_STEntries_[] = {
/*
fill static signal table
*/
#define ON_SIGNAL(_obj_,_SIGNAL_,_member_)  \
  { reinterpret_cast<VDKObject* _Parent_MyClass_::*>(&_Parent_MyClass_::_obj_),\
     _SIGNAL_,&_Parent_MyClass_::_member_,true}
/*
*/
#define END_SIGNAL_MAP ,{ NULL, 0, NULL, false} };
/*
*/

/*
==============================================
         EVENT DISPATCHER ROUTINES
==============================================
*/
/*
EVENTTableEntry:
Event-ObjectCallback Table Entry
*/
template <class T>
class EVENTTableEntry {
 public:
  //  typedef void (T::*PMF)(VDKObject* sender, GdkEvent* event);
  typedef bool (T::*PMF)(VDKObject* sender, GdkEvent* event);
  VDKObject* T::*Pm; /* pointer to <class T> member offset */
  GdkEventType event; /* event type (see enum VDKevent in vdkobj.h) */
  PMF    Pmf;  /* pointer to <class T> member function */
  bool connected;
};
/*
Events response function map declaration:
declare a static events table for each form
*/
#define DECLARE_EVENT_MAP(_EVENTclass_)  \
private:\
static EVENTTableEntry< _EVENTclass_ > __OCBEventEntries[];\
typedef EVENTTableEntry< _EVENTclass_ >::PMF _EvMember_;\
typedef _EVENTclass_  _EVENTmyclass_;\
protected:\
    virtual int VDKEventResponseTableSize();\
public:\
    virtual int  VDKEventResponse(GtkWidget* , GdkEvent* , void*, void*,bool);\
    virtual int  EventDetach(VDKObject* , VDKEvent event);\
    virtual bool EventAttach(int slot);
/*
define form EVENT response function that in turn call
object EVENT response function
*/
#define DEFINE_EVENT_MAP(_EVENTclass_,base)  \
int _EVENTclass_::VDKEventResponse(GtkWidget* wid, GdkEvent* event, void* obj, void* real_sender, bool treated) \
\
{\
int t=0;\
	  /*bool treated = false;*/\
VDKObject* vdkobj = reinterpret_cast<VDKObject*>(obj);\
VDKObject* real = reinterpret_cast<VDKObject*>(real_sender);\
for(;__OCBEventEntries[t].Pm != NULL ;t++)\
  {\
     VDKObject* _EVENTclass_::*memberOffset = __OCBEventEntries[t].Pm;\
     if( ((*this).*memberOffset == vdkobj) &&\
	 (__OCBEventEntries[t].event == ((GdkEventAny*)event)->type) )\
       {\
        if (__OCBEventEntries[t].connected)\
	   {\
	    bool (_EVENTclass_::*response)\
                 (VDKObject* , GdkEvent* ) = \
	         __OCBEventEntries[t].Pmf;\
	    if(((*this).*response)(real,event))\
	        treated = true;\
	   }\
	      /*break;*/\
       }\
   }\
if(treated) return 1;\
else return base::VDKEventResponse(wid,event,obj,real_sender, treated); \
}\
\
\
\
int _EVENTclass_::VDKEventResponseTableSize()\
{\
int t = 0;\
for(;__OCBEventEntries[t].Pm != NULL;t++)\
   ;\
return t;\
}\
\
\
\
int _EVENTclass_::EventDetach(VDKObject* Pm, VDKEvent event)\
{\
int t=0;\
for(;__OCBEventEntries[t].Pm != NULL ;t++)\
  {\
VDKObject* _EVENTclass_::*memberOffset = __OCBEventEntries[t].Pm;\
     if ( ((*this).*memberOffset == Pm) &&\
	 (__OCBEventEntries[t].event == (GdkEventType) event)&&\
	 __OCBEventEntries[t].connected != false)\
       {\
	 __OCBEventEntries[t].connected = false;\
         return t;\
       }\
   }\
return -1;\
}\
\
\
\
bool _EVENTclass_::EventAttach(int slot)\
{\
if( (slot >= 0) && (slot <= VDKEventResponseTableSize()) )\
     {\
     __OCBEventEntries[slot].connected = true;\
     return true;\
     }\
else\
     return false;\
}\
\
\
EVENTTableEntry< _EVENTclass_ > _EVENTclass_::__OCBEventEntries[] = {
/*
fill static EVENT table
*/
#define ON_EVENT(_obj_,_EVENT_,_member_)  \
  {reinterpret_cast<VDKObject* _EVENTmyclass_::*>(&_EVENTmyclass_::_obj_), (GdkEventType) _EVENT_,&(_EVENTmyclass_::_member_),true}
/*
*/
#define END_EVENT_MAP ,{ NULL , (GdkEventType) 0, NULL,false} };

#endif







