/*
 * ===========================
 * VDK Visual Develeopment Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef  ENTRY_H
#define  ENTRY_H

#include <vdk/vdkobj.h>
#include <vdk/vdkprops.h>
#include <string>

/*
 */
class VDKEntry: public VDKObject
{
  static int FocusOutEvent(GtkWidget *w,
			    GdkEventFocus *event,
			    gpointer wid);
  static int FocusInEvent(GtkWidget *w,
			    GdkEventFocus *event,
			    gpointer wid);
 protected:
  int changeConnect;
  VDKObjectSignal s_activated, s_changed;
public:
  // properties
  VDKReadWriteValueProp<VDKEntry,char*> Text;
  VDKReadWriteValueProp<VDKEntry,bool>  Editable;
  VDKReadWriteValueProp<VDKEntry,bool>  Hidden;
  //
  VDKEntry(VDKForm* owner,int maxLen = 0, char* def = (char*) NULL);
  virtual ~VDKEntry();
  void SetText(char* text);
  void SetText(string s);
  char* GetText(); 
  void SetEditable(bool flag)
    { gtk_entry_set_editable(GTK_ENTRY(widget),flag); }
  bool GetEditable() { return Editable; }
  void SetBackground(VDKRgb rgb, 
		     GtkStateType state);
  void SetHidden(bool flag)
    { gtk_entry_set_visibility(GTK_ENTRY(widget), ! flag) ; }
  bool GetHidden()
    { return ! Hidden; }
};
#endif
