#include "libvga.h"
#include <stdio.h>

int __svgalib_vga_inmisc(void)
{
   return inb(MIS_R);
}

void __svgalib_vga_outmisc(int i)
{
   outb(MIS_W,i);
}

int __svgalib_vga_incrtc(int i)
{
   outb(__svgalib_CRT_I,i);
   return inb(__svgalib_CRT_D);
}

void __svgalib_vga_outcrtc(int i, int d)
{
   outw(__svgalib_CRT_I,i|(d<<8));
}

int __svgalib_vga_inseq(int index)
{
    outb(SEQ_I, index);
    return inb(SEQ_D);
}

void __svgalib_vga_outseq(int index, int val)
{
    int v;
    v = ((int) val << 8) + index;
    outw(SEQ_I, v);
}

