% File that can be loaded by the 'simple' executable.  
_debug_info = 1;
define read_input ()
{
   variable str;

   () = fputs ("Enter filename or 'quit'> ", stdout);
   () = fflush (stdout);
   
   if (-1 == fgets (&str, stdin))
     str = NULL;

   return str;
}

define main ()
{
   variable file;
   variable st;
     
   while (file = read_input (), file != NULL)
     {
	% Strip '\n' and whitespace off the end of the file
	file = strtrim (file);
	
	if (file == "quit")
	  break;
	
	st = stat_file (file);
	if (st == NULL)
	  {
	     vmessage ("Unable to stat %s: %s", file, errno_string (errno));
	     continue;
	  }
	
	% stat succeeds return information about the file.
	vmessage ("stat system call for %s yields:", file);
	vmessage ("\t%s:\t%d", "st_dev", st.st_dev);
	vmessage ("\t%s:\t%d", "st_ino", st.st_ino);
	vmessage ("\t%s:\t%d", "st_mode", st.st_mode);
	vmessage ("\t%s:\t%d", "st_nlink", st.st_nlink);
	vmessage ("\t%s:\t%d", "st_uid", st.st_uid);
	vmessage ("\t%s:\t%d", "st_gid", st.st_gid);
	vmessage ("\t%s:\t%d", "st_rdev", st.st_rdev);
	vmessage ("\t%s:\t%d", "st_size", st.st_size);
	vmessage ("\t%s:\t%d\t(%s)", "st_atime", 
		  st.st_atime, unix_ctime (st.st_atime));
	vmessage ("\t%s:\t%d\t(%s)", "st_mtime", 
		  st.st_mtime, unix_ctime (st.st_mtime));
	vmessage ("\t%s:\t%d\t(%s)", "st_ctime", 
		  st.st_ctime, unix_ctime (st.st_ctime));
	
	message ("\n");
     }
}

main ();
   
