//=======================================================================
//@V@:Note: This file generated by vgen V1.05 (11:37:58 08 Mar 1999).
//	vdbcmdw.cpp:	Source for vdbCmdWindow class
// This is the MS-WINDOWS interface to gdb
//=======================================================================

#include <v/vnotice.h>	// for vNoticeDialog
#include <v/vkeys.h>	// to map keys
#include <v/vicon.h>

#include "videapp.h"	// our header
#include "vdbcmdw.h"	// our header
#include "videcmdw.h"	// our header

    // The following definitions mirror those of the edit/console
    // cmdwin (videCmdWindow), but are all no-ops except the edit
    // menu.

//@V@:BeginIDs
    enum {
	// remaining debug commands defined in videapp.h
	m_NA = 4100,
        m_x1, m_x2, m_x3, m_x4, m_x5, m_x6, m_x7, m_x8,
        m_x9, m_x10, m_x11, m_x12, m_x13, m_x14, m_x15,
	m_x16, m_x17,

	cmdAuxTimer,			// when timer ticks

	lblLineCol,			// Status Bar
	lblIns,
	lblSBlank,
	lblEMsg,
        lblStatTitle,
	blkLast				// Last item
      };
//@V@:EndIDs

//@V@:BeginPulldownMenu FileMenu
    static vMenu FileMenu[] =
      {
	{"Close Debugger", m_CloseDebug, isSens, notChk, noKeyLbl, noKey, noSub},
	{NULL}
      };

//@V@:BeginPulldownMenu EditMenu
    static vMenu EditMenu[] =
      {
	{"Cut  ", M_Cut, notSens, notChk, "^X", noKey, noSub},
	{"Copy ", M_Copy, notSens, notChk, "^C", noKey, noSub},
	{"Paste", M_Paste, notSens, notChk, "^V", noKey, noSub},
	{"-", M_Line, notSens, notChk, noKeyLbl, noKey, noSub},
	{"Find...", edFind, isSens,notChk,noKeyLbl,noKey,noSub},
	{"Find Next", edFindNext, isSens,notChk,noKeyLbl,noKey,noSub},
	{"-", M_Line, notSens, notChk, noKeyLbl, noKey, noSub},
        {"Editor Help", edHelp, isSens, notChk, noKeyLbl, noKey, noSub},

	{NULL}
      };
//@V@:EndPulldownMenu

//@V@:BeginPulldownMenu OptMenu
    static vMenu OptMenu[] =
      {
	{"N/A", m_NA, notSens, notChk, noKeyLbl, noKey, noSub},
	{NULL}
      };
//@V@:EndPulldownMenu

//@V@:BeginPulldownMenu MakeMenu
    static vMenu MakeMenu[] =
      {
	{"N/A", m_NA, notSens, notChk, noKeyLbl, noKey, noSub},
        {NULL}
      };
//@V@:EndPulldownMenu

//@V@:BeginPulldownMenu ToolsMenu
    static vMenu ToolsMenu[] =
      {
	{"N/A", m_NA, notSens, notChk, noKeyLbl, noKey, noSub},
        {NULL}
      };
//@V@:EndPulldownMenu

//@V@:BeginPulldownMenu ProjectMenu
    static vMenu ProjectMenu[] =
      {
	{"N/A", m_NA, notSens, notChk, noKeyLbl, noKey, noSub},
        {NULL}
      };
//@V@:EndPulldownMenu

//@V@:BeginPulldownMenu DebugMenu
    static vMenu DebugMenu[] =
      {
	{"Start Debugger", m_x1, notSens, notChk, noKeyLbl, noKey, noSub},
        {"-", M_Line, notSens, notChk, noKeyLbl, noKey, noSub},
	{"Set Breakpoint", m_SetBP, notSens, notChk, noKeyLbl, noKey, noSub},
	{"Delete Breakpoint", m_DeleteBP, notSens, notChk, noKeyLbl, noKey, noSub},
        {"Show Breakpoints", m_ShowBreakpoints, isSens, notChk, noKeyLbl, noKey, noSub},
        {"Delete Breakpoints", m_DeleteBreakpoints, isSens, notChk, noKeyLbl, noKey, noSub},
        {"-", M_Line, notSens, notChk, noKeyLbl, noKey, noSub},
	{"Run program", m_DBRun, isSens, notChk, noKeyLbl, noKey, noSub},
	{"Step over statement", m_StepOver, isSens, notChk, noKeyLbl, noKey, noSub},
	{"Step into statement", m_StepInto, isSens, notChk, noKeyLbl, noKey, noSub},
	{"Run to line", m_x3, notSens, notChk, noKeyLbl, noKey, noSub},
	{"Continue program", m_Continue, isSens, notChk, noKeyLbl, noKey, noSub},
	{"Kill program", m_Kill, isSens, notChk, noKeyLbl, noKey, noSub},
	{"Show call stack", m_CallStack, isSens, notChk, noKeyLbl, noKey, noSub},
	{"Inspect variable", m_x5, notSens, notChk, noKeyLbl, noKey, noSub},
	{"Debugger help", m_DBHelp, isSens, notChk, noKeyLbl, noKey, noSub},
//	{"xx", m_xx, notSens, notChk, noKeyLbl, noKey, noSub},
	
        {NULL}
      };
//@V@:EndPulldownMenu

    static vMenu HelpMenu[] =
      {
        {"Editor Help", edHelp, isSens, notChk, noKeyLbl, noKey, noSub},
        {NULL}
      };

//@V@:BeginMenu StandardMenu
    static vMenu StandardMenu[] =
      {
	{"&File", M_File, isSens, notUsed, notUsed, noKey, &FileMenu[0]},
	{"&Edit", M_Edit, isSens, notUsed, notUsed, noKey, &EditMenu[0]},
        {"&Project",m_Project,isSens,notUsed,notUsed,noKey,&ProjectMenu[0]},
	{"&Build", m_Build, isSens, notUsed, notUsed, noKey, &MakeMenu[0]},
        {"&Debug", m_DebugMenu, isSens, notUsed, notUsed, noKey, &DebugMenu[0]},
        {"&Tools", m_Tools, isSens, notUsed, notUsed, noKey, &ToolsMenu[0]},
        {"&Options", m_Options, isSens, notUsed, notUsed, noKey, &OptMenu[0]},
        {"&Help", m_Help, isSens, notUsed, notUsed, noKey, &HelpMenu[0]},
	{NULL}
      };
//@V@:EndMenu

//vbm1
#define open_width 16
#define open_height 16
static unsigned char open_bits[] = {
 0x00,0x00,0x00,0x0e,0x00,0x51,0x00,0x60,0x00,0x70,0x1c,0x00,0xe2,0x07,0x02,
 0x04,0x02,0x04,0xc2,0x7f,0xa2,0x2a,0x52,0x15,0xaa,0x0a,0x56,0x05,0xfc,0x03,
 0x00,0x00};
    static vIcon openI(&open_bits[0],open_height,open_width);

//vbm1
#define undo_width 16
#define undo_height 16
static unsigned char undo_bits[] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0f,0xc4,0x10,0x2c,
 0x20,0x1c,0x20,0x3c,0x20,0x7c,0x10,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00};
    static vIcon undoI(&undo_bits[0],undo_height,undo_width);

//vbm1
#define openprj_depth 1
#define openprj_width 16
#define openprj_height 16
static unsigned char openprj_bits[] = {
 0x00,0x1e,0x00,0xa3,0xbc,0xc0,0x22,0xe0,0x21,0x00,0xe1,0x7f,0x01,0x40,0xdd,
 0x5d,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xdd,0x5d,0x01,0x40,
 0xff,0x7f};
    static vIcon openprjI(&openprj_bits[0],openprj_height,openprj_width);

//vbm1
#define find_width 16
#define find_height 16
static unsigned char find_bits[] = {
 0x00,0x00,0xf0,0x01,0x08,0x02,0x44,0x04,0xa2,0x08,0x12,0x09,0xf2,0x09,0x12,
 0x09,0x14,0x05,0x08,0x0e,0xf0,0x1d,0x00,0x38,0x00,0x70,0x00,0x60,0x00,0x00,
 0x00,0x00};
    static vIcon findI(&find_bits[0],find_height,find_width);

//vbm1
#define findagn_width 16
#define findagn_height 16
static unsigned char findagn_bits[] = {
 0x00,0x00,0xf0,0x01,0x08,0x02,0x44,0x04,0xa2,0x08,0x12,0x09,0xf2,0x09,0x12,
 0x09,0x14,0x05,0x08,0x0e,0xf0,0x1d,0x66,0x38,0xcc,0x70,0x98,0x61,0xcc,0x00,
 0x66,0x00};
    static vIcon findagnI(&findagn_bits[0],findagn_height,findagn_width);

//vbm1
#define replace_depth 1
#define replace_width 16
#define replace_height 16
static unsigned char replace_bits[] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x3c,0x0e,0x44,0x4e,0x44,0xca,0x44,0xdb,
 0x3d,0xdf,0x45,0xd1,0x44,0x51,0x44,0x11,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00};
    static vIcon replaceI(&replace_bits[0],replace_height,replace_width);

//vbm1
#define make_depth 1
#define make_width 16
#define make_height 16
static unsigned char make_bits[] = {
 0xc0,0x03,0x7f,0x12,0x01,0x32,0x01,0x22,0x01,0x22,0x01,0x32,0x01,0x12,0xff,
 0x13,0x00,0x10,0x00,0x7c,0x00,0x38,0x00,0x10,0x9d,0xeb,0x95,0xaa,0x95,0xaa,
 0x9d,0xeb};
    static vIcon makeI(&make_bits[0],make_height,make_width);


//vbm1
#define vrun_depth 1
#define vrun_width 16
#define vrun_height 16
static unsigned char vrun_bits[] = {
 0x00,0x00,0x80,0x1f,0xc0,0x0f,0xe0,0x07,0xf0,0x03,0xf8,0x1f,0xfc,0x1f,0xc0,
 0x0f,0xe0,0x07,0xf0,0x03,0xf8,0x0f,0x80,0x07,0xc0,0x03,0xe0,0x01,0x70,0x00,
 0x00,0x00};
    static vIcon vrunI(&vrun_bits[0],vrun_height,vrun_width);

//vbm1
#define debug_depth 1
#define debug_width 16
#define debug_height 16
static unsigned char debug_bits[] = {
 0x00,0x00,0xc0,0x01,0x80,0x00,0xc0,0x01,0x20,0x02,0x53,0x65,0x14,0x14,0x88,
 0x08,0x28,0x0a,0xaf,0x7a,0x28,0x0a,0x88,0x08,0x14,0x14,0x92,0x24,0x21,0x42,
 0xc0,0x01};
    static vIcon debugI(&debug_bits[0],debug_height,debug_width);

//vbm1
#define stepover_depth 1
#define stepover_width 16
#define stepover_height 16
static unsigned char stepover_bits[] = {
 0xc0,0x01,0x38,0x4e,0x04,0x70,0x02,0x70,0x01,0x78,0x00,0x00,0x30,0x0c,0x08,
 0x10,0x08,0x10,0x08,0x30,0x0c,0x30,0x0c,0x10,0x08,0x10,0x08,0x10,0x08,0x10,
 0x30,0x0c};
    static vIcon stepoverI(&stepover_bits[0],stepover_height,stepover_width);

//vbm1
#define stepinto_depth 1
#define stepinto_width 16
#define stepinto_height 16
static unsigned char stepinto_bits[] = {
 0xe0,0x00,0x98,0x01,0x84,0x01,0xe2,0x07,0xc1,0x03,0x80,0x01,0x30,0x0c,0x08,
 0x10,0x08,0x10,0x08,0x30,0x0c,0x30,0x0c,0x10,0x08,0x10,0x08,0x10,0x08,0x10,
 0x30,0x0c};
    static vIcon stepintoI(&stepinto_bits[0],stepinto_height,stepinto_width);

//vbm1
#define stopdbg_depth 1
#define stopdbg_width 16
#define stopdbg_height 16
static unsigned char stopdbg_bits[] = {
 0x03,0xc0,0xc7,0xe1,0x8e,0x70,0xdc,0x39,0x38,0x1e,0x73,0x6f,0xf4,0x17,0xe8,
 0x0b,0xc8,0x0b,0xef,0x7f,0x70,0x0e,0xb8,0x1c,0x1c,0x3c,0x9e,0x74,0x27,0xe2,
 0xc3,0xc1};
    static vIcon stopdbgI(&stopdbg_bits[0],stopdbg_height,stopdbg_width);

//vbm1
#define inspect_depth 1
#define inspect_width 16
#define inspect_height 16
static unsigned char inspect_bits[] = {
 0x00,0x00,0x00,0x30,0xf0,0x49,0x08,0x42,0x04,0x24,0x54,0x15,0xd4,0x16,0x54,
 0x05,0x04,0x14,0x08,0x02,0xf0,0x0d,0x00,0x1c,0x00,0x38,0x00,0x30,0x00,0x00,
 0x00,0x00};
    static vIcon inspectI(&inspect_bits[0],inspect_height,inspect_width);

//vbm1
#define break_depth 1
#define break_width 16
#define break_height 16
static unsigned char break_bits[] = {
 0x00,0x00,0xa0,0x02,0x58,0x05,0x54,0x05,0x54,0x05,0x54,0x05,0x54,0x05,0x04,
 0x34,0x04,0x2c,0x04,0x20,0x08,0x10,0x18,0x08,0x10,0x04,0x10,0x04,0x10,0x00,
 0x00,0x00};
    static vIcon breakI(&break_bits[0],break_height,break_width);

//vbm1
#define stopbreak_depth 1
#define stopbreak_width 16
#define stopbreak_height 16
static unsigned char stopbreak_bits[] = {
 0x00,0x00,0xa6,0x02,0x5e,0x65,0x5c,0x75,0x5c,0x3d,0x7c,0x1d,0x74,0x0f,0xe4,
 0x37,0xc4,0x2f,0xc4,0x23,0xf8,0x17,0x38,0x0e,0x1c,0x1c,0x1e,0x38,0x16,0x30,
 0x00,0x00};
    static vIcon stopbreakI(&stopbreak_bits[0],stopbreak_height,stopbreak_width);

//vbm1
#define runto_depth 1
#define runto_width 16
#define runto_height 16
static unsigned char runto_bits[] = {
 0x00,0x80,0xfe,0x81,0x02,0x83,0x02,0x85,0x6a,0x87,0x02,0x84,0x52,0x85,0x82,
 0xa4,0x52,0xb4,0x02,0xfd,0x5a,0x34,0x82,0x24,0x62,0x07,0x02,0x04,0xfe,0x07,
 0x00,0x00};
    static vIcon runtoI(&runto_bits[0],runto_height,runto_width);

//@V@:BeginCmdPane ToolBar
    static CommandObject ToolBar[] =
      {
	{C_IconButton,m_x6,0,"Open",&openI,CA_None,notSens,NoFrame,0,0,0,"Open File"},
	{C_IconButton,m_x7,0,"OpenProject",&openprjI,CA_None,notSens,NoFrame,0,0,0,"Open Project"},
	{C_Blank,99,0," ",NoList,CA_None,isSens,NoFrame,0,0},
	{C_IconButton,m_x8,0,"Undo",&undoI,CA_None,notSens,NoFrame,0,0,0,"Undo"},
	{C_IconButton,edFind,0,"Find",&findI,CA_None,isSens,NoFrame,0,0,0,"Find"},
	{C_IconButton,edFindNext,0,"Find Next",&findagnI,CA_None,isSens,NoFrame,0,0,0,"Find Next"},
	{C_IconButton,m_x9,0,"Replace",&replaceI,CA_None,notSens,NoFrame,0,0,0,"Replace"},
        {C_Blank,99,0," ",NoList,CA_None,isSens,NoFrame,0,0},
        {C_IconButton,m_x10,0,"MAKE",&makeI,CA_None,notSens,NoFrame,0,0,0,"make all C++ / Compile Java"},
	{C_IconButton,m_DBRun,0,"Run",&vrunI,CA_None,isSens,NoFrame,0,0,0,"Run current program"},
        {C_Blank,99,0," ",NoList,CA_None,isSens,NoFrame,0,0},
	{C_IconButton,m_x15,0,"Debug",&debugI,CA_None,notSens,NoFrame,0,0,0,"Start debugger"},
	{C_IconButton,m_Kill,0,"KillDebug",&stopdbgI,CA_None,isSens,NoFrame,0,0,0,"Kill program being debugged"},
	{C_IconButton,m_x16,0,"SetBreak",&breakI,CA_None,notSens,NoFrame,0,0,0,"Set Breakpoint"},
	{C_IconButton,m_x17,0,"DelBreak",&stopbreakI,CA_None,notSens,NoFrame,0,0,0,"Delete Breakpoint"},
	{C_IconButton,m_StepOver,0,"StepOver",&stepoverI,CA_None,isSens,NoFrame,0,0,0,"Step over statement"},
	{C_IconButton,m_StepInto,0,"StepInto",&stepintoI,CA_None,isSens,NoFrame,0,0,0,"Step into statement"},
	{C_IconButton,m_x13,0,"Run To",&runtoI,CA_None,notSens,NoFrame,0,0,0,"Step into statement"},
	{C_IconButton,m_x14,0,"Inspect",&inspectI,CA_None,notSens,NoFrame,0,0,0,"Inspect variable"},

  	{C_EndOfList,0,0,0,0,CA_None,0,0,0}
      };
//@V@:EndCmdPane

//@V@:BeginStatPane StatBar
    static vStatus StatBar[] =
      {
        {" V IDE ", lblStatTitle, CA_NoBorder, isSens, 0},
	{"1/1         ", lblLineCol, CA_None, isSens, 0},
	{"     Insert    ", lblIns, CA_None, isSens, 0},
	// handle messages this big
	{"                                                        ",
		 lblEMsg, /* CA_NoBorder */ CA_None, isSens, 0},
	{0,0,0,0,0}
      };
//@V@:EndStatPane

    static int filterIndex = 0;
    // The MS-Windows filter seems to hold only 5 entries for the
    // filter, but it doesn't die with more, it only shows the
    // first 5, so the last 3 filters won't show on MS-Windows.
    // I don't know if that is V or MS-Windows (BEW: 3/5/99)
    static char* filter[] =
      {
        "*.c;*.cpp;*.cxx;*.C;*.h;*.H;*.java;*.htm;*.html;*.txt",
        "*.c;*.cpp;*.cxx;*.h;*.hxx",
	"*.htm;*.html;*.java;*.js",
        "*.txt;*.htm;*.html",
        "*",
        "*.c;*.cpp;*.C",
	"*.h",
	"*.java",
        0
      };

// ###########################################################################

//====================>>> myAuxTimer::TimerTick <<<====================
  void dbAuxTimer::TimerTick()
  {
    cmdw->WindowCommand(cmdAuxTimer, cmdAuxTimer, C_Button); // update clock
  }

//====================>>> vdbCmdWindow::vdbCmdWindow <<<====================
  vdbCmdWindow::vdbCmdWindow(VCONST char* name, int width, int height) :
    vCmdWindow(name, width, height)
  {
    UserDebug1(Constructor,"vdbCmdWindow::vdbCmdWindow(%s) Constructor\n",name)

    // The Menu Bar
    vdbMenu = new vMenuPane(StandardMenu);
    AddPane(vdbMenu);

    // The Command Pane
    vdbCmdPane = new vCommandPane(ToolBar);
    AddPane(vdbCmdPane);

    // The Canvas
//    vdbCanvas = new vdbTextEditor(this);
    vdbCanvas = new vTextEditor(this);
    AddPane(vdbCanvas);

    // The Status Bar
    vdbStatus = new vStatusPane(StatBar);
    AddPane(vdbStatus);

    // use default cmd interp...
//    vdbCmdI = new vdbCI(vdbCanvas, this);
//    vdbCanvas->ChangeCmdInterp((vTextEdCmdInterp*)vdbCmdI);
//      vdbCI = 0;
    
    // timer to get db output

    auxTimer = new dbAuxTimer(this);	// create timer
    auxTimer->TimerSet(200);		// update 5 times a second

    // Show Window

    ShowWindow();

    vdbFont = ((videApp*)theApp)->DefaultFont;
    vdbCanvas->SetFont(vdbFont);
    vdbCanvas->SetTextRowsCols(height,width);

    vdbCanvas->ShowVScroll(1);	// Show Vert Scroll

    *dbCmd = 0;
    dbCmdPtr = dbCmd;		// build command in dbCmd
    dbProcessHandle = 0;
    dbProcessId = 0;
  }

//====================>>> vdbCmdWindow::~vdbCmdWindow <<<====================
  vdbCmdWindow::~vdbCmdWindow()
  {
    UserDebug(Destructor,"vdbCmdWindow::~vdbCmdWindow() destructor\n")

    // Now put a delete for each new in the constructor.

    auxTimer->TimerStop();	// kill the timer first
    delete auxTimer;

    delete vdbMenu;
    delete vdbCanvas;
    delete vdbCmdPane;
    delete vdbStatus;
  //  delete vdbCmdI;		// done by the canvas...

  }

//====================>>> vedCmdWindow::ChangeLoc <<<====================
  void vdbCmdWindow::ChangeLoc(long line, int col)
  {
#ifdef USETHISCODE
    char buff[20];
    char colbuff[10];
    char outbuff[20];
    int ll;

    LongToStr(line,buff);

    IntToStr(col,colbuff);

    // center the line/col string

    int totalLen = strlen(buff) + strlen(colbuff) + 1;

    int add = (9 - totalLen) / 2;

    for (ll = 0 ; ll < add ; ++ll)
	outbuff[ll] = ' ';
    outbuff[ll] = 0;

    strcat(outbuff,buff); strcat(outbuff,"/");
    strcat(outbuff,colbuff);

    // pad with trailing blanks so X doesn't shift things

    for (ll = strlen(outbuff) ; ll < 9 ; ++ll)
	outbuff[ll] = ' ';
    outbuff[ll] = 0;
    SetString(lblLineCol,outbuff);
#endif

  }

//====================>>> vedCmdWindow::StatusMessage <<<====================
  void vdbCmdWindow::StatusMessage(char *msg)
  {
    char lineout[42];
    int ix;

    // copy up to 40 chars
    for (ix = 0 ; ix < 40 && msg[ix] ; ++ix)
	lineout[ix] = msg[ix];

    // pad with trailing blanks
    for ( ; ix < 40 ; ++ix)
	lineout[ix] = ' ';

    lineout[ix] = 0;

    SetString(lblEMsg,lineout);
  }

//====================>>> vdbCmdWindow::KeyIn <<<====================
  void vdbCmdWindow::KeyIn(vKey keysym, unsigned int shift)
  {
    
    if (keysym ==  vk_Return)		// send a command...
      {
	*dbCmdPtr++ = '\n';
	*dbCmdPtr = 0;
	dbCmdPtr = dbCmd;
	vdbCanvas->bufferBottom();
	vdbCanvas->charInsert('\n');
	dbSendCmd(dbCmd, 0);
      }
    else if (keysym == vk_BackSpace || keysym == vk_Delete)
      {
	if (dbCmdPtr != dbCmd)
	  {
	    --dbCmdPtr;
	    vdbCanvas->bufferBottom();
	    vdbCanvas->charDelete(-1);
	  }
	
      }
 // else if (vdbCanvas->EditKeyIn(keysym, shift) < 0)
    else if (keysym >= ' ' && keysym <= 127)
      {
        *dbCmdPtr++ = (char) keysym;	// add to command buffer
	vdbCanvas->bufferBottom();
        vdbCanvas->charInsert((char) keysym);
      }
    else
        vdbCanvas->EditKeyIn(keysym, shift);


  }

//====================>>> videCmdWindow::GotoDebugLine <<<====================
  videCmdWindow* vdbCmdWindow::GotoDebugLine(char* info)
  {
    // This is passed the gdb breakpoint line info.
    // Open that file, go to the line
    // The info line is in the format:
    //     fullfilename:##:misc other stuff
    // The fullfile name CAN include a drive, and thus a :,
    // so must account for that...

    // First, get pointer to the error message window
    // so we can use the helper methods in videCmdWindow class

    videCmdWindow* cmdw = ((videApp*)theApp)->GetMsgWindow();

    // char errLine[100];

    // line number will be somewhere on line in format filename.c:##
    // error line in format "  ! filename.cpp:###:msg"

    char fullFileName[maxFileNameSize+2];
    char filePath[maxFileNameSize+2];
    char fileBase[maxFileNameSize+2];

    char cLineNum[20];

#ifdef V_VersionWindows
    // Windows version would prefer to have all \ for file names
    for (char* cp = info ; *cp ; ++cp)
      {
	if (*cp == '/')
	    *cp = '\\';
      }
#endif

    // pick up the full file name
    fullFileName[0] = info[0];
    fullFileName[1] = info[1];	// These skip possible : in name
    int ifn;		// index to file name
    for (ifn = 2 ;
	 ifn < maxFileNameSize && info[ifn] != ':' && info[ifn] ;
	++ifn)
        fullFileName[ifn] = info[ifn];
    fullFileName[ifn] = 0;

    // fullFilename now has full file path

    // ifn points to the : before the line number

    char* np = &cLineNum[0];		// get the line number
    for ( ++ifn ; info[ifn] >= '0' && info[ifn] <= '9' ; ++ifn)
        *np++ = info[ifn];
    *np = 0;

    long lineNum = StrToLong(cLineNum);

    // get parts
    ((videApp*)theApp)->splitFileName(fullFileName,filePath,fileBase,0);

    
    // start by seeing if file is in the supplied full name
 
    videCmdWindow* openw = cmdw->FindCmdWin(fullFileName);

    if (openw == 0)		// nope, then try the base name only
      {
        openw = cmdw->FindCmdWin(fileBase);
      }

    if (openw != 0)		// EASY, already open
      {
        (openw->GetTextEd())->EditCommand(edLineGoto, lineNum);
        (openw->GetTextEd())->EditCommand(edCenterScreen, 0);
        (openw->GetTextEd())->highLightCurLine();
        return openw;
      }

    // Not already open, so need to open a new window.

    openw = (videCmdWindow*)
                    theApp->NewAppWin(0,"V Text Editor", 90, 18);
    if (!openw)
        return 0;	       // should never happen...

    if (!openw->OpenFile(fullFileName,0,0))
      {
      	// hmmm - the file doesn't exist on Makefile path
        // try something else
        vFileSelect fsel(this);     // make an instance
        if (!fsel.FileSelect("Open file",fileBase,maxFileNameSize,
             filter,filterIndex))
          {
            openw->CloseWin();
            return 0;
          }
        if (!openw->OpenFile(fileBase,0,0))
          {
              openw->CloseWin();
              return 0;
          }
        (openw->GetTextEd())->EditCommand(edLineGoto, lineNum);
        (openw->GetTextEd())->EditCommand(edCenterScreen, 0);
        (openw->GetTextEd())->highLightCurLine();
      }
    else
      {
        (openw->GetTextEd())->EditCommand(edLineGoto, lineNum);
        (openw->GetTextEd())->EditCommand(edCenterScreen, 0);
        (openw->GetTextEd())->highLightCurLine();
      }
    RaiseWindow();		// raise myself
    return openw;
  }

//====================>>> vdbCmdWindow::breakCmd <<<====================
  void vdbCmdWindow::breakCmd(videCmdWindow* win, char* bcmd)
  {
    long curlin = (win->GetTextEd())->GetCurLine();
    char *fileName = win->GetFileName();
    char fileBase[maxFileNameSize+2];
    char cmd[maxFileNameSize+2];
    char lNum[20];

    ((videApp*)theApp)->splitFileName(fileName,0,fileBase,0);
    strcpy(cmd,bcmd);
    strcat(cmd,fileBase);
    strcat(cmd,":");
    LongToStr(curlin, lNum);
    strcat(cmd,lNum);
    strcat(cmd,"\n");
    dbSendCmd(cmd);
  }

//====================>>> vdbCmdWindow::debugCmd <<<====================
  void vdbCmdWindow::debugCmd(videCmdWindow* win, ItemVal id)
  {
    switch (id)
      {
	case m_StepOver:
	  {
	    dbSendCmd("next\n");
	    break;
	  }

	case m_StepInto:
	  {
	    dbSendCmd("step\n");
	    break;
	  }

	case m_CallStack:
	  {
	    dbSendCmd("bt\n");
	    break;
	  }

	case m_SetBP:
	  {
	    breakCmd(win, "break ");
	    break;
	  }

	case m_DeleteBP:
	  {
	    breakCmd(win,"clear ");
	    break;
	  }

	case m_Inspect:
	  {
	    char varName[82];
	    int res = (win->GetTextEd())->getSelection(varName, 80);
	    if (!res || strlen(varName) < 1)
	      {
		vNoticeDialog note(this);
		note.Notice("Highlight variable to inspect first!");
		break;
	      }
	    char cmd[90];
	    strcpy(cmd,"print ");
	    strcat(cmd,varName);
	    strcat(cmd,"\n");
	    dbSendCmd(cmd);
	    break;
	  }

	case m_ShowBreakpoints:
	  {
	    dbSendCmd("info breakpoints\n");
	    break;
	  }

	case m_DeleteBreakpoints:
	  {
	    dbSendCmd("delete breakpoints\n");
	    break;
	  }

	case m_Continue:
	  {
	    dbSendCmd("continue\n");
	    break;
	  }

	case m_Kill:
	  {
	    dbSendCmd("kill\n");
	    break;
	  }

	case m_DBRun:
	  {
	    dbSendCmd("run\n");
	    break;
	  }

	case m_SetArgs:
	  {
	    break;
	  }

	case m_RunTo:
	  {
	    breakCmd(win,"until ");
	    break;
	  }

	case m_DBHelp:
	  {
	    dbSendCmd("help\n");
	    break;
	  }

	default:
	  {
	    break;
	  }

      }

  }

//====================>>> vdbCmdWindow::WindowCommand <<<====================
  void vdbCmdWindow::WindowCommand(ItemVal id, ItemVal val, CmdType cType)
  {
    // Default: route menu and toolbar commands here


    UserDebug1(CmdEvents,"vdbCmdWindow:WindowCommand(%d)\n",id)

    // First, check for all debug commands so we can route them
    // through one place.
    if (id >= (ItemVal)m_Debug && id < (ItemVal)m_lastDebug)
      {
	if (id == (ItemVal)m_Debug)
	    return;
	else
	    ((videApp*)theApp)->debugCommand((videCmdWindow*) this, id);
	return;
      }

    switch (id)
      {
	case m_CloseDebug:
	  {
	    videCmdWindow* cmdw = ((videApp*)theApp)->GetMsgWindow();
	    ((videApp*)theApp)->DebuggerClosed();
	    dbSendCmd("quit\n", false);
	    CloseWin();
	    break;
	  }

	case cmdAuxTimer:	// when timer ticks
	  {
	    dbShowOut();	// show any output
	    break;
	  }

	default:		// route unhandled commands up
	  {
	    vCmdWindow::WindowCommand(id, val, cType);
	    break;
	  }
      }
  }


//====================>>> vdbCmdWindow::OpenGDB <<<====================
  bool vdbCmdWindow::OpenGDB(const char* exe)
  {
#ifdef V_VersionWindows
    SECURITY_ATTRIBUTES saAttr; 
    BOOL fSuccess; 

    /* Set the bInheritHandle flag so pipe handles are inherited. */ 

    saAttr.nLength = sizeof(SECURITY_ATTRIBUTES);
    saAttr.bInheritHandle = TRUE;
    saAttr.lpSecurityDescriptor = NULL;
 
    /* 
     * The steps for redirecting child's STDOUT: 
     *     1.  Save current STDOUT, to be restored later. 
     *     2.  Create anonymous pipe to be STDOUT for child. 
     *     3.  Set STDOUT of parent to be write handle of pipe, so 
     *         it is inherited by child.
     */ 
 
    /* Save the handle to the current STDOUT. */ 

    hSaveStdout = GetStdHandle(STD_OUTPUT_HANDLE);
 
    /* Create a pipe for the child's STDOUT. */ 
 
    if (! CreatePipe(&hChildStdoutRd, &hChildStdoutWr, &saAttr, 0))
        return 0;	// ErrorExit("Stdout pipe creation failed\n");
 
    /* Set a write handle to the pipe to be STDOUT. */ 

    if (! SetStdHandle(STD_OUTPUT_HANDLE, hChildStdoutWr))
        return 0;	// ErrorExit("Redirecting STDOUT failed"); 
 
    /* 
     * The steps for redirecting child's STDIN: 
     *     1.  Save current STDIN, to be restored later. 
     *     2.  Create anonymous pipe to be STDIN for child. 
     *     3.  Set STDIN of parent to be read handle of pipe, so 
     *         it is inherited by child. 
     *     4.  Create a noninheritable duplicate of write handle, 
     *         and close the inheritable write handle. 
     */ 
 
    /* Save the handle to the current STDIN. */ 

    hSaveStdin = GetStdHandle(STD_INPUT_HANDLE);
 
    /* Create a pipe for the child's STDIN. */ 
 
    if (! CreatePipe(&hChildStdinRd, &hChildStdinWr, &saAttr, 0)) 
        return 0;	// ErrorExit("Stdin pipe creation failed\n");

    /* Set a read handle to the pipe to be STDIN. */ 
 
    if (! SetStdHandle(STD_INPUT_HANDLE, hChildStdinRd)) 
        return 0;	// ErrorExit("Redirecting Stdin failed"); 
 
    /* Duplicate the write handle to the pipe so it is not inherited. */
 
    fSuccess = DuplicateHandle(GetCurrentProcess(), hChildStdinWr, 
        GetCurrentProcess(), &hChildStdinWrDup, 0, 
        TRUE,       /* is inherited */ 
        DUPLICATE_SAME_ACCESS); 

    if (! fSuccess) 
        return 0;	// ErrorExit("DuplicateHandle failed"); 
 
    CloseHandle(hChildStdinWr); 
 
    /* Now create the child process. */


    static PROCESS_INFORMATION piProcInfo;
    STARTUPINFO siStartInfo; 

    /* Set up members of STARTUPINFO structure. */ 

    siStartInfo.cb = sizeof(STARTUPINFO); 
    siStartInfo.lpReserved = NULL; 
    siStartInfo.lpReserved2 = NULL; 
    siStartInfo.cbReserved2 = 0; 
    siStartInfo.lpDesktop = NULL;
    siStartInfo.wShowWindow = SW_MINIMIZE;
//    siStartInfo.wShowWindow = SW_SHOWNORMAL;
    siStartInfo.dwFlags = STARTF_USESHOWWINDOW | STARTF_USESTDHANDLES;
    siStartInfo.hStdOutput = hChildStdoutWr;
    siStartInfo.hStdError = hChildStdoutWr;
    siStartInfo.hStdInput = hChildStdinRd;


    char cmd[maxFileNameSize+20];

    strcpy(cmd,"gdb -f");
    if (exe && *exe)
      {
	strcat(cmd," ");
	strcat(cmd,exe);
      }
    
    /* Create the child process. */
    OSVERSIONINFO osver;
    osver.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
    int createResult;

    ::GetVersionEx(&osver);
    if (osver.dwPlatformId == VER_PLATFORM_WIN32_NT)
      {
	createResult = CreateProcess(NULL,
		cmd,
		NULL,          // process security attributes
		NULL,          // primary thread security attributes
		TRUE,          // handles are inherited
		CREATE_NEW_PROCESS_GROUP,   /* creation flags                     */
//	/* CREATE_NEW_CONSOLE |*/ CREATE_NEW_PROCESS_GROUP,
		NULL,          /* use parent's environment           */
		NULL,          /* use parent's current directory     */ 

		&siStartInfo,  /* STARTUPINFO pointer                */ 
		&piProcInfo);  /* receives PROCESS_INFORMATION       */
      }
    else		// Win9x version
      {
	createResult = CreateProcess(NULL,
		cmd,
		NULL,          /* process security attributes        */ 
		NULL,          /* primary thread security attributes */ 
		TRUE,          /* handles are inherited              */
		0,             /* creation flags                     */
// maybe:	CREATE_NEW_CONSOLE,
		NULL,          /* use parent's environment           */
		NULL,          /* use parent's current directory     */ 

		&siStartInfo,  /* STARTUPINFO pointer                */ 
		&piProcInfo);  /* receives PROCESS_INFORMATION       */
      }

    if (!createResult)
      {
	static DWORD errorCode = ::GetLastError();
	if (errorCode != 0)
	  {
	    vdbCanvas->addLine("CreateProcess Fails....");
	    vdbCanvas->bufferBottom();
	  }

	return 0;	// create fails
      }


    dbProcessId = piProcInfo.dwProcessId;	// save these for termination
    dbProcessHandle = piProcInfo.hProcess;

    /* After process creation, restore the saved STDIN and STDOUT. */

    if (! SetStdHandle(STD_INPUT_HANDLE, hSaveStdin))
        return 0;	// ErrorExit("Re-redirecting Stdin failed\n");

    if (! SetStdHandle(STD_OUTPUT_HANDLE, hSaveStdout))
        return 0;	// ErrorExit("Re-redirecting Stdout failed\n");
#endif

    return 1;

  }

//====================>>> vdbCmdWindow::dbSendCmd <<<====================
  void vdbCmdWindow::dbSendCmd(char* cmd, int echo)
  {
#ifdef V_VersionWindows
    DWORD written;

    if (echo)
      {
         vdbCanvas->bufferBottom();
         for (char* cp = cmd ; *cp && *cp != '\n' ; ++cp)
             vdbCanvas->charInsert(*cp);
         vdbCanvas->charInsert('\n');
      }

    if (!WriteFile(hChildStdinWrDup, cmd, strlen(cmd), &written, 0))
        return;
    dbShowOut();
    // @@ parse output now...
#endif

  }

//====================>>> vdbCmdWindow::dbShowOut <<<====================
  bool vdbCmdWindow::dbShowOut(bool atBottom)
  {
    // This routine checks for output from the debugger
    // This is MS-Win32 specific...

#ifdef V_VersionWindows
    DWORD bytesRead;
    DWORD bytesAvail;

    char chrin[10] = "";

    bool first = true;

    for ( ; ; )		// read all debugger output available
      {
	// first, see if any output is available...
	if (!PeekNamedPipe(hChildStdoutRd,
	    chrin, (DWORD)1, &bytesRead, &bytesAvail, 0))
	  {
	    return false;
	  }
	if (bytesAvail == 0)	// no output avail, so return
	    return false;

	if (!ReadFile(hChildStdoutRd,	// now really read it
	    chrin, (DWORD)1, &bytesRead, 0) ) return false;
	if (bytesRead == 0)		// just in case
	    return false;

	if (first)			// buffer bottom once...
	  {
	    first = false;
	    if (!atBottom)
		vdbCanvas->bufferBottom();		// add at bottom
	  }

	// add the character to the display
	if (*chrin == '\032')		// prefix from gdb for break
	  {
	    // should be 2 \032's in a row. wait for rest of line...
	    if (!ReadFile(hChildStdoutRd,	// now really read it
		chrin, (DWORD)1, &bytesRead, 0) ) return false;
	    if (bytesRead == 0)		// just in case
		return false;
	    if (*chrin != '\32')
		continue;
	    // ok - special formatted breakpoint line coming...
	    // read it all
	    char info[maxFileNameSize+2];
	    char* cp = info;
	    for ( ; ; )
	      {
		videCmdWindow* cw;
		if (!ReadFile(hChildStdoutRd,	// now really read it
		    chrin, (DWORD)1, &bytesRead, 0) ) return false;
		if (bytesRead == 0)		// just in case
		    return false;
		if (*chrin == '\n')
		  {
		    *cp = 0;
                    for (char* lp = info ; *lp ; ++lp)
                        vdbCanvas->charInsert(*lp, /*doundo*/ false);
                    vdbCanvas->charInsert('\n', /*doundo*/ false);
		    cw = GotoDebugLine(info);
                    return true;
		  }
		else
		    *cp++ = *chrin;

		theApp->CheckEvents();
	      }
	    return true;
	  }
	else if (*chrin != '\r')
	  {
	    vdbCanvas->charInsert(*chrin, /*doundo*/ false);
	  }
      }
#endif
    return true;
  }
