#!/usr/bin/perl
#
# Program to take a set of header files and generate DLL export definitions

print "EXPORTS\n";
while ( ($file = shift(@ARGV)) ) {
	if ( ! defined(open(FILE, $file)) ) {
		warn "Couldn't open $file: $!\n";
		next;
	}
	$printed_header = 0;
	$file =~ s,.*/,,;
	while (<FILE>) {
		if ( /^SDL_DEFUN\(.*,\s*([^\s]+),/ ) {
			if ( ! $printed_header ) {
				print "; Exports from $file\n";
				$printed_header = 1;
			}
			print "\t_$1\n";
		}
	}
	close(FILE);
}
print "; Special exports not in the header files\n";
print "\t_SDL_Init\n";
print "\t_SDL_Quit\n";
print "\t_SDL_LockSO\n";
print "\t_SDL_RegisterApp\n";
