/* $Id: init.c,v 1.10 1999/04/22 20:20:55 marcus Exp $
******************************************************************************

   LibGII initialization.

   Copyright (C) 1997 Jason McMullan	[jmcc@ggi-project.org]
   Copyright (C) 1998 Marcus Sundberg	[marcus@ggi-project.org]
  
   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <stdarg.h>

#include <ggi/internal/gii.h>

#include "plat.h"

/* Global variables */
uint32                _giiDebugState	= 0;
int                   _giiDebugSync	= 0;
int                   _gii_threadsafe	= 0;
void                 *_giiconfhandle	= NULL;
void                 *_gii_safe_lock	= NULL;

/* Static variables */
static int 	      _giiLibIsUp =0 ;
static char           giiconfstub[512] = GIICONFDIR;
static char          *giiconfdir = giiconfstub + GIITAGLEN;


/* 
 * Returns the directory wher global config files are kept
 */

const char *giiGetConfDir(void)
{
	return giiconfdir;
}


/*
 * Turn on thread safe operation
 */

int giiMTInit(void)
{
	_gii_threadsafe = 1;
	
	return 0;
}

/*
 * Initialize the structures for the library
 */

int giiInit(void)
{
	int err;
	const char *str;
	char conffile[1024];
	
	if (_giiLibIsUp>0) {
		/* Initialize only at first call. */
		_giiLibIsUp++;
		return 0;
	}

	err = ggInit();
	if (err != GGI_OK) {
		fprintf(stderr, "LibGII: unable to initialize LibGG\n");
		return err;
	}

	if ((_gii_safe_lock = ggLockCreate()) == NULL) {
		fprintf(stderr,"LibGII: unable to initialize safe mutex.\n");
		ggExit();
		return GGI_EUNKNOWN;
	}

	sprintf(conffile, "%s%c%s",
		giiGetConfDir(), CHAR_DIRDELIM,	GIICONFFILE);
	err = ggLoadConfig(conffile, &_giiconfhandle);
	if (err != GGI_OK) {
		ggLockDestroy(_gii_safe_lock);
		ggExit();
		fprintf(stderr, "LibGII: fatal error - could not load %s\n",
			conffile);
		return err;
	}

	str = getenv("GGI_DEBUG");
	if (str != NULL) {
		_giiDebugState = atoi(str);
		GIIDPRINT_CORE("Debugging=%d\n", _giiDebugState);
	}

	str = getenv("GGI_DEBUGSYNC");
	if (str != NULL) {
		_giiDebugSync = 1;
	}

	_giiLibIsUp++;

	return 0;
}

int giiExit(void)
{
	GIIDPRINT_CORE("giiExit() called\n");
	if (!_giiLibIsUp)
		return -1;

	if (_giiLibIsUp > 1) {
		_giiLibIsUp--;
		return _giiLibIsUp;
	}

	GIIDPRINT_CORE("giiExit: really destroying.\n");

	ggFreeConfig(_giiconfhandle);
	ggLockDestroy(_gii_safe_lock);
	ggExit();
	_giiLibIsUp=0;

	GIIDPRINT_CORE("giiExit: done!\n");
	return 0;
}
