/* $Id: dl.c,v 1.4 1999/02/25 14:59:45 marcus Exp $
***************************************************************************

   LibGG - General Module loading code

   Copyright (C) 1998  MenTaLguY   [mentalg@geocities.com]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

***************************************************************************
*/

#include <stdlib.h>
#include <string.h>

#include <ggi/gg.h>
#include "plat.h"

 
gg_module ggLoadModule(const char *filename, int flags)
{
	gg_module ret;

	if ((flags & GG_MODULE_GLOBAL)) {
		ret = GGOPENLIBGLOBAL(filename);
	} else {
		ret = GGOPENLIB(filename);
	}
	if (ret == NULL) {
		const char *err = GGDLERROR();
		if (err) {
			ggDPrintf(1, "LibGG", "unable to open lib: %s\n", err);
		}
	}
	
	return ret;
}

gg_module ggMLoadModule(const void *conf, const char *name,
			const char *version, int flags)
{
	const char *filename;

	if ((filename = ggMatchConfig(conf, name, version)) == NULL) {
		return GG_MODULE_NULL;
	}

	return ggLoadModule(filename, flags);
}

void *ggGetSymbolAddress(gg_module module, const char *symbol)
{
#ifdef GG_SYMPREFIX	
	void *ret;
	char *buffer;
	buffer = malloc(strlen(GG_SYMPREFIX) + strlen(symbol) + 1);
	strcpy(buffer, GG_SYMPREFIX);
	strcat(buffer, symbol);
	ret = GGGETSYM(module, buffer);
	free(buffer);
	return ret;
#else
	return GGGETSYM(module, symbol);
#endif
}

void ggFreeModule(gg_module module)
{
	GGCLOSELIB(module);
}
