/* $Id: box.c,v 1.5 1999/05/12 21:14:52 marcus Exp $
******************************************************************************

   LibGGI - Millennium II acceleration for fbdev target

   Copyright (C) 1999 Marcus Sundberg	[marcus@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include "m2164w.h"


int GGI_m2164w_drawbox(ggi_visual *vis, int x, int y, int w, int h)
{
	if (w > 0 && h > 0) {	/* 0 width is not OK! */
		volatile uint8 *mmioaddr = FBDEV_PRIV(vis)->mmioaddr;
		int yadd = vis->w_frame_num * LIBGGI_VIRTY(vis);

		y += yadd;

		mga_gcupdate(mmioaddr, M2164W_PRIV(vis), LIBGGI_MODE(vis),
			     LIBGGI_GC(vis), LIBGGI_VIRTX(vis), yadd);

		mga_waitfifo(mmioaddr, 3);
		mga_out32(mmioaddr, M2164W_PRIV(vis)->drawboxcmd, DWGCTL);
		mga_out32(mmioaddr, ((x + w) << 16) | x, FXBNDRY);
		mga_out32(mmioaddr, (y << 16) | h, YDSTLEN | EXECUTE);

		vis->accelactive = 1;
	}

	return 0;
}


int GGI_m2164w_fillscreen(ggi_visual *vis)
{
	volatile uint8 *mmioaddr = FBDEV_PRIV(vis)->mmioaddr;
	int virtx = LIBGGI_VIRTX(vis);
	int virty = LIBGGI_VIRTY(vis);
	int yadd = vis->w_frame_num * LIBGGI_VIRTY(vis);

	mga_gcupdate(mmioaddr, M2164W_PRIV(vis), LIBGGI_MODE(vis),
		     LIBGGI_GC(vis), LIBGGI_VIRTX(vis), yadd);

	mga_waitfifo(mmioaddr, 3);
	mga_out32(mmioaddr, M2164W_PRIV(vis)->drawboxcmd, DWGCTL);
	mga_out32(mmioaddr, ((0 + virtx) << 16) | 0, FXBNDRY);
	mga_out32(mmioaddr, (yadd << 16) | (virty + yadd), YDSTLEN | EXECUTE);

	vis->accelactive = 1;

	return 0;
}
