/*
 * Copyright(c) 1992 Bell Communications Research, Inc. (Bellcore)
 *                        All rights reserved
 * Permission to use, copy, modify and distribute this material for
 * any purpose and without fee is hereby granted, provided that the
 * above copyright notice and this permission notice appear in all
 * copies, and that the name of Bellcore not be used in advertising
 * or publicity pertaining to this material without the specific,
 * prior written permission of an authorized representative of
 * Bellcore.
 *
 * BELLCORE MAKES NO REPRESENTATIONS AND EXTENDS NO WARRANTIES, EX-
 * PRESS OR IMPLIED, WITH RESPECT TO THE SOFTWARE, INCLUDING, BUT
 * NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR ANY PARTICULAR PURPOSE, AND THE WARRANTY AGAINST IN-
 * FRINGEMENT OF PATENTS OR OTHER INTELLECTUAL PROPERTY RIGHTS.  THE
 * SOFTWARE IS PROVIDED "AS IS", AND IN NO EVENT SHALL BELLCORE OR
 * ANY OF ITS AFFILIATES BE LIABLE FOR ANY DAMAGES, INCLUDING ANY
 * LOST PROFITS OR OTHER INCIDENTAL OR CONSEQUENTIAL DAMAGES RELAT-
 * ING TO THE SOFTWARE.
 *
 * $Id: matrix.c,v 1.1 1999/08/04 21:24:16 danny Exp $
 */

#ifdef HAVE_CONFIG_H
#include <XbaeConfig.h>
#endif

#include <Xbae/Matrix.h>

void
labelCB( mw, cd, cb )
Widget mw;
XtPointer cd;
XtPointer cb;
{
    XbaeMatrixLabelActivateCallbackStruct *cbs =
	( XbaeMatrixLabelActivateCallbackStruct * )cb;

    if( cbs->row_label )
	if( XbaeMatrixIsRowSelected( mw, cbs->row ) )
	    XbaeMatrixDeselectRow( mw, cbs->row );
	else
	    XbaeMatrixSelectRow( mw, cbs->row );
    else
	if( XbaeMatrixIsColumnSelected( mw, cbs->column ) )
	    XbaeMatrixDeselectColumn( mw, cbs->column );
	else
	    XbaeMatrixSelectColumn( mw, cbs->column );
}

/*
 * Simple example of loaded Matrix
 */

int
main(argc, argv)
int argc;
char *argv[];
{
    Widget toplevel, mw;
    XtAppContext app;

#ifdef USE_EDITRES
    extern void _XEditResCheckMessages();
#endif

    toplevel = XtVaAppInitialize(&app, "Matrix",
				 NULL, 0,
				 &argc, argv,
				 NULL,
				 NULL);
#ifdef USE_EDITRES
    XtAddEventHandler( toplevel, (EventMask)0, True,
                       _XEditResCheckMessages, NULL);
#endif

    mw = XtVaCreateManagedWidget("mw",
				 xbaeMatrixWidgetClass, toplevel,
				 NULL);

    XtAddCallback( mw, XmNlabelActivateCallback, ( XtCallbackProc )labelCB,
		   NULL );
    
    XtRealizeWidget(toplevel);
    XtAppMainLoop(app);
    
    /*NOTREACHED*/
    return 0;
}

