/*
 * AUTHOR: Jay Schmidgall <jay.schmidgall@spdbump.sungardss.com>
 *
 * $Id: choice.c,v 1.1 1999/08/04 21:24:04 danny Exp $
 */

#ifdef HAVE_CONFIG_H
#include <XbaeConfig.h>
#endif

#include <Xbae/Matrix.h>
#include <Xbae/Actions.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/Label.h>
#include <Xm/RowColumn.h>
#include <Xm/Scale.h>
#include <Xm/ToggleB.h>
#include <Xm/TextF.h>
#include <Xm/Text.h>

#include <stdio.h>
#include <string.h>

void
LoadMatrix(w)
Widget w;
{
    String *cells[10];
    static String rows[10][10] = {
	{ "0,Zero", "0,One",  "0,Two",    "0,Three",  "0,Four",
	  "0,Five", "0,Six",  "0, Seven", "0, Eight", "0, Nine" },
	{ "1,Zero", "1,One",  "1,Two",    "1,Three",  "1,Four",
	  "1,Five", "1,Six",  "1, Seven", "1, Eight", "1, Nine" },
	{ "2,Zero", "2,One",  "2,Two",    "2,Three",  "2,Four",
	  "2,Five", "2,Six",  "2, Seven", "2, Eight", "2, Nine" },
	{ "3,Zero", "3,One",  "3,Two",    "3,Three",  "3,Four",
	  "3,Five", "3,Six",  "3, Seven", "3, Eight", "3, Nine" },
	{ "4,Zero", "4,One",  "4,Two",    "4,Three",  "4,Four",
	  "4,Five", "4,Six",  "4, Seven", "4, Eight", "4, Nine" },
	{ "5,Zero", "5,One",  "5,Two",    "5,Three",  "5,Four",
	  "5,Five", "5,Six",  "5, Seven", "5, Eight", "5, Nine" },
	{ "6,Zero", "6,One",  "6,Two",    "6,Three",  "6,Four",
	  "6,Five", "6,Six",  "6, Seven", "6, Eight", "6, Nine" },
	{ "7,Zero", "7,One",  "7,Two",    "7,Three",  "7,Four",
	  "7,Five", "7,Six",  "7, Seven", "7, Eight", "7, Nine" },
	{ "8,Zero", "8,One",  "8,Two",    "8,Three",  "8,Four",
	  "8,Five", "8,Six",  "8, Seven", "8, Eight", "8, Nine" },
	{ "9,Zero", "9,One",  "9,Two",    "9,Three",  "9,Four",
	  "9,Five", "9,Six",  "9, Seven", "9, Eight", "9, Nine" }
    };

    cells[0] = &rows[0][0];
    cells[1] = &rows[1][0];
    cells[2] = &rows[2][0];
    cells[3] = &rows[3][0];
    cells[4] = &rows[4][0];
    cells[5] = &rows[5][0];
    cells[6] = &rows[6][0];
    cells[7] = &rows[7][0];
    cells[8] = &rows[8][0];
    cells[9] = &rows[9][0];
    
    XtVaSetValues(w,
		  XmNcells,     cells,
		  NULL);
}

typedef struct {
    Widget  mw;
    char    *resource;
    int	    value;
} SetValueStruct;

typedef struct {
    int value;
    Pixel armColor;
    Pixel foreColor;
    Pixel backColor;
} SelectModeStruct;

enum { SelectSelect, SelectHighlight, SelectArm };

void
cbSelectMode(w, client, call)
Widget w;
XtPointer client;
XtPointer call;
{
    SelectModeStruct *sms;
    XmToggleButtonCallbackStruct *cbs = (XmToggleButtonCallbackStruct *) call;
    SetValueStruct *svs = (SetValueStruct *) client;
    unsigned char *rowShadows = NULL;
    unsigned char *columnShadows = NULL;
    unsigned char **cellShadows = NULL;
    unsigned char cellShadowType;
    Pixel **backgrounds = NULL;
    int rows, columns, r, c;
	
    XtVaGetValues(svs->mw,
		  XmNuserData, &sms,
		  XmNrows, &rows,
		  XmNcolumns, &columns,
		  XmNcellShadowType, &cellShadowType,
		  NULL);
    
    if (cbs->set)
	sms->value = svs->value;

    if (sms->value == SelectArm)
    {
	cellShadows = (unsigned char **) XtMalloc(rows * sizeof(unsigned char *));
	backgrounds = (Pixel **) XtMalloc(rows * sizeof(Pixel *));
	rowShadows = (unsigned char*) XtMalloc(rows * sizeof(unsigned char));
	columnShadows = (unsigned char*) XtMalloc(columns * sizeof(unsigned char));
	for (r = 0; r < rows; r++)
	{
	    cellShadows[r] = (unsigned char*) XtMalloc(columns * sizeof(unsigned char));
	    backgrounds[r] = (Pixel *) XtMalloc(columns * sizeof(Pixel));
	    rowShadows[r] = cellShadowType;
	    for (c = 0; c < columns; c++)
	    {
		cellShadows[r][c] = cellShadowType;
		backgrounds[r][c] = sms->backColor;
		columnShadows[c] = cellShadowType;
	    }
	}
    }
    
    XtVaSetValues(svs->mw,
		  XmNcellBackgrounds, backgrounds,
		  XmNcellShadowTypes, cellShadows,
		  XmNrowShadowTypes, rowShadows,
		  XmNcolumnShadowTypes, columnShadows,
		  NULL);

    XbaeMatrixRefresh(svs->mw);
}


void
UnarmAll(w, sms)
Widget w;
SelectModeStruct *sms;
{
    int rows, columns, r, c;
    unsigned char *rowShadows, *columnShadows, **cellShadows;
    unsigned char grid, cellShadowType;
    Pixel **backgrounds;

    if (sms->value != SelectArm)
	return;
    
    XtVaGetValues(w,
		  XmNrows, &rows,
		  XmNcolumns, &columns,
		  XmNgridType, &grid,
		  XmNcellBackgrounds, &backgrounds,
		  XmNcellShadowType, &cellShadowType,
		  XmNcellShadowTypes, &cellShadows,
		  XmNrowShadowTypes, &rowShadows,
		  XmNcolumnShadowTypes, &columnShadows,
		  NULL);

    for (r = 0; r < rows; r++)
    {
	rowShadows[r] = cellShadowType;
	for (c = 0; c < columns; c++)
	{
	    cellShadows[r][c] = cellShadowType;
	    backgrounds[r][c] = sms->backColor;
	    columnShadows[c] = cellShadowType;
	    /* Ooops, internal function! */
	    XbaeMatrixRefreshCell(w, r, c);
	}
    }
}

void
ArmColumn(w, column, sms)
Widget w;
int column;
SelectModeStruct *sms;
{
    int rows, columns, r;
    unsigned char *rowShadows, *columnShadows, **cellShadows;
    unsigned char grid, cellShadowType;
    Pixel **backgrounds;
    
    XtVaGetValues(w,
		  XmNrows, &rows,
		  XmNcolumns, &columns,
		  XmNgridType, &grid,
		  XmNcellBackgrounds, &backgrounds,
		  XmNcellShadowType, &cellShadowType,
		  XmNcellShadowTypes, &cellShadows,
		  XmNrowShadowTypes, &rowShadows,
		  XmNcolumnShadowTypes, &columnShadows,
		  NULL);

    if (grid == XmGRID_COLUMN_SHADOW)
	switch (columnShadows[column])
	{
	    case XmSHADOW_IN:
		columnShadows[column] = XmSHADOW_OUT;
		break;

	    case XmSHADOW_OUT:
		columnShadows[column] = XmSHADOW_IN;
		break;

	    case XmSHADOW_ETCHED_IN:
		columnShadows[column] = XmSHADOW_ETCHED_OUT;
		break;

	    case XmSHADOW_ETCHED_OUT:
		columnShadows[column] = XmSHADOW_ETCHED_IN;
		break;
	}
	    
    for (r = 0; r < rows; r++)
    {
	backgrounds[r][column] = sms->armColor;

	/* Ooops, internal function! */
	XbaeMatrixRefreshCell(w, r, column);
    }
}

void
ArmRow(w, row, sms)
Widget w;
int row;
SelectModeStruct *sms;
{
    int rows, columns, c;
    unsigned char *rowShadows, *columnShadows, **cellShadows;
    unsigned char grid, cellShadowType;
    Pixel **backgrounds;
    
    XtVaGetValues(w,
		  XmNrows, &rows,
		  XmNcolumns, &columns,
		  XmNgridType, &grid,
		  XmNcellBackgrounds, &backgrounds,
		  XmNcellShadowType, &cellShadowType,
		  XmNcellShadowTypes, &cellShadows,
		  XmNrowShadowTypes, &rowShadows,
		  XmNcolumnShadowTypes, &columnShadows,
		  NULL);

    if (grid == XmGRID_ROW_SHADOW)
	switch (rowShadows[row])
	{
	    case XmSHADOW_IN:
		rowShadows[row] = XmSHADOW_OUT;
		break;

	    case XmSHADOW_OUT:
		rowShadows[row] = XmSHADOW_IN;
		break;

	    case XmSHADOW_ETCHED_IN:
		rowShadows[row] = XmSHADOW_ETCHED_OUT;
		break;

	    case XmSHADOW_ETCHED_OUT:
		rowShadows[row] = XmSHADOW_ETCHED_IN;
		break;
	}
	    
    for (c = 0; c < columns; c++)
    {
	backgrounds[row][c] = sms->armColor;
	
	/* Ooops, internal function! */
	XbaeMatrixRefreshCell(w, row, c);
    }
}

void
ArmCell(w, row, column, sms)
Widget w;
int row;
int column;
SelectModeStruct *sms;
{
    int rows, columns, r, c;
    unsigned char *rowShadows, *columnShadows, **cellShadows;
    unsigned char grid, cellShadowType;
    Pixel **backgrounds;

    XtVaGetValues(w,
		  XmNrows, &rows,
		  XmNcolumns, &columns,
		  XmNgridType, &grid,
		  XmNcellBackgrounds, &backgrounds,
		  XmNcellShadowType, &cellShadowType,
		  XmNcellShadowTypes, &cellShadows,
		  XmNrowShadowTypes, &rowShadows,
		  XmNcolumnShadowTypes, &columnShadows,
		  NULL);

    for (r = 0; r < rows; r++)
    {
	backgrounds[r][column] = sms->armColor;
	switch (cellShadows[r][column])
	{
	    case XmSHADOW_IN:
		cellShadows[r][column] = XmSHADOW_OUT;
		break;

	    case XmSHADOW_OUT:
		cellShadows[r][column] = XmSHADOW_IN;
		break;

	    case XmSHADOW_ETCHED_IN:
		cellShadows[r][column] = XmSHADOW_ETCHED_OUT;
		break;

	    case XmSHADOW_ETCHED_OUT:
		cellShadows[r][column] = XmSHADOW_ETCHED_IN;
		break;
	}
	/* Ooops, internal function! */
	XbaeMatrixRefreshCell(w, r, column);
    }

    for (c = 0; c < columns; c++)
	if (c != column)
	{
	    backgrounds[row][c] = sms->armColor;
	    switch (cellShadows[row][c])
	    {
		case XmSHADOW_IN:
		    cellShadows[row][c] = XmSHADOW_OUT;
		    break;

		case XmSHADOW_OUT:
		    cellShadows[row][c] = XmSHADOW_IN;
		    break;

		case XmSHADOW_ETCHED_IN:
		    cellShadows[row][c] = XmSHADOW_ETCHED_OUT;
		    break;

		case XmSHADOW_ETCHED_OUT:
		    cellShadows[row][c] = XmSHADOW_ETCHED_IN;
		    break;
	    }
	    /* Ooops, internal function! */
	    XbaeMatrixRefreshCell(w, row, c);
	}
}

void
cbRadio(w, client, call)
Widget w;
XtPointer client;
XtPointer call;
{
    XmToggleButtonCallbackStruct *cbs = (XmToggleButtonCallbackStruct *) call;
    SetValueStruct *svs = (SetValueStruct *) client;

    if (cbs->set)
	XtVaSetValues(svs->mw, svs->resource, svs->value, NULL);
}


void
cbScale(w, client, call)
Widget w;
XtPointer client;
XtPointer call;
{
    XmScaleCallbackStruct *cbs = (XmScaleCallbackStruct *) call;
    SetValueStruct *svs = (SetValueStruct *) client;
    XtVaSetValues(svs->mw, svs->resource, cbs->value, NULL);
}


Widget
createButtonBox(parent, name)
Widget parent;
char *name;
{
    Widget frame, frame2, label, rc;
    
    frame = XtVaCreateManagedWidget(
	"frame", xmFrameWidgetClass, parent,
	NULL);

    frame2 = XtVaCreateManagedWidget(
	"frame", xmFrameWidgetClass, frame,
	XmNchildType,		    XmFRAME_TITLE_CHILD,
	XmNchildHorizontalAlignment,   XmALIGNMENT_CENTER,
	XmNchildVerticalAlignment,	    XmALIGNMENT_CENTER,
	XmNmarginWidth,		    4,
	NULL);
    
    label = XtVaCreateManagedWidget(
	name, xmLabelWidgetClass, frame2,
	NULL);
    
    rc = XtVaCreateManagedWidget(
	"rc", xmRowColumnWidgetClass, frame,
	XmNchildType,	    XmFRAME_WORKAREA_CHILD,
	XmNadjustLast,	    False,
	XmNradioBehavior,   True,
	XmNradioAlwaysOne,  True,
	XmNnumColumns,	    1,
	XmNorientation,	    XmVERTICAL,
	XmNpacking,	    XmPACK_TIGHT,
	NULL);
    return rc;
}


Widget
createScaleBox(parent, name, min, max)
Widget parent;
char *name;
int min, max;
{
    Widget frame, frame2, label, scale;

    frame = XtVaCreateManagedWidget(
	"frame", xmFrameWidgetClass, parent,
				    NULL);

    frame2 = XtVaCreateManagedWidget(
	"frame", xmFrameWidgetClass, frame,
	XmNchildType,		    XmFRAME_TITLE_CHILD,
	XmNchildHorizontalAlignment,   XmALIGNMENT_CENTER,
	XmNchildVerticalAlignment,	    XmALIGNMENT_CENTER,
	XmNmarginWidth,		    4,
	NULL);

    label = XtVaCreateManagedWidget(
	name, xmLabelWidgetClass, frame2,
	NULL);
    
    scale = XtVaCreateManagedWidget(
	"scale", xmScaleWidgetClass, frame,
	XmNchildType,   XmFRAME_WORKAREA_CHILD,
	XmNorientation, XmHORIZONTAL,
	XmNminimum,	    min,
	XmNmaximum,	    max,
	XmNscaleMultiple, 1,
	XmNshowValue,   True,
	NULL);
    return scale;
}


void
createGridType(parent, mw)
Widget parent;
Widget mw;
{
    Widget rc, button;
    SetValueStruct *svs;
    String resource = XtNewString(XmNgridType);

    rc = createButtonBox(parent, "Grid Type");
    XtVaSetValues(rc,
		  XmNorientation,   XmHORIZONTAL,
		  XmNnumColumns,    3,
		  XmNpacking,	    XmPACK_COLUMN,
		  NULL);

    button = XtVaCreateManagedWidget(
	"XmGRID_CELL_LINE", xmToggleButtonWidgetClass, rc,
	XmNset, True,
	NULL);
    svs = XtNew(SetValueStruct);
    svs->mw = mw;
    svs->resource = resource;
    svs->value = XmGRID_CELL_LINE;
    XtAddCallback(button, XmNvalueChangedCallback, cbRadio, (XtPointer) svs);
    
    button = XtVaCreateManagedWidget(
	"XmGRID_ROW_LINE", xmToggleButtonWidgetClass, rc,
	NULL);
    svs = XtNew(SetValueStruct);
    svs->mw = mw;
    svs->resource = resource;
    svs->value = XmGRID_ROW_LINE;
    XtAddCallback(button, XmNvalueChangedCallback, cbRadio, (XtPointer) svs);
    
    button = XtVaCreateManagedWidget(
	"XmGRID_COLUMN_LINE", xmToggleButtonWidgetClass, rc,
	NULL);
    svs = XtNew(SetValueStruct);
    svs->mw = mw;
    svs->resource = resource;
    svs->value = XmGRID_COLUMN_LINE;
    XtAddCallback(button, XmNvalueChangedCallback, cbRadio, (XtPointer) svs);
    
    button = XtVaCreateManagedWidget(
	"XmGRID_CELL_SHADOW", xmToggleButtonWidgetClass, rc,
	NULL);
    svs = XtNew(SetValueStruct);
    svs->mw = mw;
    svs->resource = resource;
    svs->value = XmGRID_CELL_SHADOW;
    XtAddCallback(button, XmNvalueChangedCallback, cbRadio, (XtPointer) svs);
    
    button = XtVaCreateManagedWidget(
	"XmGRID_ROW_SHADOW", xmToggleButtonWidgetClass, rc,
	NULL);
    svs = XtNew(SetValueStruct);
    svs->mw = mw;
    svs->resource = resource;
    svs->value = XmGRID_ROW_SHADOW;
    XtAddCallback(button, XmNvalueChangedCallback, cbRadio, (XtPointer) svs);
    
    button = XtVaCreateManagedWidget(
	"XmGRID_COLUMN_SHADOW", xmToggleButtonWidgetClass, rc,
	NULL);
    svs = XtNew(SetValueStruct);
    svs->mw = mw;
    svs->resource = resource;
    svs->value = XmGRID_COLUMN_SHADOW;
    XtAddCallback(button, XmNvalueChangedCallback, cbRadio, (XtPointer) svs);
    
    button = XtVaCreateManagedWidget(
	"XmGRID_NONE", xmToggleButtonWidgetClass, rc,
	NULL);
    svs = XtNew(SetValueStruct);
    svs->mw = mw;
    svs->resource = resource;
    svs->value = XmGRID_NONE;
    XtAddCallback(button, XmNvalueChangedCallback, cbRadio, (XtPointer) svs);
    }


void
createCellShadowType(parent, mw)
Widget parent;
Widget mw;
{
    Widget rc, button;
    SetValueStruct *svs;
    String resource = XtNewString(XmNcellShadowType);

    rc = createButtonBox(parent, "Cell Shadow Type");

    button = XtVaCreateManagedWidget(
	"XmSHADOW_IN", xmToggleButtonWidgetClass, rc,
	NULL);
    svs = XtNew(SetValueStruct);
    svs->mw = mw;
    svs->resource = resource;
    svs->value = XmSHADOW_IN;
    XtAddCallback(button, XmNvalueChangedCallback, cbRadio, (XtPointer) svs);
    
    button = XtVaCreateManagedWidget(
	"XmSHADOW_OUT", xmToggleButtonWidgetClass, rc,
	XmNset, True,
	NULL);
    svs = XtNew(SetValueStruct);
    svs->mw = mw;
    svs->resource = resource;
    svs->value = XmSHADOW_OUT;
    XtAddCallback(button, XmNvalueChangedCallback, cbRadio, (XtPointer) svs);
    
    button = XtVaCreateManagedWidget(
	"XmSHADOW_ETCHED_IN", xmToggleButtonWidgetClass, rc,
	NULL);
    svs = XtNew(SetValueStruct);
    svs->mw = mw;
    svs->resource = resource;
    svs->value = XmSHADOW_ETCHED_IN;
    XtAddCallback(button, XmNvalueChangedCallback, cbRadio, (XtPointer) svs);
    
    button = XtVaCreateManagedWidget(
	"XmSHADOW_ETCHED_OUT", xmToggleButtonWidgetClass, rc,
	NULL);
    svs = XtNew(SetValueStruct);
    svs->mw = mw;
    svs->resource = resource;
    svs->value = XmSHADOW_ETCHED_OUT;
    XtAddCallback(button, XmNvalueChangedCallback, cbRadio, (XtPointer) svs);
}
    

void
createShadowType(parent, mw)
Widget parent;
Widget mw;
{
    Widget rc, button;
    SetValueStruct *svs;
    String resource = XtNewString(XmNshadowType);

    rc = createButtonBox(parent, "Shadow Type");

    button = XtVaCreateManagedWidget(
	"XmSHADOW_IN", xmToggleButtonWidgetClass, rc,
	XmNset, True,
	NULL);
    svs = XtNew(SetValueStruct);
    svs->mw = mw;
    svs->resource = resource;
    svs->value = XmSHADOW_IN;
    XtAddCallback(button, XmNvalueChangedCallback, cbRadio, (XtPointer) svs);
    
    button = XtVaCreateManagedWidget(
	"XmSHADOW_OUT", xmToggleButtonWidgetClass, rc,
	NULL);
    svs = XtNew(SetValueStruct);
    svs->mw = mw;
    svs->resource = resource;
    svs->value = XmSHADOW_OUT;
    XtAddCallback(button, XmNvalueChangedCallback, cbRadio, (XtPointer) svs);
    
    button = XtVaCreateManagedWidget(
	"XmSHADOW_ETCHED_IN", xmToggleButtonWidgetClass, rc,
	NULL);
    svs = XtNew(SetValueStruct);
    svs->mw = mw;
    svs->resource = resource;
    svs->value = XmSHADOW_ETCHED_IN;
    XtAddCallback(button, XmNvalueChangedCallback, cbRadio, (XtPointer) svs);
    
    button = XtVaCreateManagedWidget(
	"XmSHADOW_ETCHED_OUT", xmToggleButtonWidgetClass, rc,
	NULL);
    svs = XtNew(SetValueStruct);
    svs->mw = mw;
    svs->resource = resource;
    svs->value = XmSHADOW_ETCHED_OUT;
    XtAddCallback(button, XmNvalueChangedCallback, cbRadio, (XtPointer) svs);
}
    

void
createPlacement(parent, mw)
Widget parent;
Widget mw;
{
    Widget rc, button;
    SetValueStruct *svs;
    String resource = XtNewString(XmNscrollBarPlacement);

    rc = createButtonBox(parent, "Scrollbar Placement");

    button = XtVaCreateManagedWidget(
	"XmTOP_LEFT", xmToggleButtonWidgetClass, rc,
	NULL);
    svs = XtNew(SetValueStruct);
    svs->mw = mw;
    svs->resource = resource;
    svs->value = XmTOP_LEFT;
    XtAddCallback(button, XmNvalueChangedCallback, cbRadio, (XtPointer) svs);

    button = XtVaCreateManagedWidget(
	"XmTOP_RIGHT", xmToggleButtonWidgetClass, rc,
	NULL);
    svs = XtNew(SetValueStruct);
    svs->mw = mw;
    svs->resource = resource;
    svs->value = XmTOP_RIGHT;
    XtAddCallback(button, XmNvalueChangedCallback, cbRadio, (XtPointer) svs);

    button = XtVaCreateManagedWidget(
	"XmBOTTOM_LEFT", xmToggleButtonWidgetClass, rc,
	NULL);
    svs = XtNew(SetValueStruct);
    svs->mw = mw;
    svs->resource = resource;
    svs->value = XmBOTTOM_LEFT;
    XtAddCallback(button, XmNvalueChangedCallback, cbRadio, (XtPointer) svs);

    button = XtVaCreateManagedWidget(
	"XmBOTTOM_RIGHT", xmToggleButtonWidgetClass, rc,
	XmNset, True,
	NULL);
    svs = XtNew(SetValueStruct);
    svs->mw = mw;
    svs->resource = resource;
    svs->value = XmBOTTOM_RIGHT;
    XtAddCallback(button, XmNvalueChangedCallback, cbRadio, (XtPointer) svs);
}
    

void
createFill(parent, mw)
Widget parent;
Widget mw;
{
    Widget rc, button;
    SetValueStruct *svs;
    String resource = XtNewString(XmNfill);

    rc = createButtonBox(parent, "Fill");
    XtVaSetValues(rc,
		  XmNorientation,   XmHORIZONTAL,
		  XmNnumColumns,    1,
		  XmNpacking,	    XmPACK_COLUMN,
		  NULL);

    button = XtVaCreateManagedWidget(
	"True", xmToggleButtonWidgetClass, rc,
	NULL);
    svs = XtNew(SetValueStruct);
    svs->mw = mw;
    svs->resource = resource;
    svs->value = True;
    XtAddCallback(button, XmNvalueChangedCallback, cbRadio, (XtPointer) svs);
    
    button = XtVaCreateManagedWidget(
	"False", xmToggleButtonWidgetClass, rc,
	XmNset, True,
	NULL);
    svs = XtNew(SetValueStruct);
    svs->mw = mw;
    svs->resource = resource;
    svs->value = False;
    XtAddCallback(button, XmNvalueChangedCallback, cbRadio, (XtPointer) svs);
}
    

void
createColumnResize(parent, mw)
Widget parent;
Widget mw;
{
    Widget rc, button;
    SetValueStruct *svs;
    String resource = XtNewString(XmNallowColumnResize);

    rc = createButtonBox(parent, "Allow Column Resize");
    XtVaSetValues(rc,
		  XmNorientation,   XmHORIZONTAL,
		  XmNnumColumns,    1,
		  XmNpacking,	    XmPACK_COLUMN,
		  NULL);

    button = XtVaCreateManagedWidget(
	"True", xmToggleButtonWidgetClass, rc,
	NULL);
    svs = XtNew(SetValueStruct);
    svs->mw = mw;
    svs->resource = resource;
    svs->value = True;
    XtAddCallback(button, XmNvalueChangedCallback, cbRadio, (XtPointer) svs);
    
    button = XtVaCreateManagedWidget(
	"False", xmToggleButtonWidgetClass, rc,
	XmNset, True,
	NULL);
    svs = XtNew(SetValueStruct);
    svs->mw = mw;
    svs->resource = resource;
    svs->value = False;
    XtAddCallback(button, XmNvalueChangedCallback, cbRadio, (XtPointer) svs);
}
    
void
createButtonLabels(parent, mw)
Widget parent;
Widget mw;
{
    Widget rc, button;
    SetValueStruct *svs;
    String resource = XtNewString(XmNbuttonLabels);

    rc = createButtonBox(parent, "Button Labels");
    XtVaSetValues(rc,
		  XmNorientation,   XmHORIZONTAL,
		  XmNnumColumns,    1,
		  XmNpacking,	    XmPACK_COLUMN,
		  NULL);

    button = XtVaCreateManagedWidget(
	"True", xmToggleButtonWidgetClass, rc,
	NULL);
    svs = XtNew(SetValueStruct);
    svs->mw = mw;
    svs->resource = resource;
    svs->value = True;
    XtAddCallback(button, XmNvalueChangedCallback, cbRadio, (XtPointer) svs);
    
    button = XtVaCreateManagedWidget(
	"False", xmToggleButtonWidgetClass, rc,
	XmNset, True,
	NULL);
    svs = XtNew(SetValueStruct);
    svs->mw = mw;
    svs->resource = resource;
    svs->value = False;
    XtAddCallback(button, XmNvalueChangedCallback, cbRadio, (XtPointer) svs);
}

void
createRowAttached(parent, mw)
Widget parent;
Widget mw;
{
    Widget rc, button;
    SetValueStruct *svs;
    String resource = XtNewString(XmNtrailingAttachedBottom);

    rc = createButtonBox(parent, "Trailing Attached Bottom");
    XtVaSetValues(rc,
		  XmNorientation,   XmHORIZONTAL,
		  XmNnumColumns,    1,
		  XmNpacking,	    XmPACK_COLUMN,
		  NULL);

    button = XtVaCreateManagedWidget(
	"True", xmToggleButtonWidgetClass, rc,
	NULL);
    svs = XtNew(SetValueStruct);
    svs->mw = mw;
    svs->resource = resource;
    svs->value = True;
    XtAddCallback(button, XmNvalueChangedCallback, cbRadio, (XtPointer) svs);
    
    button = XtVaCreateManagedWidget(
	"False", xmToggleButtonWidgetClass, rc,
	XmNset, True,
	NULL);
    svs = XtNew(SetValueStruct);
    svs->mw = mw;
    svs->resource = resource;
    svs->value = False;
    XtAddCallback(button, XmNvalueChangedCallback, cbRadio, (XtPointer) svs);
}

void
createSelectMode(parent, mw)
Widget parent;
Widget mw;
{
    Widget rc, button;
    SetValueStruct *svs;

    rc = createButtonBox(parent, "Select Mode (not a resource)");
    XtVaSetValues(rc,
		  XmNorientation,   XmHORIZONTAL,
		  XmNnumColumns,    1,
		  XmNpacking,	    XmPACK_COLUMN,
		  NULL);

    button = XtVaCreateManagedWidget(
	"Select", xmToggleButtonWidgetClass, rc,
	XmNset, True,
	NULL);
    svs = XtNew(SetValueStruct);
    svs->mw = mw;
    svs->value = SelectSelect;
    XtAddCallback(button, XmNvalueChangedCallback, cbSelectMode, (XtPointer) svs);
    
    button = XtVaCreateManagedWidget(
	"Highlight", xmToggleButtonWidgetClass, rc,
	NULL);
    svs = XtNew(SetValueStruct);
    svs->mw = mw;
    svs->value = SelectHighlight;
    XtAddCallback(button, XmNvalueChangedCallback, cbSelectMode, (XtPointer) svs);
    
    button = XtVaCreateManagedWidget(
	"Arm", xmToggleButtonWidgetClass, rc,
	NULL);
    svs = XtNew(SetValueStruct);
    svs->mw = mw;
    svs->value = SelectArm;
    XtAddCallback(button, XmNvalueChangedCallback, cbSelectMode, (XtPointer) svs);
}

void
createVerticalDisplay(parent, mw)
Widget parent;
Widget mw;
{
    Widget rc, button;
    SetValueStruct *svs;
    String resource = XtNewString(XmNverticalScrollBarDisplayPolicy);

    rc = createButtonBox(parent, "Vertical Display Policy");

    button = XtVaCreateManagedWidget(
	"XmDISPLAY_NONE", xmToggleButtonWidgetClass, rc,
	NULL);
    svs = XtNew(SetValueStruct);
    svs->mw = mw;
    svs->resource = resource;
    svs->value = XmDISPLAY_NONE;
    XtAddCallback(button, XmNvalueChangedCallback, cbRadio, (XtPointer) svs);
    
    button = XtVaCreateManagedWidget(
	"XmDISPLAY_AS_NEEDED", xmToggleButtonWidgetClass, rc,
	XmNset, True,
	NULL);
    svs = XtNew(SetValueStruct);
    svs->mw = mw;
    svs->resource = resource;
    svs->value = XmDISPLAY_AS_NEEDED;
    XtAddCallback(button, XmNvalueChangedCallback, cbRadio, (XtPointer) svs);

    button = XtVaCreateManagedWidget(
	"XmDISPLAY_STATIC", xmToggleButtonWidgetClass, rc,
	NULL);
    svs = XtNew(SetValueStruct);
    svs->mw = mw;
    svs->resource = resource;
    svs->value = XmDISPLAY_STATIC;
    XtAddCallback(button, XmNvalueChangedCallback, cbRadio, (XtPointer) svs);
}
    

void
createHorizontalDisplay(parent, mw)
Widget parent;
Widget mw;
{
    Widget rc, button;
    SetValueStruct *svs;
    String resource = XtNewString(XmNhorizontalScrollBarDisplayPolicy);

    rc = createButtonBox(parent, "Horizontal Display Policy");

    button = XtVaCreateManagedWidget(
	"XmDISPLAY_NONE", xmToggleButtonWidgetClass, rc,
	NULL);
    svs = XtNew(SetValueStruct);
    svs->mw = mw;
    svs->resource = resource;
    svs->value = XmDISPLAY_NONE;
    XtAddCallback(button, XmNvalueChangedCallback, cbRadio, (XtPointer) svs);
    
    button = XtVaCreateManagedWidget(
	"XmDISPLAY_AS_NEEDED", xmToggleButtonWidgetClass, rc,
	XmNset, True,
	NULL);
    svs = XtNew(SetValueStruct);
    svs->mw = mw;
    svs->resource = resource;
    svs->value = XmDISPLAY_AS_NEEDED;
    XtAddCallback(button, XmNvalueChangedCallback, cbRadio, (XtPointer) svs);

    button = XtVaCreateManagedWidget(
	"XmDISPLAY_STATIC", xmToggleButtonWidgetClass, rc,
	NULL);
    svs = XtNew(SetValueStruct);
    svs->mw = mw;
    svs->resource = resource;
    svs->value = XmDISPLAY_STATIC;
    XtAddCallback(button, XmNvalueChangedCallback, cbRadio, (XtPointer) svs);
}
    

void
createCellShadowThickness(parent, mw)
Widget parent;
Widget mw;
{
    Widget scale;
    SetValueStruct *svs;
    String resource = XtNewString(XmNcellShadowThickness);

    scale = createScaleBox(parent, "Cell Shadow Thickness", 0, 10);
    XtVaSetValues(scale, XmNvalue, 1, NULL);
    svs = XtNew(SetValueStruct);
    svs->mw = mw;
    svs->resource = resource;
    XtAddCallback(scale, XmNvalueChangedCallback, cbScale, (XtPointer) svs);
}


void
createShadowThickness(parent, mw)
Widget parent;
Widget mw;
{
    Widget scale;
    SetValueStruct *svs;
    String resource = XtNewString(XmNshadowThickness);

    scale = createScaleBox(parent, "Shadow Thickness", 0, 10);
    XtVaSetValues(scale, XmNvalue, 2, NULL);
    svs = XtNew(SetValueStruct);
    svs->mw = mw;
    svs->resource = resource;
    XtAddCallback(scale, XmNvalueChangedCallback, cbScale, (XtPointer) svs);
}


void
createFixedRows(parent, mw)
Widget parent;
Widget mw;
{
    Widget scale;
    SetValueStruct *svs;
    String resource = XtNewString(XmNfixedRows);

    scale = createScaleBox(parent, "Fixed Rows", 0, 4);
    svs = XtNew(SetValueStruct);
    svs->mw = mw;
    svs->resource = resource;
    XtAddCallback(scale, XmNvalueChangedCallback, cbScale, (XtPointer) svs);
}


void
createFixedColumns(parent, mw)
Widget parent;
Widget mw;
{
    Widget scale;
    SetValueStruct *svs;
    String resource = XtNewString(XmNfixedColumns);

    scale = createScaleBox(parent, "Fixed Columns", 0, 4);
    svs = XtNew(SetValueStruct);
    svs->mw = mw;
    svs->resource = resource;
    XtAddCallback(scale, XmNvalueChangedCallback, cbScale, (XtPointer) svs);
}


void
createTrailingFixedRows(parent, mw)
Widget parent;
Widget mw;
{
    Widget scale;
    SetValueStruct *svs;
    String resource = XtNewString(XmNtrailingFixedRows);

    scale = createScaleBox(parent, "Trailing Fixed Rows", 0, 4);
    svs = XtNew(SetValueStruct);
    svs->mw = mw;
    svs->resource = resource;
    XtAddCallback(scale, XmNvalueChangedCallback, cbScale, (XtPointer) svs);
}


void
createTrailingFixedColumns(parent, mw)
Widget parent;
Widget mw;
{
    Widget scale;
    SetValueStruct *svs;
    String resource = XtNewString(XmNtrailingFixedColumns);

    scale = createScaleBox(parent, "Trailing Fixed Columns", 0, 4);
    svs = XtNew(SetValueStruct);
    svs->mw = mw;
    svs->resource = resource;
    XtAddCallback(scale, XmNvalueChangedCallback, cbScale, (XtPointer) svs);
}


void
createCellMarginWidth(parent, mw)
Widget parent;
Widget mw;
{
    Widget scale;
    SetValueStruct *svs;
    String resource = XtNewString(XmNcellMarginWidth);

    scale = createScaleBox(parent, "Cell Margin Width", 0, 10);
    XtVaSetValues(scale, XmNvalue, 5, NULL);
    svs = XtNew(SetValueStruct);
    svs->mw = mw;
    svs->resource = resource;
    XtAddCallback(scale, XmNvalueChangedCallback, cbScale, (XtPointer) svs);
}


void
createCellMarginHeight(parent, mw)
Widget parent;
Widget mw;
{
    Widget scale;
    SetValueStruct *svs;
    String resource = XtNewString(XmNcellMarginHeight);

    scale = createScaleBox(parent, "Cell Margin Height", 0, 10);
    XtVaSetValues(scale, XmNvalue, 5, NULL);
    svs = XtNew(SetValueStruct);
    svs->mw = mw;
    svs->resource = resource;
    XtAddCallback(scale, XmNvalueChangedCallback, cbScale, (XtPointer) svs);
}


void
createCellHighlightThickness(parent, mw)
Widget parent;
Widget mw;
{
    Widget scale;
    SetValueStruct *svs;
    String resource = XtNewString(XmNcellHighlightThickness);

    scale = createScaleBox(parent, "Cell Highlight Thickness", 0, 10);
    XtVaSetValues(scale, XmNvalue, 2, NULL);
    svs = XtNew(SetValueStruct);
    svs->mw = mw;
    svs->resource = resource;
    XtAddCallback(scale, XmNvalueChangedCallback, cbScale, (XtPointer) svs);
}


void
createSpace(parent, mw)
Widget parent;
Widget mw;
{
    Widget scale;
    SetValueStruct *svs;
    String resource = XtNewString(XmNspace);

    scale = createScaleBox(parent, "Space", 0, 10);
    XtVaSetValues(scale, XmNvalue, 4, NULL);
    svs = XtNew(SetValueStruct);
    svs->mw = mw;
    svs->resource = resource;
    XtAddCallback(scale, XmNvalueChangedCallback, cbScale, (XtPointer) svs);
}


void
cbSelect(w, client, call)
Widget w;
XtPointer client;
XtPointer call;
{
    int x, y;
    char buf[200];
    Widget text = (Widget) client;
    XbaeMatrixSelectCellCallbackStruct *cbs =
	(XbaeMatrixSelectCellCallbackStruct*) call;
    SelectModeStruct *sms;
    unsigned char grid;

    XtVaGetValues(w, XmNuserData, &sms,XmNgridType, &grid, NULL);
    XbaeMatrixEventToXY(w, cbs->event, &x, &y);
    
    sprintf(buf, "Selected cell %d,%d : %d, %d : event %d, %d",
	    cbs->row, cbs->column, x, y,
	    cbs->event->xbutton.x,
	    cbs->event->xbutton.y);

    XbaeMatrixDeselectAll( w );
    XbaeMatrixUnhighlightAll( w );
    UnarmAll( w, sms );
    
    if( cbs->row >= 0 && cbs->column >= 0 )
    {
	switch (sms->value)
	{
	    case SelectSelect:
		XbaeMatrixSelectColumn( w, cbs->column );
		XbaeMatrixSelectRow( w, cbs->row );
		break;

	    case SelectHighlight:
		XbaeMatrixHighlightColumn( w, cbs->column );
		XbaeMatrixHighlightRow( w, cbs->row );
		break;

	    case SelectArm:
		switch (grid)
		{
		    default:
			ArmCell( w, cbs->row, cbs->column, sms );
			break;

		    case XmGRID_CELL_SHADOW:
			ArmCell( w, cbs->row, cbs->column, sms );
			break;

		    case XmGRID_ROW_SHADOW:
			ArmRow( w, cbs->row, sms );
			break;

		    case XmGRID_COLUMN_SHADOW:
			ArmColumn( w, cbs->column, sms );
			break;
		}
		break;
	}
    }

    XmTextSetString(text, buf);
}


int
main(argc, argv)
int argc;
char *argv[];
{
    SelectModeStruct *sms;
    Widget toplevel, form, rc, mw, text;
    XtAppContext app;
#ifdef USE_EDITRES
    extern void _XEditResCheckMessages();
#endif

    toplevel = XtVaAppInitialize(&app, "Choice",
				 NULL, 0,
				 &argc, argv,
				 NULL,
				 NULL);
#ifdef USE_EDITRES
    XtAddEventHandler( toplevel, (EventMask)0, True,
                       _XEditResCheckMessages, NULL);
#endif

    form = XtVaCreateWidget("form", xmFormWidgetClass, toplevel,
			    NULL);

    text = XtVaCreateManagedWidget(
	"text", xmTextFieldWidgetClass, form,
	XmNeditable,		False,
	XmNcursorPositionVisible, False,
	XmNleftAttachment,	XmATTACH_FORM,
	XmNleftOffset,	4,
	XmNbottomAttachment,	XmATTACH_FORM,
	XmNbottomOffset,	4,
	XmNrightAttachment,	XmATTACH_FORM,
	XmNrightOffset,	4,
	NULL);

    sms = XtNew(SelectModeStruct);
    sms->value = SelectSelect;

    {
	Widget button = XtVaCreateWidget("temp", xmToggleButtonWidgetClass,
					 form, NULL);
	XtVaGetValues(button,
		      XmNselectColor, &(sms->armColor),
		      XmNforeground, &(sms->foreColor),
		      XmNbackground, &(sms->backColor),
		      NULL);
	XtDestroyWidget(button);
    }
	
    mw = XtVaCreateManagedWidget(
	"mw", xbaeMatrixWidgetClass, form,
	XmNuserData,		(XtPointer) sms,
	XmNtopOffset,		4,
	XmNleftAttachment,	XmATTACH_FORM,
	XmNleftOffset,		4,
	XmNbottomWidget,	text,
	XmNbottomAttachment,	XmATTACH_WIDGET,
	XmNbottomOffset,	4,
	XmNrightAttachment,	XmATTACH_OPPOSITE_FORM,
	XmNrightOffset,	4,
	NULL);
    XtOverrideTranslations(mw,
			   XtParseTranslationTable(
			":<Btn1Down>: SelectCell(cell) EditCell(Pointer)"));

    XtAddCallback(mw, XmNselectCellCallback, cbSelect, (XtPointer) text);
    
    rc = XtVaCreateManagedWidget(
	"rc", xmRowColumnWidgetClass, form,
	XmNtopAttachment,	XmATTACH_FORM,
	XmNleftAttachment,	XmATTACH_FORM,
	XmNadjustLast,		True,
	XmNorientation,		XmHORIZONTAL,
	XmNnumColumns,		2,
	XmNpacking,		XmPACK_TIGHT,
	NULL);

    createGridType(rc, mw);
    createVerticalDisplay(rc, mw);
    
    rc = XtVaCreateManagedWidget(
	"rc", xmRowColumnWidgetClass, form,
	XmNtopWidget,		rc,
	XmNtopAttachment,	XmATTACH_WIDGET,
	XmNleftAttachment,	XmATTACH_FORM,
	XmNrightAttachment,	XmATTACH_FORM,
	XmNadjustLast,		True,
	XmNorientation,		XmHORIZONTAL,
	XmNnumColumns,		4,
	XmNpacking,		XmPACK_TIGHT,
	NULL);

    createPlacement(rc, mw);
    createCellShadowType(rc, mw);
    createShadowType(rc, mw);
    createHorizontalDisplay(rc, mw);

    rc = XtVaCreateManagedWidget(
	"rc", xmRowColumnWidgetClass, form,
	XmNtopWidget,		rc,
	XmNtopAttachment,	XmATTACH_WIDGET,
	XmNleftAttachment,	XmATTACH_FORM,
	XmNrightAttachment,	XmATTACH_FORM,
	XmNadjustLast,		False,
	XmNorientation,		XmVERTICAL,
	XmNnumColumns,		3,
	XmNpacking,		XmPACK_COLUMN,
	NULL);
    
    createCellShadowThickness(rc, mw);
    createShadowThickness(rc, mw);
    createFixedRows(rc, mw);
    createFixedColumns(rc, mw);
    createCellMarginWidth(rc, mw);
    createCellMarginHeight(rc, mw);
    createTrailingFixedRows(rc, mw);
    createTrailingFixedColumns(rc, mw);
    createFill(rc, mw);
    createColumnResize(rc, mw);
    createButtonLabels(rc, mw);
    createRowAttached(rc, mw);

    rc = XtVaCreateManagedWidget(
	"rc", xmRowColumnWidgetClass, form,
	XmNtopWidget,		rc,
	XmNtopAttachment,	XmATTACH_WIDGET,
	XmNleftAttachment,	XmATTACH_FORM,
	XmNrightAttachment,	XmATTACH_FORM,
	XmNadjustLast,		False,
	XmNorientation,		XmHORIZONTAL,
	XmNnumColumns,		4,
	XmNpacking,		XmPACK_TIGHT,
	NULL);
    
    createSpace(rc, mw);
    createSelectMode(rc, mw);

    LoadMatrix(mw);

    XtVaSetValues(mw,
		  XmNtopWidget,		rc,
		  XmNtopAttachment,	XmATTACH_WIDGET,
		  XmNrightWidget,	rc,
		  XmNrightAttachment,	XmATTACH_OPPOSITE_WIDGET,
		  NULL);
		  
    XtManageChild(form);
    XtRealizeWidget(toplevel);
    XtAppMainLoop(app);
    /*NOTREACHED*/
    return 0;
}

