/********************************************************************************
*                                                                               *
*                     A r r o w   B u t t o n   W i d g e t                     *
*                                                                               *
*********************************************************************************
* Copyright (C) 1998 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXArrowButton.h,v 1.2 1999/09/20 22:12:56 jeroen Exp $                  *
********************************************************************************/
#ifndef FXARROWBUTTON_H
#define FXARROWBUTTON_H



// Arrow options
enum FXArrowButtonStyle {
  ARROW_NONE     = 0,
  ARROW_UP       = 0x00080000,
  ARROW_DOWN     = 0x00100000,
  ARROW_LEFT     = 0x00200000,
  ARROW_RIGHT    = 0x00400000,
  ARROW_REPEAT   = 0x00800000,
  ARROW_AUTOGRAY = 0x01000000,
  ARROW_AUTOHIDE = 0x02000000,
  ARROW_TOOLBAR  = 0x04000000
  };


// Button with an arrow
class FXAPI FXArrowButton : public FXFrame {
  FXDECLARE(FXArrowButton)
protected:
  FXColor  arrowColor;
  FXTimer *repeater;
  FXbool   state;
  FXbool   fired;
protected:
  FXArrowButton();
private:
  FXArrowButton(const FXArrowButton&);
  FXArrowButton &operator=(const FXArrowButton&);
public:
  long onPaint(FXObject*,FXSelector,void*);
  long onUpdate(FXObject*,FXSelector,void*);
  long onActivate(FXObject*,FXSelector,void*);
  long onDeactivate(FXObject*,FXSelector,void*);
  long onRepeat(FXObject*,FXSelector,void*);
  long onUngrabbed(FXObject*,FXSelector,void*);
  long onClicked(FXObject*,FXSelector,void*);
  long onEnter(FXObject*,FXSelector,void*);
  long onLeave(FXObject*,FXSelector,void*);
public:
  enum {
    ID_REPEAT=FXFrame::ID_LAST,
    ID_LAST
    };
public:
  FXArrowButton(FXComposite* p,FXObject* tgt=NULL,FXSelector sel=0,FXuint opts=FRAME_RAISED|FRAME_THICK|ARROW_UP,FXint x=0,FXint y=0,FXint w=0,FXint h=0,FXint pl=DEFAULT_PAD,FXint pr=DEFAULT_PAD,FXint pt=DEFAULT_PAD,FXint pb=DEFAULT_PAD);
  virtual FXint getDefaultWidth();
  virtual FXint getDefaultHeight();
  virtual void enable();
  virtual void disable();
  virtual FXbool canFocus() const;
  void setState(FXbool s);
  FXbool getState() const { return state; }
  void setArrowStyle(FXuint style);
  FXuint getArrowStyle() const;
  FXColor getArrowColor() const { return arrowColor; }
  void setArrowColor(FXColor clr);
  virtual ~FXArrowButton();
  };

  
#endif
