/********************************************************************************
*                                                                               *
*                            L i s t   W i d g e t                              *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXOldList.h,v 1.2 1999/09/21 13:30:03 jeroen Exp $                       *
********************************************************************************/
#ifndef FXOLDLIST_H
#define FXOLDLIST_H


//////////////////////  THIS WIDGET HAS BEEN DEPRECATED  ////////////////////////


// List options
enum FXOldListStyle {
  OLDLIST_EXTENDEDSELECT    = 0,             // Extended selection mode
  OLDLIST_SINGLESELECT      = 0x00100000,    // At most one selected item
  OLDLIST_BROWSESELECT      = 0x00200000,    // Always exactly one selected item
  OLDLIST_MULTIPLESELECT    = OLDLIST_SINGLESELECT|OLDLIST_BROWSESELECT,  // Multiple selection mode
  OLDLIST_AUTOSELECT        = 0x00400000,    // Automatically select under cursor
  OLDLIST_WANTSELECTION     = 0x00800000,    // Claim the selection
  OLDLIST_LEFTJUSTIFIED     = 0,             // Left justified items
  OLDLIST_RIGHTJUSTIFIED    = 0x01000000     // Right justified items
  };


// List Item states
enum FXListItemState {
  LISTITEM_CURRENT  = 1,
  LISTITEM_SELECTED = 2,
  LISTITEM_HISTORY  = 4,
  LISTITEM_MARK     = 8
  };
  

// List Item
struct FXOldListItem {
  FXOldListItem *prev;
  FXOldListItem *next;
  FXString       label;
  FXuint         state;
  void          *data;
  FXint          y;
  };



// Item collate function
typedef FXbool (*FXOldListItemSortFunc)(const FXOldListItem*,const FXOldListItem*);



// Base of list
class FXAPI FXOldList : public FXScrollArea {
  FXDECLARE(FXOldList)
protected:
  FXOldListItem     *firstitem;
  FXOldListItem     *lastitem;
  FXOldListItem     *anchoritem;
  FXOldListItem     *currentitem;
  FXFont            *font;
  FXOldListItemSortFunc sortfunc;
  FXColor            textColor;
  FXColor            selbackColor;
  FXColor            seltextColor;
  FXint              totalWidth;
  FXint              totalHeight;
  FXString           help;
protected:
  FXOldList();
  virtual FXOldListItem* createItem();
  virtual void deleteItem(FXOldListItem*);
  static FXbool before(FXOldListItem* a,FXOldListItem* b);
  void drawFocusRectangle(FXDCWindow& dc,FXint x,FXint y,FXint w,FXint h);
  void sort(FXOldListItem*& f1,FXOldListItem*& t1,FXOldListItem*& f2,FXOldListItem*& t2,int n);
  void recompute();
  virtual void layout();
private:
  FXOldList(const FXOldList&);
  FXOldList &operator=(const FXOldList&);
public:
  long onPaint(FXObject*,FXSelector,void*);
  long onUngrabbed(FXObject*,FXSelector,void*);
  long onKeyPress(FXObject*,FXSelector,void*);
  long onKeyRelease(FXObject*,FXSelector,void*);
  long onLeftBtnPress(FXObject*,FXSelector,void*);
  long onLeftBtnRelease(FXObject*,FXSelector,void*);
  long onMotion(FXObject*,FXSelector,void*);
  long onActivate(FXObject*,FXSelector,void*);
  long onDeactivate(FXObject*,FXSelector,void*);
  long onFocusIn(FXObject*,FXSelector,void*);
  long onFocusOut(FXObject*,FXSelector,void*);
  long onSelectionLost(FXObject*,FXSelector,void*);
  long onSelectionGained(FXObject*,FXSelector,void*);
  long onChanged(FXObject*,FXSelector,void*);
  long onAutoScroll(FXObject*,FXSelector,void*);
  long onClicked(FXObject*,FXSelector,void*);
  long onDoubleClicked(FXObject*,FXSelector,void*);
  long onTripleClicked(FXObject*,FXSelector,void*);
  long onSelected(FXObject*,FXSelector,void*);
  long onDeselected(FXObject*,FXSelector,void*);
public:
  FXOldList(FXComposite *p,FXObject* tgt=NULL,FXSelector sel=0,FXuint opts=0,FXint x=0,FXint y=0,FXint w=0,FXint h=0);
  virtual void create();
  virtual void detach();
  virtual void recalc();
  virtual FXint getContentWidth();
  virtual FXint getContentHeight();
  virtual FXbool canFocus() const;
  FXint getNumItems() const;
  FXint getNumSelectedItems() const;
  FXOldListItem** getSelectedItems() const;
  FXOldListItem* getFirstItem() const { return firstitem; }
  FXOldListItem* getLastItem() const { return lastitem; }
  FXOldListItem* getNextItem(const FXOldListItem* item) const;
  FXOldListItem* getPrevItem(const FXOldListItem* item) const;
  virtual FXOldListItem* addItemFirst(const FXString& text,void* ptr=NULL);
  virtual FXOldListItem* addItemLast(const FXString& text,void* ptr=NULL);
  virtual FXOldListItem* addItemAfter(FXOldListItem* other,const FXString& text,void* ptr=NULL);
  virtual FXOldListItem* addItemBefore(FXOldListItem* other,const FXString& text,void* ptr=NULL);
  virtual void removeItem(FXOldListItem* item);
  virtual void removeItems(FXOldListItem* fm,FXOldListItem* to);
  virtual void removeAllItems();
  virtual FXOldListItem* getItemAt(FXint x,FXint y) const;
  virtual FXint getItemX(const FXOldListItem* item) const;
  virtual FXint getItemY(const FXOldListItem* item) const;
  virtual FXint getItemWidth(const FXOldListItem* item) const;
  virtual FXint getItemHeight(const FXOldListItem* item) const;
  void updateItem(FXOldListItem* item);
  void makeItemVisible(FXOldListItem* item);
  FXbool isItemSelected(const FXOldListItem* item) const;
  FXbool isItemCurrent(const FXOldListItem* item) const;
  FXbool isItemVisible(const FXOldListItem* item) const;
  void markItems();
  FXbool selectItemRange(FXOldListItem* beg,FXOldListItem* end);
  FXbool deselectItemRange(FXOldListItem* beg,FXOldListItem* end);
  FXbool toggleItemRange(FXOldListItem* beg,FXOldListItem* end);
  FXbool restoreItemRange(FXOldListItem* beg,FXOldListItem* end);
  FXbool selectItem(FXOldListItem* item);
  FXbool deselectItem(FXOldListItem* item);
  FXbool toggleItem(FXOldListItem* item);
  FXbool restoreItem(FXOldListItem* item);
  FXint indexOfItem(const FXOldListItem* item) const;
  FXOldListItem* itemAtIndex(FXint index) const;
  void sortItems();
  void setCurrentItem(FXOldListItem* item);
  FXOldListItem* getCurrentItem() const { return currentitem; }
  void setAnchorItem(FXOldListItem* item);
  FXOldListItem* getAnchorItem() const { return anchoritem; }
  FXbool extendSelection(FXOldListItem* item);
  FXOldListItem* findItem(const FXString& text,FXuint len=2147483647) const;
  void setItemText(FXOldListItem* item,const FXString& text);
  FXString getItemText(const FXOldListItem* item) const;
  void setItemData(FXOldListItem* item,void* ptr);
  void* getItemData(const FXOldListItem* item) const;
  void setFont(FXFont* fnt);
  FXFont* getFont() const { return font; }
  FXColor getTextColor() const { return textColor; }
  void setTextColor(FXColor clr);
  FXColor getSelBackColor() const { return selbackColor; }
  void setSelBackColor(FXColor clr);
  FXColor getSelTextColor() const { return seltextColor; }
  void setSelTextColor(FXColor clr);
  FXOldListItemSortFunc getSortFunc() const { return sortfunc; }
  void setSortFunc(FXOldListItemSortFunc func){ sortfunc=func; }
  FXuint getListStyle() const;
  void setListStyle(FXuint style);
  void setHelpText(const FXString& text);
  FXString getHelpText() const { return help; }
  virtual void save(FXStream& store) const;
  virtual void load(FXStream& store);
  virtual ~FXOldList();
  };


  
#endif
