#! /usr/local/bin/python

import wpy

class MyView(wpy.CScrollView):
  def OnCreate(self, event):
    b = wpy.CPushButton(self, "Quit")
    self.button = b
    b.Create()
  def OnSize(self, rect):
    self.button.WpyPlace(rect, 0.5, 0.8, "s")
  def OnDraw(self, DC):
    pad = DC.wpyOneMeter * 5 / 1000
    DC.DrawText("Hello World", pad, pad)

class MyFrame(wpy.CFrameWnd):
  def __init__(self):
    wpy.CFrameWnd.__init__(self)
    self.wpySizeX = self.wpyScreenSizeX / 2
    self.wpySizeY = self.wpyScreenSizeX / 4

class MyApp(wpy.CWinApp):
  def InitInstance(self):
    templ = wpy.CSingleDocTemplate(wpy.CDocument, MyFrame, MyView)
    templ.wpyText = "Usual Hello World Demo"
    self.AddDocTemplate(templ)
    self.FileNew()
  def OnButtonQuit(self, control):
    self.Exit()

# Start the application, respond to events.
app = MyApp()
