from sys import stdout
from types import *

class idl_ident:
	str = 0
	repo_id = 1

class idl_type_dcl:
	type_spec = 0
	dcls = 1

class idl_const_dcl:
	const_type = 0
	ident = 1
	const_exp = 2

class idl_except_dcl:
	ident = 0
	members = 1

class idl_attr_dcl:
	readonly = 0
	param_type_spec = 1
	simple_declarations = 2

class idl_op_dcl:
	#noscript = 0
	oneway = 0
	op_type_spec = 1
	ident = 2
	parameter_dcls = 3
	raises_expr = 4
	context_expr = 5

class idl_param_dcl:
	attr = 0
	param_type_spec = 1
	simple_declarator = 2

class idl_type_integer:
	signed = 0
	type = 1

class idl_type_struct:
	ident = 0
	member_list = 1

class idl_interface:
	ident = 0
	inheritance_spec = 1
	body = 2
	
class idl_module:
	ident = 0
	definition_list = 1



class engine:
	def __init__(self, indentstr='\t'):
		self.indentstr = indentstr
		self.indentlev = 0
		self.outfile = stdout
		self.dict = {}
	def indentin(self, levels=1):
		self.indentlev = self.indentlev + levels
	def indentout(self, levels=1):
		self.indentlev = self.indentlev - levels
	def indent(self):
		self.outfile.write(self.indentstr * self.indentlev)
	def set_outfile(self, file):
		self.outfile = open(file, "w")
	def write(self, stuff):
		self.outfile.write(stuff)
	def set_attr(self, key, val):
		self.dict[key] = val
	def get_attr(self, key):
		return self.dict[key]
	def del_attr(self, key):
		del(self.dict[key])
	def process(self, dict, tree):
		if (tree == None):
			if (dict.has_key(None)):
				self.do_action(dict[None], tree)
			return
		type = tree.get_type()
		if (type == "list"):
			if (dict.has_key("_separator")):
				list = tree.get_value()
				for item in list[0:-1]:
					self.process(dict, item)
					self.do_action(dict["_separator"], item)
				self.process(dict, list[-1])
			else:
				for item in tree.get_value():
					self.process(dict, item)
		elif (dict.has_key(type)):
			self.do_action(dict[tree.get_type()], tree)
		elif (dict.has_key('*')):
			self.do_action(dict['*'], tree)
	def do_action(self, action, tree):
		if (type(action) == StringType):
			if (action == "-->"):
				self.indent()
			elif (action == "->>"):
				self.indentin()
			elif (action == "<<-"):
				self.indentout()
			else:
				self.outfile.write(action)
		elif (type(action) == TupleType):
			if (len(action) == 2):
				if (type(action[0]) == DictType):
					self.process(action[0], tree.get_value()[action[1]])
					return
				elif (type(action[0]) == FunctionType):
					apply(action[0], (self, tree.get_value()[action[1]]))
					return
			for a in action:
				self.do_action(a, tree)
		elif (type(action) == DictType):
			self.process(action, tree)
		elif (type(action) == FunctionType):
			res = apply(action, (self, tree))
			if (type(res) == StringType):
				self.outfile.write(res)
			elif (type(res) != NoneType):
				self.outfile.write(`res`)
		elif (type(action) == IntType):
			member = tree.get_value()[action]
			if (type(member) == StringType):
				self.outfile.write(member)
			else:
				self.outfile.write(`member`)
		elif (type(action) == NoneType):
			self.outfile.write(str(tree.get_value()))
		else:
			print "error:", type(action)

