/*
 * This file is part of the portable Forth environment written in ANSI C.
 * Copyright (C) 1995  Dirk Uwe Zoller
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This file is version 0.9.14 of 01-November-95
 * Check for the latest version of this package via anonymous ftp at
 *	roxi.rz.fht-mannheim.de:/pub/languages/forth/pfe-VERSION.tar.gz
 * or	sunsite.unc.edu:/pub/languages/forth/pfe-VERSION.tar.gz
 * or	ftp.cygnus.com:/pub/forth/pfe-VERSION.tar.gz
 *
 * Please direct any comments via internet to
 *	duz@roxi.rz.fht-mannheim.de.
 * Thank You.
 */
/*
 * exception.c ---    The Optional Exception Word Set
 * (duz 22Jul93)
 */

#include "forth.h"
#include "support.h"

#include <string.h>
#include <ctype.h>

#include "missing.h"

Code (catch)
{
  Cell catch_code = cAtch ((Xt) *sp++);
  *--sp = catch_code;
}

Code (throw)
{
  Cell n = *sp++;

  switch (n)
    {
    case 0:
      return;
    case 2:
      tHrow (2, (char *) sp[1], sp[0]);
    default:
      tHrow (n);
    }
}

/* *INDENT-OFF* */
LISTWORDS (exception) =
{
  CO ("CATCH", catch),
  CO ("THROW", throw),
};
COUNTWORDS (exception, "Exception + extensions");
