


CALLBACK(3)                                           CALLBACK(3)


NNAAMMEE
       callback - closures with variable arguments as first-class
       C functions

SSYYNNOOPPSSIISS
       ##iinncclluuddee <<ccaallllbbaacckk..hh>>

       vvooiidd _f_u_n_c_t_i_o_n ((_d_a_t_a,, _a_l_i_s_t))
         vvooiidd** _d_a_t_a;;
         vvaa__aalliisstt _a_l_i_s_t;;
       {{
         vvaa__ssttaarrtt___t_y_p_e((_a_l_i_s_t[[,, _r_e_t_u_r_n___t_y_p_e]]));;
         _a_r_g == vvaa__aarrgg___t_y_p_e((_a_l_i_s_t[[,, _a_r_g___t_y_p_e]]));;
         vvaa__rreettuurrnn___t_y_p_e((_a_l_i_s_t[[[[,, _r_e_t_u_r_n___t_y_p_e]],, _r_e_t_u_r_n___v_a_l_u_e]]));;
       }}

       _c_a_l_l_b_a_c_k == aalllloocc__ccaallllbbaacckk((_&_f_u_n_c_t_i_o_n,, _d_a_t_a));;

       ffrreeee__ccaallllbbaacckk((_c_a_l_l_b_a_c_k));;

       iiss__ccaallllbbaacckk((_c_a_l_l_b_a_c_k))
       ccaallllbbaacckk__aaddddrreessss((_c_a_l_l_b_a_c_k))
       ccaallllbbaacckk__ddaattaa((_c_a_l_l_b_a_c_k))

DDEESSCCRRIIPPTTIIOONN
       These functions implement _c_l_o_s_u_r_e_s with variable arguments
       as first-class C functions.

       Closures  as  _f_i_r_s_t_-_c_l_a_s_s  _C _f_u_n_c_t_i_o_n_s means that they fit
       into a function pointer and can be called exactly like any
       other  C function. Moreover, they can be called with vari-
       able arguments and can return variable return values.

       _c_a_l_l_b_a_c_k ==  aalllloocc__ccaallllbbaacckk((_&_f_u_n_c_t_i_o_n,,  _d_a_t_a))  allocates  a
       callback.  When  _c_a_l_l_b_a_c_k gets called, it arranges to call
       _f_u_n_c_t_i_o_n, passing _d_a_t_a as first argument  and,  as  second
       argument, the entire sequence of arguments passed to _c_a_l_l_-
       _b_a_c_k.

       Function calling conventions differ considerably  on  dif-
       ferent  machines, therefore the arguments are accessed and
       the result value is stored through the same macros as used
       by the _v_a_c_a_l_l package, see below.

       The  callbacks are functions with indefinite extent: _c_a_l_l_-
       _b_a_c_k is only deallocated when  ffrreeee__ccaallllbbaacckk((_c_a_l_l_b_a_c_k))  is
       called.

       iiss__ccaallllbbaacckk((_c_a_l_l_b_a_c_k))  checks whether the C function _c_a_l_l_-
       _b_a_c_k was produced by a call to  _a_l_l_o_c___c_a_l_l_b_a_c_k.   If  this
       returns true, the arguments given to _a_l_l_o_c___c_a_l_l_b_a_c_k can be
       retrieved:

           ccaallllbbaacckk__aaddddrreessss((_c_a_l_l_b_a_c_k)) returns _&_f_u_n_c_t_i_o_n,



                         25 October 1997                        1





CALLBACK(3)                                           CALLBACK(3)


           ccaallllbbaacckk__ddaattaa((_c_a_l_l_b_a_c_k)) returns _d_a_t_a.


VVAACCAALLLL MMAACCRROOSS
       Within _f_u_n_c_t_i_o_n, the following macros can be used to  walk
       through the argument list and specify a return value:

       vvaa__ssttaarrtt___t_y_p_e((_a_l_i_s_t[[,, _r_e_t_u_r_n___t_y_p_e]]));;
              starts the walk through the argument list and spec-
              ifies the return type.

       _a_r_g == vvaa__aarrgg___t_y_p_e((_a_l_i_s_t[[,, _a_r_g___t_y_p_e]]));;
              fetches the next argument from the argument list.

       vvaa__rreettuurrnn___t_y_p_e((_a_l_i_s_t[[[[,, _r_e_t_u_r_n___t_y_p_e]],, _r_e_t_u_r_n___v_a_l_u_e]]));;
              ends the walk through the argument list and  speci-
              fies the return value.

       The  _t_y_p_e in vvaa__ssttaarrtt___t_y_p_e and vvaa__rreettuurrnn___t_y_p_e shall be one
       of vvooiidd, iinntt, uuiinntt, lloonngg, uulloonngg, lloonngglloonngg, uulloonngglloonngg, ddoouu--
       bbllee,  ssttrruucctt, ppttrr or (for ANSI C calling conventions only)
       cchhaarr, sscchhaarr, uucchhaarr, sshhoorrtt, uusshhoorrtt, ffllooaatt, depending on the
       class of _r_e_t_u_r_n___t_y_p_e.

       The  _t_y_p_e  specifiers  in vvaa__ssttaarrtt___t_y_p_e and vvaa__rreettuurrnn___t_y_p_e
       must be the same.  The _r_e_t_u_r_n___t_y_p_e  specifiers  passed  to
       vvaa__ssttaarrtt___t_y_p_e and vvaa__rreettuurrnn___t_y_p_e must be the same.

       The  _t_y_p_e  in vvaa__aarrgg___t_y_p_e shall be one of iinntt, uuiinntt, lloonngg,
       uulloonngg, lloonngglloonngg, uulloonngglloonngg, ddoouubbllee, ssttrruucctt,  ppttrr  or  (for
       ANSI  C  calling  conventions  only)  cchhaarr,  sscchhaarr, uucchhaarr,
       sshhoorrtt, uusshhoorrtt, ffllooaatt, depending on the class of  _a_r_g___t_y_p_e.

       In  vvaa__ssttaarrtt__ssttrruucctt((_a_l_i_s_t,,  _r_e_t_u_r_n___t_y_p_e,,  _s_p_l_i_t_t_a_b_l_e));; the
       _s_p_l_i_t_t_a_b_l_e flag specifies whether the  struct  _r_e_t_u_r_n___t_y_p_e
       can  be returned in registers such that every struct field
       fits entirely in a single register. This needs to be spec-
       ified  for  structs of size 2*sizeof(long). For structs of
       size <= sizeof(long), _s_p_l_i_t_t_a_b_l_e is ignored and assumed to
       be  1. For structs of size > 2*sizeof(long), _s_p_l_i_t_t_a_b_l_e is
       ignored and assumed to be 0. There are some  handy  macros
       for this:
       vvaa__wwoorrdd__sspplliittttaabbllee__11 ((_t_y_p_e_1))
       vvaa__wwoorrdd__sspplliittttaabbllee__22 ((_t_y_p_e_1,, _t_y_p_e_2))
       vvaa__wwoorrdd__sspplliittttaabbllee__33 ((_t_y_p_e_1,, _t_y_p_e_2,, _t_y_p_e_3))
       vvaa__wwoorrdd__sspplliittttaabbllee__44 ((_t_y_p_e_1,, _t_y_p_e_2,, _t_y_p_e_3,, _t_y_p_e_4))
       For a struct with three slots
       ssttrruucctt {{ _t_y_p_e_1 _i_d_1;; _t_y_p_e_2 _i_d_2;; _t_y_p_e_3 _i_d_3;; }}
       you can specify _s_p_l_i_t_t_a_b_l_e as vvaa__wwoorrdd__sspplliittttaabbllee__33 ((_t_y_p_e_1,,
       _t_y_p_e_2,, _t_y_p_e_3)) .


NNOOTTEESS
       Functions which want to emulate Kernighan & Ritchie  style



                         25 October 1997                        2





CALLBACK(3)                                           CALLBACK(3)


       functions  (i.e.,  in  ANSI  C,  functions without a typed
       argument list) cannot use the  _t_y_p_e  values  cchhaarr,  sscchhaarr,
       uucchhaarr, sshhoorrtt, uusshhoorrtt, ffllooaatt.  As prescribed by the default
       K&R C expression promotions, they have to use iinntt  instead
       of cchhaarr, sscchhaarr, uucchhaarr, sshhoorrtt, uusshhoorrtt and ddoouubbllee instead of
       ffllooaatt.

       The  macros   vvaa__ssttaarrtt__lloonngglloonngg(()),   vvaa__ssttaarrtt__uulloonngglloonngg(()),
       vvaa__rreettuurrnn__lloonngglloonngg(()),               vvaa__rreettuurrnn__uulloonngglloonngg(()),
       vvaa__aarrgg__lloonngglloonngg(()) and vvaa__aarrgg__uulloonngglloonngg(()) work only if  the
       C compiler has a working lloonngg lloonngg 64-bit integer type.


SSEEEE AALLSSOO
       vvaaccaallll(3), ttrraammppoolliinnee(3).


BBUUGGSS
       The  current  implementations have been tested on a selec-
       tion of common cases but there  are  probably  still  many
       bugs.

       There  are  typically  built-in  limits on the size of the
       argument-list, which may also  include  the  size  of  any
       structure arguments.

       The  decision whether a struct is to be returned in regis-
       ters or in memory considers only  the  struct's  size  and
       alignment.  This  is inaccurate: for example, gcc on m68k-
       next returns ssttrruucctt {{  cchhaarr  aa,,bb,,cc;;  }}  in  registers  and
       ssttrruucctt  {{ cchhaarr aa[[33]];; }} in memory, although both types have
       the same size and the same alignment.

       <<ccaallllbbaacckk..hh>>  cannot  be  included  when  <<vvaarraarrggss..hh>>   or
       <<ssttddaarrgg..hh>> is included.  (Name clash for vvaa__aalliisstt.)

       The argument list can only be walked once.


NNOONN--BBUUGGSS
       All  information is passed in CPU registers and the stack.
       The ccaallllbbaacckk package is therefore multithread-safe.


PPOORRTTIINNGG
       Porting ccaallllbbaacckk consists in first porting the vvaaccaallll  and
       ttrraammppoolliinnee  packages,  then  choosing  a  CPU register for
       passing the closure from ttrraammppoolliinnee to vvaaccaallll.  This  reg-
       ister    is    normally   the   register   designated   by
       STATIC_CHAIN_REGNUM in the gcc source, file gcc-2.7.2/con-
       fig/_c_p_u/_c_p_u.h.






                         25 October 1997                        3





CALLBACK(3)                                           CALLBACK(3)


AAUUTTHHOORR
       Bruno Haible <haible@clisp.cons.org>


AACCKKNNOOWWLLEEDDGGEEMMEENNTTSS
       Many ideas were cribbed from the gcc source.



















































                         25 October 1997                        4


