// ---------------------------------------------------------------------------
// - cserial.cxx                                                             -
// - standard system library - c low level serial function implementation    -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2000 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "cserial.hxx"

namespace aleph {

  // convert an integer to an array on bytes

  void c_ihton (const int value, char* array) {
    union {
      int  ival;
      char bval[4];
    } data;
    data.ival = value;
    array[0] = data.bval[3];
    array[1] = data.bval[2];
    array[2] = data.bval[1];
    array[3] = data.bval[0];
  }

  // convert an array of bytes to an integer

  int c_intoh (char* array) {
    union {
      int  ival;
      char bval[4];
    } data;
    data.bval[0] = array[3];
    data.bval[1] = array[2];
    data.bval[2] = array[1];
    data.bval[3] = array[0];
    return data.ival;
  }

  // convert a long long integer to an array on bytes

  void c_llhton (const long long int value, char* array) {
    union {
      long long int ival;
      char bval[8];
    } data;
    data.ival = value;
    array[0] = data.bval[7];
    array[1] = data.bval[6];
    array[2] = data.bval[5];
    array[3] = data.bval[4];
    array[4] = data.bval[3];
    array[5] = data.bval[2];
    array[6] = data.bval[1];
    array[7] = data.bval[0];
  }

  // convert an array of bytes to an integer

  long long int c_llntoh (char* array) {
    union {
      long long int ival;
      char bval[8];
    } data;
    data.bval[0] = array[7];
    data.bval[1] = array[6];
    data.bval[2] = array[5];
    data.bval[3] = array[4];
    data.bval[4] = array[3];
    data.bval[5] = array[2];
    data.bval[6] = array[1];
    data.bval[7] = array[0];
    return data.ival;
  }
}
