// ---------------------------------------------------------------------------
// - Binding.cpp                                                             -
// - aleph engine - builtin binding functions implementation                 -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2000 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "Cons.hpp"
#include "Builtin.hpp"
#include "Globalset.hpp"
#include "Exception.hpp"

namespace aleph {

  // const reserved function implementation

  Object* builtin_const (Interp* interp, Nameset* nset, Cons* args) {
    long len = (args == nilp) ? 0 : args->length ();
    if (len == 0) return nilp;
    if (len == 2) {
      Object* car = args->getcar  ();
      Object* cdr = args->getcadr ();
      Object* obj = (cdr == nilp) ? nilp : cdr->eval (interp, nset);
      return (car == nilp) ? nilp : car->cdef (interp, nset, obj);
    }
    if ((len == 3) || (len == 4)) {
      Object* car = args->getcar  ();
      Object* obj = builtin_gamma (interp, nset, args->getcdr ());
      return (car == nilp) ? nilp : car->cdef (interp, nset, obj);
    }

    // invalid number of arguments
    throw Exception ("argument-error", 
		     "invalid number of arguments with const");
  }

  // trans reserved function implementation

  Object* builtin_trans (Interp* interp, Nameset* nset, Cons* args) {
    long len = (args == nilp) ? 0 : args->length ();
    if (len == 0) return nilp;
    if (len == 2) {
      Object* car = args->getcar  ();
      Object* cdr = args->getcadr ();
      Object* obj = (cdr == nilp) ? nilp : cdr->eval (interp, nset);
      return (car == nilp) ? nilp : car->vdef (interp, nset, obj);
    }
    if ((len == 3) || (len == 4)) {
      Object* car = args->getcar  ();
      Object* obj = builtin_lambda (interp, nset, args->getcdr ());
      return (car == nilp) ? nilp : car->cdef (interp, nset, obj);
    }

    // invalid number of arguments
    throw Exception ("argument-error", 
		     "invalid number of arguments with trans");
  }

  // nameset reserved function implementation

  Object* builtin_nameset (Interp* interp, Nameset* nset, Cons* args) {
    long len = (args == nilp) ? 0 : args->length ();
    if (len == 0) return new Globalset;
    if (len == 1) {
      Object* car = args->getcar ();
      Object* obj = (car == nilp) ? nilp : car->eval (interp, nset);
      Nameset* nset = dynamic_cast <Nameset*> (obj);
      if (nset == nilp) 
	throw Exception ("type-error", "invalid object with nameset",
			 Object::repr (obj));
      return new Globalset (nset);
    }
    throw Exception ("argument-error", "too many arguments with nameset");
  }
}
