# ----------------------------------------------------------------------------
# - base.mak                                                                 -
# - standard acme base makefile definition                                   -
# ----------------------------------------------------------------------------
# - This program is  free software;  you can  redistribute it and/or  modify -
# - it provided that this copyright notice is kept intact.                   -
# -                                                                          -
# - This  program  is  distributed in the hope  that it  will be useful, but -
# - without  any   warranty;  without  even   the   implied    warranty   of -
# - merchantability  or fitness for a particular purpose. In not event shall -
# - the copyright holder be  liable for  any direct, indirect, incidental or -
# - special damages arising in any way out of the use of this software.      -
# ----------------------------------------------------------------------------
# - copyright (c) 1999-2000 amaury darsch                                    -
# ----------------------------------------------------------------------------

# ----------------------------------------------------------------------------
# - this distribution revision                                               -
# ----------------------------------------------------------------------------

MAJOR           = 0
MINOR		= 4
PATCH		= 1
SONAME		= $(MAJOR).$(MINOR)
SOFILE		= $(SONAME).$(PATCH)
REVNUM		= $(MAJOR)-$(MINOR)-$(PATCH)
REVTAG		= aleph-$(REVNUM)

# ----------------------------------------------------------------------------
# - installatin directory path                                               -
# ----------------------------------------------------------------------------

BINDIR	   	= $(PREFIX)/bin
LIBDIR		= $(PREFIX)/lib
DOCDIR		= $(PREFIX)/doc/aleph
MANDIR		= $(PREFIX)/man
ETCDIR		= $(PREFIX)/etc/aleph
INCDIR		= $(PREFIX)/include/aleph

# ----------------------------------------------------------------------------
# - generic unix commands                                                    -
# ----------------------------------------------------------------------------

RM		= /bin/rm -f
CP		= /bin/cp
CPDIR		= /bin/cp -r
MV		= /bin/mv -f
LN		= /bin/ln -s
CAT		= /bin/cat
RMDIR		= /bin/rm -r -f
GREP		= /bin/grep
TOUCH		= /usr/bin/touch
TEST		= test
TAR		= tar cf
GZIP		= gzip
TIME		= time
CMP		= cmp -s

# ----------------------------------------------------------------------------
# - generic path definition                                                  -
# ----------------------------------------------------------------------------

DIRREL		= $(TOPDIR)/rel
DIRDOC		= $(TOPDIR)/doc
BINREL		= $(DIRREL)/bin
LIBREL		= $(DIRREL)/lib
INCREL		= $(DIRREL)/inc

# ----------------------------------------------------------------------------
# - project library definitions                                              -
# ----------------------------------------------------------------------------

ASYSINC		= $(INCREL)/system
ASTDINC		= $(INCREL)/stdobj
AENGINC		= $(INCREL)/engine

ASYSLIB		= libasys.a
ASTDLIB		= libastd.a
AENGLIB		= libaeng.a

LIBPSYS		= $(LIBREL)/$(ASYSLIB)
LIBPSTD		= $(LIBREL)/$(ASTDLIB) $(LIBPSYS)
LIBPENG		= $(LIBREL)/$(AENGLIB) $(LIBPSTD)

LIBDSYS		= -L $(LIBREL) -lasys
LIBDSTD		= -L $(LIBREL) -lastd -lasys
LIBDENG		= -L $(LIBREL) -laeng -lastd -lasys

ifeq ($(MODE),profiled)
LIBASYS		= $(LIBPSYS)
LIBASTD		= $(LIBPSTD)
LIBAENG		= $(LIBPENG)
else
LIBASYS		= $(LIBDSYS)
LIBASTD		= $(LIBDSTD)
LIBAENG		= $(LIBDENG)
endif

# ----------------------------------------------------------------------------
# - other shared commands and scripts                                        -
# ----------------------------------------------------------------------------

MKDIR		= $(CNFDIR)/bin/amkdir
ATEST		= $(CNFDIR)/bin/atest
BTEST		= $(CNFDIR)/bin/btest
ALEPH		= $(RELDIR)/bin/aleph
