/*  XNECVIEW - a program for visualizing NEC2 structure and gain files
 *
 *  Copyright (C) 1998-1999, P.T. de Boer -- pa3fwm@amsat.org
 *
 *  Distributed on the conditions of the GPL: see the files README and
 *  COPYING, which accompany this source file.
 */

/* ------------------------------------------------------------------------ */

/* some defines: */

#define ini_phi 30         /* initial rotation around Z-axis */
#define ini_theta 70       /* initial tilting of Z-axis */
#define ini_zoom 1.0       /* initial zoom-factor */
#define ini_trx 0          /* initial horizontal displacement of origin w.r.t. center of window */
#define ini_try 0          /* initial vertical displacement of origin w.r.t. center of window */

#define ini_winsize 500    /* initial size of window (pixels) */

#define MAXWIRES 1000      /* maximum number of wires */
#define MAXSURFACES 1000   /* maximum number of surfaces */
#define MAXEXCIS 100       /* maximum number of excitations */
#define MAXLOADS 1000      /* maximum number of loads */
#define MAXTHETAS 400      /* maximum number of theta values in gain distribution */
#define MAXPHIS 400        /* maximum number of phi values in gain distribution */

#define Axislen 1.1        /* length of axes, compared to largest dimension of the antenna or gain grid */
#define GAINSIZE 3.0       /* ratio between size of gain grid and largest dimension of the antenna */

#define C_BG   "white"     /* color of the background */
#define C_AXIS "black"     /* color of the axes */
#define C_WIRE "blue"      /* color of the wires */
#define C_SURF "green3"    /* color of the front of surfaces */
#define C_BACK "cyan"      /* color of the back of surfaces */
#define C_GAIN "red"       /* color of the gain pattern */
#define C_SCALE "yellow2"  /* color of the gain scale */
#define C_EXCI "orange"    /* color of wire segment containing excitation */
#define C_LOAD "brown"     /* color of loaded wire segment */

#define XFONT "6x10"       /* font for text in the on-screen drawing */
#define PSFONT "helvetica" /* font for postscript output (size is derived by scaling the X font) */

