/* Copyright (C) 1994 Guido Vattrodt DL3BZN
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/*  xconvers.h  convers-client 	dl3bzn
 *		parts by dk5sg (convers 2.53)
 */

#ifndef _XCONVERS_H
#define _XCONVERS_H


/*-- common DEFINES -- */
#define VERSION		"0.4"	/* defined via compileroption */
#define APPLCLASS	"Xconvers"
#define TIMEOUT		30L		/* connection timeout in seconds */
#define LINELEN_WRAP	70		/* word wrap in text widget */
#define MAXNR_COMMANDS	30		/* max. number of commands in commandMenu */
#define MAX_COMMANDLEN	80		/* max. length of each command in commandMenu */
#define QUIT_COMMAND	"/quit"		/* quit command from convers server */

/* -- structure of settings -- */
typedef struct _Settings {
	char	server[80];
	char	port[80];
	char	channel[8];
	char	name[80];
	char	pnote[80];
   } Settings;


/* -- strukture for widgets in settings-dialog -- */
typedef struct _SetWidgets {
        Widget	form;
	Widget	server;
	Widget	port;
	Widget	channel;
	Widget	name;
	Widget	pnote;
	Widget 	button_settings;
	Settings *set;
   } SetWidgets;


/* -- struktur for pointer to widgets -- */
typedef struct _AppWidgets {
	Widget form;			/* Form-Widget  mainwindow */
	Widget text;			/* Textwindow */
	Widget line;			/* Line */
	Widget button_connect;
	Widget button_disconnect;
	Widget button_stop_recording;
	Widget button_settings;
	Widget menu_comm;		/* commands menu */
	Widget file_box;		/* file selection box */
	Widget wait_dialog;
        Settings *set;
   } AppWidgets;



/* -- prototypes -- */
void CreateForm(Widget parent, AppWidgets *app_w);
void handle_XtEvents(void);
void main(int argc, char **argv);

#endif

