/* Copyright (C) 1994 Guido Vattrodt DL3BZN
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/*  text.c	text functions for xconvers
 */

#include <sys/types.h>
#include <stdio.h>     
#include <string.h>
#include <unistd.h>

#include <Xm/Xm.h>		
#include <Xm/Text.h>		

#include "xconvers.h" 
#include "misc.h"
#include "text.h"

/* globals */
extern int 	socket_fd;		/* socket filedescriptor */
extern FILE	*log_stream;		/* steam for recording file */



/*---------------------------------------------------------------------------
 * insert_text   insert text into multiline-textwidget
 */
void insert(i_text, app_w)
	char		*i_text;
 	AppWidgets	*app_w;
{
  char	*text;		/* whole text */
  int	length;		/* length of text */

  text = XmTextGetString(app_w->text);

  length = strlen(text);
  XmTextInsert(app_w->text, length, i_text);
  XmTextSetInsertionPosition(app_w->text, length+strlen(i_text));

  XtFree(text);

  /* Logfile */
  if(log_stream != NULL) fprintf(log_stream, "%s", i_text);
}

/*---------------------------------------------------------------------------
 * HandleLineCB
 */
void HandleLineCB(widget, client_data, call_data)
	Widget	widget;
	caddr_t	client_data, call_data;
{
  AppWidgets *app_w = (AppWidgets*) client_data;

  char *line;				/* inputline */
  int	pos, tmppos, maxpos, len;
  char 	cr[2] = { "\n\0" };
  char	tmpstr[TMPLEN+1];
  if(socket_fd) {
     line = XmTextGetString(app_w->line);	/* get text from line */
     maxpos = strlen(line) - 1;
     pos = 0;
     while((len = maxpos-pos) >= 0) {
        if(len > LINELEN_WRAP) {		/* line too long to fit into textwidget? */
           tmppos = pos+LINELEN_WRAP;
	   while(line[tmppos]>0x20 && tmppos!=pos) tmppos--; /* try to find gap backward */
           if(tmppos==pos) {
              tmppos = pos+LINELEN_WRAP;
	      while(line[tmppos]>0x20 && tmppos!=maxpos) tmppos++; /* try to find gap foreward */
           }
	   len = tmppos-pos;
	} else len++;
	/* put text at position line[pos] and length len into textwidget */
	len = (len > TMPLEN ? TMPLEN : len);
	strncpy(tmpstr, &line[pos], len);
	tmpstr[len] = 0;
        insert(tmpstr, app_w);			/* put into textblock */
        insert(cr, app_w); 
	pos+=len+1;
     }
     if (write(socket_fd, line, strlen(line)) < 0) stop("write to socket"); 
     if (write(socket_fd, cr, 1) < 0) stop("write to socket");  /* cr to socket */
     XtFree(line);
  }
  XmTextSetString(app_w->line, "");		/* clear inputline */
}


/*---------------------------------------------------------------------------
 * ClearCB  clear textfield 
 */
void ClearCB(widget, client_data, call_data)
	Widget	widget;
	caddr_t	client_data, call_data;
{
  AppWidgets *app_w = (AppWidgets*) client_data;

  XmTextSetString(app_w->text, "");	/* clear textblock */
}

