/*
 *  time.c
 *
 *  $Id: time.c,v 1.2 1996/08/27 23:10:19 ron Exp $
 *
 *  HISTORY
 *
 */

#include <curses.h>
#include <sys/types.h>
#include <time.h>
#include <signal.h>

static char ident[] = "@(#)time.c: logger/duper/spotter time module "\
						__TIME__ " "__DATE__ ;


#define TIME_STRING_SIZE 32

static WINDOW *time_window;

extern errno;
static dbgfd;

void
alarm_processor()
{
	time_t my_time;
	char time_string[2][TIME_STRING_SIZE];
	int y,x;

	my_time = time(NULL);
	strftime(time_string[0],TIME_STRING_SIZE,
		"%H:%M:%S %m/%d/%y UTC",gmtime(&my_time));
	strftime(time_string[1],TIME_STRING_SIZE,
		"%X %x %Z",localtime(&my_time));

	mvwprintw(time_window,0,0,time_string[0]);
	mvwprintw(time_window,1,0,time_string[1]);
	wnoutrefresh(time_window);
	refresh();
	doupdate();

	signal(SIGALRM,alarm_processor);
	alarm(1);
}

init_time_window( WINDOW *s )
{
	time_window = subwin(s,2,30,1,0);
	if (time_window == NULL) {
		printf("\n\runable to open time window errno = %d\n",errno);
		exit(-1);
	}
	signal(SIGALRM,alarm_processor);
	alarm(1);
}

void
quit_handler()
{
	endwin();
	printf("\nquit signal received\n",22);
	exit(-1);
}

void
interrupt_handler()
{
	endwin();
	printf("\ninterrupt signal received\n",27);
	exit(-1);
}

void
termination_handler()
{
	endwin();
	printf("\ntermination signal received\n",29);
	exit(-1);
}

void
child_death_handler()
{
	endwin();
	printf("\nchild death handler called\n",28);
	exit(-1);
}
