/*
 *  logwin.c
 *
 *  $Id: logwin.c,v 1.6 1996/08/27 23:10:19 ron Exp $
 *
 */

#define NOCURSES_ON_MONITOR

#include <curses.h>
#include <sys/types.h>
#include <time.h>
#include <signal.h>

static WINDOW *logwin ;;
static int display_enable ;

extern errno;

void logwin_putchar ( char c )
{
	if (!display_enable) 
		return ;
#ifdef NOCURSES_ON_MONITOR
	/* This code skips curses use to display the afos monitor */
#ifdef SILLY_IGNCR_SETTING
	if (  ( c == '\n' ) || ( c == '\r' ) )
		{ 
		static char foo[3] = "\r\n" ;
		write(1,foo,2);
		}
	else
#endif
		write(1,&c,1);
#else 
   /* The following code utilizes curses to display afos monitor */
	#if 1
		if (  ( c == '\n' ) || ( c == '\r' ) )
			waddch(logwin, c);
		else
			wechochar(logwin,c);
	#else
		waddch(logwin, c);
	#endif
	wnoutrefresh(logwin);
	doupdate();
#endif
	/*
	refresh();
	*/
}


void
log_puts( char *s )
{
	wprintw(logwin,"%s",s);
	wnoutrefresh(logwin);
	refresh();
	doupdate();
}

logwin_disable_display()
{
	display_enable = 0 ;
}

logwin_enable_display()
{
	display_enable = 1 ;
}

init_log_window( WINDOW *s )
{
	display_enable = 0 ;
	logwin = subwin(s,20,80,3,0);
	idlok(logwin,TRUE);
	scrollok(logwin,TRUE);

	if (logwin == NULL) {
		printf("\n\runable to open log window errno = %d\n",errno);
		exit(-1);
	}
	wsetscrreg(logwin, 0, 20) ;
}
