// rfile.cpp
//
// Copyright (C) 1999  Robert Barron, KA5WSS
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

#include "rfile.h"
#include <stdio.h>
#include <ctype.h>

#include <string.h>

RFile::RFile()
{
    fileName = NULL;
#if !defined(LINUX)
    eof2 = FALSE;
#endif
}

boolean RFile::eof()
{
#if !defined(LINUX)
    // We need to keep a local copy of eof to mark end of file
    //  because of a Watcom 11.0 bug (I think).  When/if this is
    //  resolved, get rid of eof and use the ios::eof only.
    if (eof2)
        return (eof2);
    else
#endif
        return (fp2.eof());
};

RFile::RFile(char *name)
{
    fileName = NULL;
#if !defined(LINUX)
    eof2 = FALSE;
#endif
    open(name);
}

RFile::~RFile()
{
    if (fileName)
        delete fileName;
//    if (fp2)
//        fp2.close();
}

boolean RFile::open(char *newName, int mode)
{
    if (!newName)
        return FALSE;

    fileName = new char[strlen(newName) + 1];
    memset(fileName, '\0', strlen(newName) + 1);
    strcpy(fileName, newName);

    fp2.open(fileName, mode);
    if (fp2.fail())
        return FALSE;

    return TRUE;
}

int RFile::fileType()
{
    long oldPosition = fp2.tellg();     // Replace with class call!!!!
    char buffer[80];
    char *suffix;
    int type = LOG_TYPE_UNKNOWN;

    if ((suffix = RFile::suffix()) == NULL)
        return type;
        
    if (!RFile::isOpen())
        return type;

    RFile::position(0);
    RFile::read((void *)buffer, 80);

    if (stricmp(suffix, "bin") == 0)
    {
        if (strncmp(&buffer[32], "CT 9.", 5) == 0)
            type = LOG_TYPE_CT9;       // CT v9 .bin file
        else if (strncmp(&buffer[32], "CT 8.", 5) == 0)
            type = LOG_TYPE_CT8;       // CT v8 .bin file
        else
            type = LOG_TYPE_CT7;       // CT v7 .bin file?
    }
    else if ((stricmp(suffix, "dat") == 0)
              && (strstr(buffer, "Band    Date    Time  QSO#  Call") != NULL))
              type = LOG_TYPE_TRLOG;         // TR .dat file
    else if ((stricmp(suffix, "dat") == 0)
              && (isdigit(buffer[0]) && buffer[25] == '-' && buffer[39] == 'Z'))
              type = LOG_TYPE_DXCLUS;        // DX Cluster dump file
    else if ((stricmp(suffix, "dat") == 0)
              && (buffer[0] == 'O'))
              type = LOG_TYPE_DXINFO;
    else if ((stricmp(suffix, "qdf") == 0)
                && ((unsigned char)buffer[0] >= 90)
                && ((unsigned char)buffer[0] < 100))
              type = LOG_TYPE_NA9LOG;
    else if ((stricmp(suffix, "qdf") == 0)
                && ((unsigned char)buffer[0] >= 80)
                && ((unsigned char)buffer[0] < 90))
              type = LOG_TYPE_NALOG;
    else if ((stricmp(suffix, "log") == 0) && (buffer[22] == '/')
              && (buffer[34] == ':'))
              type = LOG_TYPE_WRTC;
    else if ((stricmp(suffix, "log") == 0)
              && ((buffer[8] == '/') || (buffer[9] == '/') || (buffer[10] == '/')))
              type = LOG_TYPE_ARRL;
    else if (stricmp(suffix, "adi") == 0)
              type = LOG_TYPE_ADIF;

    RFile::position(oldPosition);       // Return to old file read position.
    
    return type;           // Unknown file type
}

/*
// Set the file location to the value provided.  C++ allows for separate
//  in and out locations but we'll keep them the same.
boolean RFile::position(long location)
{
    file.seekg((streamoff) location, ios::beg);
    file.seekp((streamoff) location, ios::beg);
    return TRUE;  //What if seek fails????
} */

boolean RFile::read(void *buf, int size)
{
    fp2.read((char *)buf, size);
    if (fp2.fail())
    {
#if !defined(LINUX)
        // Try to handle special case required due to Watcom 11.0 bug.
        if ((fp2.rdstate() == ios::failbit) && (fp2.tellg() == RFile::size()))
            eof2 = TRUE;
#endif
        return FALSE;
    }
    else
        return TRUE;
}

boolean RFile::write(void *buf, int size)
{
    fp2.write((char *)buf, size);
    if (fp2.fail())
        return FALSE;
    else
        return TRUE;
}

boolean RFile::getString(char *buf, int maxSize)
{
    fp2.getline(buf, maxSize, '\n');
    if (fp2.fail())
        return FALSE;
    else
        return TRUE;
}

// This routine returns the size of the file in bytes.
long RFile::size()
{
//    long currentLoc = position();
    long currentLoc = fp2.tellg();
    long retValue;

    //  Must be a better way to do this!  Position to end of file and
    //  return file position number there.  Kluge!
    fp2.seekp(0, ios::end);
    retValue = fp2.tellp();
    position(currentLoc);

    return retValue;
}

// Return a pointer to the suffix of fileName.
char *RFile::suffix()
{
    char *ptr = fileName;

    // Search from the end of fileName to ensure that the correct '.'
    //  character is found.  (ie. Don't be fooled by "../filename.txt")
    if ((ptr = strrchr(fileName, '.')) != NULL)
        return ++ptr;
    else
        return NULL;
}
